/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral;

import com.sun.spot.peripheral.IFlashMemoryDevice;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.squawk.Address;
import com.sun.squawk.Unsafe;
import com.sun.squawk.VM;

class S29PL_Flash
implements IFlashMemoryDevice {
    public static final int S29PL032J = 62;
    public static final int S29PL064J = 126;
    public static final int BIG_SECTOR_SIZE = 65536;
    private static final int FLASH_BASE_ADDR = 0x10000000;
    private static final int PAGE_SIZE = 65536;
    private static final int NUMBER_OF_SMALL_SECTORS_AT_EACH_END = 8;
    private static final int NUMBER_OF_BIG_SECTORS_IN_COMMON = 62;
    private static final int SMALL_SECTOR_SIZE = 8192;
    private static final int ADDRESS_OF_FIRST_BIG_SECTOR = 0x10010000;
    private int numberOfBigSectors;
    private int addressOfFirstSmallSectorAtTop;

    public static int getCommonSectorAddress(int sectorNumber) {
        if (sectorNumber >= 70) {
            throw new IllegalArgumentException("Sector number " + sectorNumber + " is beyond common part");
        }
        return S29PL_Flash.primGetSectorAddress(sectorNumber, 62);
    }

    public static int getCommonSize() {
        return 0x3F0000;
    }

    public static int getCommonLastLargeSector() {
        return 69;
    }

    private static int primGetSectorAddress(int sectorNumber, int numberOfBigSectors) {
        if (sectorNumber < 8) {
            return 0x10000000 + sectorNumber * 8192;
        }
        if (sectorNumber < 8 + numberOfBigSectors) {
            return 0x10010000 + (sectorNumber - 8) * 65536;
        }
        return 0x10010000 + numberOfBigSectors * 65536 + (sectorNumber - 8 - numberOfBigSectors) * 8192;
    }

    S29PL_Flash(int model) {
        this.numberOfBigSectors = model;
        this.addressOfFirstSmallSectorAtTop = 0x10010000 + 65536 * this.numberOfBigSectors;
    }

    public void eraseSectorAtAddress(int address) {
        this.validateAddress(address);
        int count = 0;
        while (!this.eraseSectorPrim(address) || !this.sectorErased(address)) {
            if (count++ <= 5) continue;
            throw new SpotFatalException("Failed to erase flash at address " + address);
        }
    }

    public boolean sectorErased(int address) {
        Address baseAddress = Address.fromPrimitive((int)0x10000000);
        this.validateAddress(address);
        int sectorNum = this.getSectorContainingAddress(address);
        int sectorAddress = this.getSectorAddress(sectorNum);
        int sectorTop = sectorAddress + this.getSectorSize(sectorNum);
        for (int j = sectorAddress; j < sectorTop; j += 8) {
            if (Unsafe.getLongAtWord((Address)baseAddress, (int)(j - 0x10000000 >> 2)) == -1L) continue;
            return false;
        }
        return true;
    }

    public void eraseChip() {
        throw new SpotFatalException("The eraseChip operation is not supported for the S29PL032J device");
    }

    public int getPageSize() {
        return 65536;
    }

    public int getSectorSize(int sectorNum) {
        this.validateSectorNumber(sectorNum);
        if (sectorNum < 8 || sectorNum >= 8 + this.numberOfBigSectors) {
            return 8192;
        }
        return 65536;
    }

    public int getSize() {
        return this.numberOfBigSectors * 65536 + 131072;
    }

    public void read(int address, int numOfBytes, byte[] buffer, int offset) {
        this.validateAddressInRange(address);
        if (!this.isInRange(address + numOfBytes - 1)) {
            throw new IllegalArgumentException("Attempt to read beyond end of memory: 0x" + Integer.toHexString(address + numOfBytes - 1));
        }
        Address addr = Address.fromPrimitive((int)address);
        Unsafe.getBytes((Address)addr, (int)0, (byte[])buffer, (int)offset, (int)numOfBytes);
    }

    public boolean verify(int address, int numOfBytes, byte[] buffer) {
        this.validateAddressInRange(address);
        if (address % 65536 != 0) {
            throw new IllegalArgumentException("Attempt to verify unaligned address: 0x" + Integer.toHexString(address));
        }
        if (numOfBytes > 65536) {
            throw new IllegalArgumentException("Attempt to verify more than one page: " + numOfBytes);
        }
        Address addr = Address.fromPrimitive((int)address);
        for (int i = 0; i < numOfBytes; ++i) {
            if (buffer[i] == (byte)(Unsafe.getByte((Address)addr, (int)i) & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public int getSectorAddress(int sectorNum) {
        return S29PL_Flash.primGetSectorAddress(sectorNum, this.numberOfBigSectors);
    }

    public void write(int address, int numOfBytes, byte[] buffer, int offset) {
        this.validateAddress(address);
        this.validateAddressInRange(address + numOfBytes - 1);
        if (numOfBytes > 65536) {
            throw new IllegalArgumentException("Attempt to write more than one page: " + numOfBytes);
        }
        boolean writtenOk = this.writePrim(address, buffer, numOfBytes, offset);
        if (!writtenOk) {
            throw new SpotFatalException("Failed to write flash at address " + address);
        }
    }

    public int getNumberOfSectors() {
        return this.numberOfBigSectors + 16;
    }

    public int getSectorContainingAddress(int addr) {
        this.validateAddressInRange(addr);
        if (addr < 0x10010000) {
            return (addr - 0x10000000) / 8192;
        }
        if (addr < this.addressOfFirstSmallSectorAtTop) {
            return (addr - 0x10010000) / 65536 + 8;
        }
        return (addr - this.addressOfFirstSmallSectorAtTop) / 8192 + 8 + this.numberOfBigSectors;
    }

    public int getLastSectorAvailableToJava() {
        return 8 + this.numberOfBigSectors - 1;
    }

    public int getNumberOfSectorsInRegion(int startAddress, int length) {
        return 1 + this.getSectorContainingAddress(startAddress + length - 1) - this.getSectorContainingAddress(startAddress);
    }

    private boolean eraseSectorPrim(int address) {
        int result = VM.execSyncIO((int)310, (int)0x10000000, (int)address, (int)0, (int)0, (int)0, (int)0, null, null);
        return result == 1;
    }

    private boolean writePrim(int address, byte[] data, int size, int offset) {
        int result = VM.execSyncIO((int)311, (int)address, (int)size, (int)offset, (int)0, (int)0, (int)0, (Object)data, null);
        return result == 1;
    }

    private void validateAddressInRange(int address) {
        if (!this.isInRange(address)) {
            throw new IllegalArgumentException("Address " + address + " is out of range of flash memory");
        }
    }

    private void validateAddress(int address) {
        this.validateAddressInRange(address);
        if (address % 2 != 0) {
            throw new IllegalArgumentException("Address " + address + " is not even.");
        }
    }

    private boolean isInRange(int address) {
        return address >= 0x10000000 && address < 0x10000000 + this.getSize();
    }

    private void validateSectorNumber(int sectorNum) {
        if (sectorNum < 0 || sectorNum > this.numberOfBigSectors + 16) {
            throw new IllegalArgumentException("Sector number " + sectorNum + " is not valid");
        }
    }
}

