/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.MACCommand;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.IProprietaryMAC;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GetRadioPropertyCommand
extends MACCommand {
    private int attribute;
    private long preparedResult;
    public static final int TRANSMIT_POWER = 0;
    public static final int CHANNEL = 1;
    public static final int PAN_ID = 2;

    public GetRadioPropertyCommand with(int attribute) {
        this.attribute = attribute;
        return this;
    }

    protected void writeParametersOnto(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.attribute);
    }

    public void populateFrom(byte[] inputBuffer, int startingOffset) throws IOException {
        this.attribute = Utils.readBigEndInt(inputBuffer, startingOffset);
    }

    protected void prepareResultOrExecute(I802_15_4_MAC mac) {
        switch (this.attribute) {
            case 0: {
                this.preparedResult = ((IProprietaryMAC)((Object)mac)).getPLMETransmitPower();
                break;
            }
            case 1: {
                this.preparedResult = RadioFactory.getRadioPolicyManager().getChannelNumber();
                break;
            }
            case 2: {
                this.preparedResult = RadioFactory.getRadioPolicyManager().getPanId();
            }
        }
    }

    protected int writePreparedResult(byte[] outputBuffer, int startingOffset) throws IOException {
        Utils.writeBigEndLong(outputBuffer, startingOffset, this.preparedResult);
        return 8;
    }

    protected Object readResultFrom(DataInputStream dataInputStream) throws IOException {
        return new Long(dataInputStream.readLong());
    }

    protected byte classIndicatorByte() {
        return 3;
    }
}

