/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.ICommand;
import com.sun.spot.peripheral.basestation.ICreateExceptions;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MACCommand
implements ICommand {
    private static final int SUCCESS = 1;
    private static final int FAILURE = 0;
    public static final byte GetNullPacketAfterAckWaitCommand = 0;
    public static final byte GetChannelAccessFailureCommand = 1;
    public static final byte GetNoAckCommand = 2;
    public static final byte GetRadioPropertyCommand = 3;
    public static final byte GetWrongAckCommand = 4;
    public static final byte MCPSDataIndicationCommand = 5;
    public static final byte MCPSDataRequestCommand = 6;
    public static final byte MLMEGetCommand = 7;
    public static final byte MLMEResetCommand = 8;
    public static final byte MLMERxEnableCommand = 9;
    public static final byte MLMESetCommand = 10;
    public static final byte MLMEStartCommand = 11;
    public static final byte SetPLMETransmitPowerCommand = 12;
    public static final byte ResetProxyCommand = 101;
    public static final byte ExitCommand = 102;
    private int uid;

    public final void writeOnto(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.classIndicatorByte());
        this.writeParametersOnto(dataOutputStream);
    }

    protected abstract byte classIndicatorByte();

    protected void writeParametersOnto(DataOutputStream dataOutputStream) throws IOException {
    }

    public void populateFrom(byte[] inputBuffer, int startingOffset) throws IOException {
    }

    public int writeResultOnto(byte[] outputBuffer, int startingOffset, I802_15_4_MAC mac) throws IOException {
        try {
            this.prepareResultOrExecute(mac);
            outputBuffer[startingOffset] = 1;
            return this.writePreparedResult(outputBuffer, startingOffset + 1) + 1;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            outputBuffer[startingOffset] = 0;
            int exceptionLength = this.writeExceptionDetails(outputBuffer, startingOffset, ex);
            return exceptionLength + 1;
        }
    }

    private int writeExceptionDetails(byte[] outputBuffer, int startingOffset, Throwable ex) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(ex.getClass().getName());
        dataOutputStream.writeUTF(ex.getMessage() == null ? "" : ex.getMessage());
        byte[] exceptionMsgContent = byteArrayOutputStream.toByteArray();
        System.arraycopy(exceptionMsgContent, 0, outputBuffer, startingOffset + 1, exceptionMsgContent.length);
        return exceptionMsgContent.length;
    }

    protected abstract void prepareResultOrExecute(I802_15_4_MAC var1) throws Throwable;

    protected int writePreparedResult(byte[] outputBuffer, int startingOffset) throws IOException {
        return 0;
    }

    public final Object resultFrom(DataInputStream dataInputStream, ICreateExceptions exceptionCreator) throws Throwable {
        boolean isOk = dataInputStream.readBoolean();
        if (isOk) {
            return this.readResultFrom(dataInputStream);
        }
        String exceptionClassName = dataInputStream.readUTF();
        String exceptionMessage = dataInputStream.readUTF();
        return exceptionCreator.throwException(exceptionClassName, exceptionMessage);
    }

    protected Object readResultFrom(DataInputStream dataInputStream) throws IOException {
        return null;
    }

    public int getUID() {
        return this.uid;
    }

    public long getTimeout() {
        return 0L;
    }

    public void setUID(int uid) {
        this.uid = uid;
    }
}

