/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.MACCommand;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.RadioPacket;
import com.sun.spot.util.Queue;
import java.io.DataInputStream;
import java.io.IOException;

public class MCPSDataIndicationCommand
extends MACCommand {
    protected static final int INCOMING_QUEUE_HIGH_WATER = 1000;
    protected static final int INCOMING_QUEUE_LOW_WATER = 900;
    private Queue incomingPackets;
    private RadioPacket radioPacket;
    protected boolean stopped = false;

    public MCPSDataIndicationCommand with(final I802_15_4_MAC mac) {
        this.incomingPackets = new Queue();
        new Thread(){

            public void run() {
                while (true) {
                    RadioPacket radioPacket = RadioPacket.getDataPacket();
                    mac.mcpsDataIndication(radioPacket);
                    MCPSDataIndicationCommand.this.incomingPackets.put(radioPacket);
                    int size = MCPSDataIndicationCommand.this.incomingPackets.size();
                    if (size <= 1000) continue;
                    System.err.println("[reached HIGH_WATER]");
                    mac.mlmeSet(82, 0L);
                    mac.mlmeRxEnable(0);
                    MCPSDataIndicationCommand.this.stopped = true;
                }
            }
        }.start();
        return this;
    }

    protected void prepareResultOrExecute(I802_15_4_MAC mac) throws InterruptedException {
        this.radioPacket = (RadioPacket)this.incomingPackets.get();
        int size = this.incomingPackets.size();
        if (this.stopped && size < 900) {
            System.err.println("[reached LOW_WATER]");
            mac.mlmeSet(82, 1L);
            this.stopped = false;
        }
    }

    protected int writePreparedResult(byte[] outputBuffer, int startingOffset) throws IOException {
        if (this.radioPacket == null) {
            System.err.println("[MCPSDataIndicationCommand] null packet");
            return 0;
        }
        return this.radioPacket.writeWithoutTimestampOnto(outputBuffer, startingOffset);
    }

    protected Object readResultFrom(DataInputStream dataInputStream) throws IOException {
        RadioPacket packet = RadioPacket.getDataPacket();
        packet.readWithoutTimestampFrom(dataInputStream);
        return packet;
    }

    protected byte classIndicatorByte() {
        return 5;
    }

    public void reset() {
        Queue oldQueue = this.incomingPackets;
        this.incomingPackets = new Queue();
        oldQueue.stop();
    }
}

