/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.ICommand;
import com.sun.spot.peripheral.basestation.MACCommand;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.RadioPacket;
import com.sun.spot.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MCPSDataRequestCommand
extends MACCommand {
    private RadioPacket radioPacket = RadioPacket.getDataPacket();
    private int preparedResult;

    public ICommand with(RadioPacket rp) {
        this.radioPacket = rp;
        return this;
    }

    protected void writeParametersOnto(DataOutputStream dataOutputStream) throws IOException {
        this.radioPacket.writeOnto(dataOutputStream);
    }

    public void populateFrom(byte[] inputBuffer, int startingOffset) throws IOException {
        this.radioPacket.readFrom(inputBuffer, startingOffset);
    }

    protected void prepareResultOrExecute(I802_15_4_MAC mac) {
        this.preparedResult = mac.mcpsDataRequest(this.radioPacket);
    }

    protected int writePreparedResult(byte[] outputBuffer, int startingOffset) throws IOException {
        Utils.writeBigEndInt(outputBuffer, startingOffset, this.preparedResult);
        return 4;
    }

    protected Object readResultFrom(DataInputStream dataInputStream) throws IOException {
        return new Integer(dataInputStream.readInt());
    }

    protected byte classIndicatorByte() {
        return 6;
    }
}

