/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.MACCommand;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MLMEGetCommand
extends MACCommand {
    private int attribute;
    private long preparedResult;

    public MLMEGetCommand with(int attribute) {
        this.attribute = attribute;
        return this;
    }

    protected void writeParametersOnto(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.attribute);
    }

    public void populateFrom(byte[] inputBuffer, int startingOffset) throws IOException {
        this.attribute = Utils.readBigEndInt(inputBuffer, startingOffset);
    }

    protected void prepareResultOrExecute(I802_15_4_MAC mac) {
        this.preparedResult = mac.mlmeGet(this.attribute);
    }

    protected int writePreparedResult(byte[] outputBuffer, int startingOffset) throws IOException {
        Utils.writeBigEndLong(outputBuffer, startingOffset, this.preparedResult);
        return 8;
    }

    protected Object readResultFrom(DataInputStream dataInputStream) throws IOException {
        return new Long(dataInputStream.readLong());
    }

    protected byte classIndicatorByte() {
        return 7;
    }
}

