/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.ICommand;
import com.sun.spot.peripheral.basestation.MACCommand;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.util.Utils;
import java.io.DataOutputStream;
import java.io.IOException;

public class MLMESetCommand
extends MACCommand {
    private int attribute;
    private long value;

    public ICommand with(int attribute, long value) {
        this.attribute = attribute;
        this.value = value;
        return this;
    }

    protected void writeParametersOnto(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.attribute);
        dataOutputStream.writeLong(this.value);
    }

    public void populateFrom(byte[] inputBuffer, int startingOffset) throws IOException {
        this.attribute = Utils.readBigEndInt(inputBuffer, startingOffset);
        this.value = Utils.readBigEndLong(inputBuffer, startingOffset + 4);
    }

    protected void prepareResultOrExecute(I802_15_4_MAC mac) {
        mac.mlmeSet(this.attribute, this.value);
    }

    protected byte classIndicatorByte() {
        return 10;
    }
}

