/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.basestation;

import com.sun.spot.peripheral.basestation.ICommand;
import com.sun.spot.peripheral.basestation.MACCommand;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.util.Utils;
import java.io.DataOutputStream;
import java.io.IOException;

public class MLMEStartCommand
extends MACCommand {
    private short panId;
    private int channel;

    public ICommand with(short panId, int channel) {
        this.panId = panId;
        this.channel = channel;
        return this;
    }

    protected void writeParametersOnto(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.panId);
        dataOutputStream.writeInt(this.channel);
    }

    public void populateFrom(byte[] inputBuffer, int startingOffset) throws IOException {
        this.panId = (short)Utils.readBigEndShort(inputBuffer, startingOffset);
        this.channel = Utils.readBigEndInt(inputBuffer, startingOffset + 2);
    }

    protected void prepareResultOrExecute(I802_15_4_MAC mac) {
        mac.mlmeStart(this.panId, this.channel);
    }

    protected byte classIndicatorByte() {
        return 11;
    }
}

