/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.ota;

import com.sun.spot.flashmanagement.FlashFile;
import com.sun.spot.flashmanagement.IFlashFileInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class OTAFlashFileInfo
implements IFlashFileInfo {
    private String comment;
    private String name;
    private int virtualAddress;
    private boolean isObsolete;
    private long lastModified;
    private int length;

    public OTAFlashFileInfo(byte[] rawInfo) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(rawInfo);
        DataInputStream dis = new DataInputStream(bais);
        this.name = dis.readUTF();
        this.comment = dis.readUTF();
        this.isObsolete = dis.readBoolean();
        this.lastModified = dis.readLong();
        this.length = dis.readInt();
        this.virtualAddress = dis.readInt();
        dis.close();
    }

    public OTAFlashFileInfo(FlashFile file) throws IOException {
        this.name = file.getName();
        this.comment = file.getComment();
        this.virtualAddress = file.getVirtualAddress();
        this.isObsolete = file.isObsolete();
        this.lastModified = file.lastModified();
        this.length = file.length();
    }

    public OTAFlashFileInfo(String comment, String name, int virtualAddress, boolean isObsolete, long lastModified, int length, boolean exists) {
        this.comment = comment;
        this.name = name;
        this.virtualAddress = virtualAddress;
        this.isObsolete = isObsolete;
        this.lastModified = lastModified;
        this.length = length;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public int length() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public int getVirtualAddress() {
        return this.virtualAddress;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(this.name);
        dos.writeUTF(this.comment);
        dos.writeBoolean(this.isObsolete);
        dos.writeLong(this.lastModified);
        dos.writeInt(this.length);
        dos.writeInt(this.virtualAddress);
        dos.flush();
        dos.close();
        return baos.toByteArray();
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.isObsolete()) {
            sb.append(" [obsolete]");
        }
        sb.append(this.getVirtualAddress() == 0 ? " [unmapped]" : " [mapped at 0x" + Integer.toHexString(this.getVirtualAddress()) + "]");
        sb.append(lineSeparator);
        sb.append("    comment: " + this.getComment());
        sb.append(lineSeparator);
        sb.append("    last modified: " + new Date(this.lastModified()));
        sb.append(lineSeparator);
        sb.append("    size: " + this.length());
        sb.append(lineSeparator);
        return sb.toString();
    }
}

