/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.ota;

import com.sun.spot.imp.MIDletDescriptor;
import com.sun.spot.imp.MIDletSuiteDescriptor;
import com.sun.spot.peripheral.IPowerController;
import com.sun.spot.peripheral.ISleepManager;
import com.sun.spot.peripheral.IUSBPowerDaemon;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.peripheral.ota.IOTACommand;
import com.sun.spot.peripheral.ota.IOTACommandHelper;
import com.sun.spot.peripheral.ota.ISpotAdminConstants;
import com.sun.spot.peripheral.ota.IsolateManager;
import com.sun.spot.util.Properties;
import com.sun.spot.util.Utils;
import com.sun.squawk.VM;
import com.sun.squawk.util.StringTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SpotWorldCommand
implements ISpotAdminConstants,
IOTACommand {
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private static final int SECURITY_LEVEL_REQUIRE_OWNERSHIP = 2;
    private static final int SECURITY_LEVEL_ALLOW_ANYONE = 4;

    public int getSecurityLevelFor(String command) {
        if (command.equals("SW-GMS") || command.equals("SW-GPS") || command.equals("SW-GSI") || command.equals("SW-GAS") || command.equals("SW-GWM") || command.equals("SW-APS") || command.equals("SW-AAP")) {
            return 4;
        }
        if (command.equals("SW-SAP") || command.equals("SW-PAP") || command.equals("SW-RAP") || command.equals("SW-STA") || command.equals("SW-SRP") || command.equals("SW-STP") || command.equals("SW-REA") || command.equals("SW-MIA")) {
            return 2;
        }
        return 2;
    }

    public boolean processCommand(String command, DataInputStream params, IOTACommandHelper helper) throws IOException {
        boolean result = false;
        byte[] encodedResponse = null;
        String suiteId = null;
        int midletId = 0;
        String isolateId = null;
        String res = null;
        if (command.equals("SW-GMS")) {
            try {
                int fmem = 0;
                int tmem = 0;
                int idx = 0;
                encodedResponse = new byte[10];
                encodedResponse[idx++] = 1;
                encodedResponse[idx++] = 0;
                fmem = (int)Runtime.getRuntime().freeMemory();
                Utils.writeBigEndInt(encodedResponse, idx, fmem);
                tmem = (int)Runtime.getRuntime().totalMemory();
                Utils.writeBigEndInt(encodedResponse, idx += 4, tmem);
                idx += 4;
            }
            catch (Exception e) {
                System.err.println("getmemstats caught " + e);
                e.printStackTrace();
                helper.sendErrorDetails("Failed: getmemstats caught " + e);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-GPS")) {
            try {
                encodedResponse = this.createPowerStatsResponse();
            }
            catch (Exception e) {
                System.err.println("getpowerstats caught " + e);
                e.printStackTrace();
                encodedResponse = this.createResponse("Failed: getpowerstats caught " + e);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-GSI")) {
            try {
                encodedResponse = this.createSleepInfoResponse();
            }
            catch (Exception e) {
                System.err.println("getsleepinfo caught " + e);
                e.printStackTrace();
                encodedResponse = this.createResponse("Failed: getsleepinfo caught " + e);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-GAS")) {
            try {
                encodedResponse = this.createAvailableSuitesResponse();
            }
            catch (Exception e) {
                System.err.println("getavailablesuites caught " + e);
                e.printStackTrace();
                encodedResponse = this.createResponse("Failed: getavailablesuites caught " + e);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-GWM")) {
            try {
                suiteId = params.readUTF();
                encodedResponse = this.createSuiteManifestResponse(suiteId);
            }
            catch (Exception e) {
                System.err.println("getsuitemanifest caught " + e);
                e.printStackTrace();
                encodedResponse = this.createResponse("Failed: getsuitemanifest caught " + e);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-SAP")) {
            try {
                suiteId = params.readUTF();
                midletId = params.readInt();
                res = IsolateManager.startApp((String)suiteId, (int)midletId);
            }
            catch (Exception e) {
                System.err.println("startapp caught " + e);
                e.printStackTrace();
                res = "Failed: startapp caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-PAP")) {
            try {
                isolateId = params.readUTF();
                res = IsolateManager.pauseApp((String)isolateId);
            }
            catch (Exception e) {
                System.err.println("pauseapp caught " + e);
                e.printStackTrace();
                res = "Failed: pauseapp caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-RAP")) {
            try {
                isolateId = params.readUTF();
                res = IsolateManager.resumeApp((String)isolateId);
            }
            catch (Exception e) {
                System.err.println("resumeapp caught " + e);
                e.printStackTrace();
                res = "Failed: resumeapp caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-STA")) {
            try {
                isolateId = params.readUTF();
                res = IsolateManager.stopApp((String)isolateId);
            }
            catch (Exception e) {
                System.err.println("stopapp caught " + e);
                e.printStackTrace();
                res = "Failed: stopapp caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-AAP")) {
            try {
                encodedResponse = this.createAllAppsStatusResponse(IsolateManager.getAllAppsStatus());
            }
            catch (Exception e) {
                System.err.println("getallappsstatus caught " + e);
                e.printStackTrace();
                encodedResponse = this.createAllAppsStatusResponse(null);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-APS")) {
            try {
                isolateId = params.readUTF();
                res = IsolateManager.getAppStatus((String)isolateId);
            }
            catch (Exception e) {
                System.err.println("getappstatus caught " + e);
                e.printStackTrace();
                res = "Failed: getappstatus caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-SRP")) {
            try {
                isolateId = params.readUTF();
                String address = params.readUTF();
                res = IsolateManager.startRemotePrinting((String)isolateId, (String)address);
            }
            catch (Exception e) {
                System.err.println("startremoteprinting caught " + e);
                e.printStackTrace();
                res = "Failed: startremoteprinting caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-STP")) {
            try {
                isolateId = params.readUTF();
                String address = params.readUTF();
                String port = params.readUTF();
                res = IsolateManager.stopRemotePrinting((String)isolateId, (String)address, (String)port);
            }
            catch (Exception e) {
                System.err.println("stopremoteprinting caught " + e);
                e.printStackTrace();
                res = "Failed: stopremoteprinting caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-MIA")) {
            try {
                isolateId = params.readUTF();
                String address = params.readUTF();
                String copyFlag = params.readUTF().toLowerCase();
                res = IsolateManager.migrateApp((String)isolateId, (String)address, (copyFlag.startsWith("t") ? 1 : 0) != 0);
            }
            catch (Exception e) {
                System.err.println("migrateapp caught " + e);
                e.printStackTrace();
                res = "Failed: migrateapp caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-REA")) {
            try {
                isolateId = params.readUTF();
                String address = params.readUTF();
                res = IsolateManager.receiveApp((String)isolateId, (String)address);
            }
            catch (Exception e) {
                System.err.println("receiveapp caught " + e);
                e.printStackTrace();
                res = "Failed: receiveapp caught " + e;
            }
            encodedResponse = this.createResponse(res);
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        if (command.equals("SW-GSP")) {
            try {
                String listOfKeys = params.readUTF();
                encodedResponse = this.createSpotPropertyResponse(listOfKeys);
            }
            catch (Exception e) {
                System.err.println("getspotproperty caught " + e);
                e.printStackTrace();
                encodedResponse = this.createResponse("Failed: getspotproperty caught " + e);
            }
            helper.sendData(encodedResponse, 0, encodedResponse.length);
            helper.sendPrompt();
            result = true;
        }
        return result;
    }

    private byte[] createPowerStatsResponse() {
        IPowerController pctrl = Spot.getInstance().getPowerController();
        IUSBPowerDaemon usbpd = Spot.getInstance().getUsbPowerDaemon();
        String pctrlRev = pctrl.getRevision();
        byte[] pctrlRevbytes = pctrlRev.getBytes();
        byte[] val = new byte[4 + pctrlRevbytes.length + 22 + 8 + 1];
        int idx = 0;
        val[idx++] = 1;
        val[idx++] = 1;
        Utils.writeBigEndShort(val, idx, pctrlRevbytes.length);
        System.arraycopy(pctrlRevbytes, 0, val, idx += 2, pctrlRevbytes.length);
        Utils.writeBigEndShort(val, idx += pctrlRevbytes.length, (short)pctrl.getIcharge());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getIdischarge());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getIMax());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getVbatt());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getVcc());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getVcore());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getVext());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getVusb());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getPowerStatus());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getStatus());
        Utils.writeBigEndShort(val, idx += 2, (short)pctrl.getStartupTime());
        Utils.writeBigEndLong(val, idx += 2, pctrl.getTime());
        idx += 8;
        val[idx++] = (byte)(usbpd.isUsbPowered() ? 1 : 0);
        return val;
    }

    private byte[] createSleepInfoResponse() {
        ISleepManager sm = Spot.getInstance().getSleepManager();
        byte[] val = new byte[48];
        int idx = 0;
        val[idx++] = 1;
        val[idx++] = 0;
        Utils.writeBigEndInt(val, idx, sm.getDeepSleepCount());
        Utils.writeBigEndLong(val, idx += 4, sm.getMaximumShallowSleepTime());
        Utils.writeBigEndLong(val, idx += 8, sm.getMinimumDeepSleepTime());
        Utils.writeBigEndLong(val, idx += 8, sm.getTotalShallowSleepTime());
        Utils.writeBigEndLong(val, idx += 8, sm.getTotalDeepSleepTime());
        Utils.writeBigEndLong(val, idx += 8, sm.getUpTime());
        idx += 8;
        val[idx++] = (byte)(sm.isDeepSleepEnabled() ? 1 : 2);
        val[idx++] = (byte)(sm.isInDiagnosticMode() ? 1 : 2);
        return val;
    }

    private byte[] createAvailableSuitesResponse() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        MIDletSuiteDescriptor[] suites = MIDletSuiteDescriptor.getAllInstances();
        dos.writeByte(2);
        dos.writeByte(0);
        dos.writeShort(suites.length);
        for (int i = 0; i < suites.length; ++i) {
            dos.writeUTF(suites[i].getURI());
            dos.writeUTF(suites[i].getSourcePath());
            dos.writeInt(suites[i].getLength());
            dos.writeLong(suites[i].getLastModified());
            MIDletDescriptor[] mds = suites[i].getMIDletDescriptors();
            dos.writeInt(mds.length);
            for (int j = mds.length - 1; j >= 0; --j) {
                dos.writeInt(mds[j].getNumber());
                dos.writeUTF(mds[j].getClassName());
            }
        }
        return baos.toByteArray();
    }

    private byte[] createResponse(String str) {
        if (str == null) {
            str = "";
        }
        byte[] strbytes = str.getBytes();
        byte[] val = new byte[4 + strbytes.length];
        int idx = 0;
        val[idx++] = 1;
        val[idx++] = 0;
        Utils.writeBigEndShort(val, idx, (short)strbytes.length);
        System.arraycopy(strbytes, 0, val, idx += 2, strbytes.length);
        idx += strbytes.length;
        return val;
    }

    private byte[] createSuiteManifestResponse(String suiteId) throws Exception {
        Hashtable manifestPropertiesOfSuite;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            manifestPropertiesOfSuite = VM.getManifestPropertiesOfSuite((String)suiteId);
        }
        catch (Error e1) {
            throw new Exception("Could not read manifest for " + suiteId + ". " + e1.getMessage());
        }
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeShort(manifestPropertiesOfSuite.size());
        Enumeration manifestKeys = manifestPropertiesOfSuite.keys();
        while (manifestKeys.hasMoreElements()) {
            String key = (String)manifestKeys.nextElement();
            dos.writeUTF(key);
            dos.writeUTF((String)manifestPropertiesOfSuite.get(key));
        }
        return baos.toByteArray();
    }

    private byte[] createAllAppsStatusResponse(Properties prop) {
        int idx = 4;
        int cnt = 0;
        String key = null;
        String value = null;
        if (prop != null) {
            Enumeration e = prop.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key == null || (value = prop.getProperty(key)) == null) continue;
                ++cnt;
                idx += 2 + key.length() + 2 + value.length();
            }
        }
        byte[] val = new byte[idx];
        idx = 0;
        val[idx++] = 1;
        val[idx++] = 0;
        Utils.writeBigEndShort(val, idx, (short)cnt);
        idx += 2;
        if (prop != null) {
            Enumeration e = prop.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key == null || (value = prop.getProperty(key)) == null) continue;
                byte[] keybytes = key.getBytes();
                byte[] valuebytes = value.getBytes();
                Utils.writeBigEndShort(val, idx, (short)keybytes.length);
                System.arraycopy(keybytes, 0, val, idx += 2, keybytes.length);
                Utils.writeBigEndShort(val, idx += keybytes.length, (short)valuebytes.length);
                System.arraycopy(valuebytes, 0, val, idx += 2, valuebytes.length);
                idx += valuebytes.length;
            }
        }
        return val;
    }

    private byte[] createSpotPropertyResponse(String listOfKeys) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Properties p = Spot.getInstance().getPersistentProperties();
        dos.writeByte(1);
        dos.writeByte(0);
        StringTokenizer stok = new StringTokenizer(listOfKeys, ",");
        int cnt = stok.countTokens();
        String key = null;
        String value = null;
        dos.writeShort(cnt);
        for (int i = 0; i < cnt; ++i) {
            key = stok.nextToken();
            value = p.getProperty(key);
            if (value == null) {
                value = key.equalsIgnoreCase("spot.temperature") ? "25" : (key.equalsIgnoreCase("spot.lightsensor") ? "450" : "");
            }
            dos.writeUTF(key);
            dos.writeUTF(value);
        }
        return baos.toByteArray();
    }
}

