/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.ota;

import com.sun.squawk.util.StringTokenizer;
import java.util.Vector;

public class URL {
    private String protocol = "";
    private String address = "";
    private String port = "";
    private Vector restOfURL = new Vector();
    public static boolean debugging = false;

    public URL(String url) {
        this.init(url);
    }

    public static void test() {
        debugging = true;
        new URL("serial:");
        new URL("serial://");
        new URL("remoteprint://ABCD.ADCF.1234.2345:90");
        new URL("http://ABCD.ADCF.1234.2345:2/foo/bar");
        new URL("snort://localhost/foo");
        new URL("snort://localhost/foo/bar/baz");
        debugging = false;
    }

    public void debug(String line) {
        if (debugging) {
            System.out.println("[URL] ----------------: " + line);
        }
    }

    private void init(String url) {
        String s;
        this.debug("_______________________________________________________________");
        this.debug("  init() " + url);
        StringTokenizer st = new StringTokenizer(url, ":");
        this.protocol = st.nextToken();
        this.debug("  init() protocol " + this.protocol);
        if (!st.hasMoreTokens()) {
            return;
        }
        if (st.countTokens() == 1) {
            s = st.nextToken();
            this.debug(" init() ...with remainder " + s);
            if (s.equals("//")) {
                return;
            }
            s = s.substring(2);
            st = new StringTokenizer(s, "/");
            this.address = st.nextToken();
            this.debug(" init() address " + this.address);
        } else {
            this.address = st.nextToken().substring(2);
            this.debug(" init() address " + this.address);
            this.port = st.nextToken();
            this.debug(" init() port " + this.port);
            if (!st.hasMoreTokens()) {
                return;
            }
            s = st.nextToken();
            this.debug(" init() ...with remainder " + s);
            st = new StringTokenizer(s, "/");
        }
        while (st.hasMoreTokens()) {
            String piece = st.nextToken();
            this.debug(" init() piece " + piece);
            this.restOfURL.addElement(piece);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPort() {
        return this.port;
    }

    public Vector getRestOfURL() {
        return this.restOfURL;
    }

    public static void setDebugging(boolean b) {
        debugging = b;
    }
}

