/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.util.CRC;
import com.sun.spot.util.IEEEAddress;
import com.sun.spot.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RadioPacket {
    private static final int MAX_DATA_LENGTH = 125;
    private static final int BUFFER_SIZE = 128;
    private static final int MAX_HEADER_LENGTH = 23;
    public static final int MIN_PAYLOAD_LENGTH = 102;
    private static final int LENGTH_OFFSET = 0;
    private static final int FCF_OFFSET = 1;
    private static final int DSN_OFFSET = 3;
    private static final int LINK_QUALITY_STEPS = 255;
    private static final int CORRELATION_LOW = 50;
    private static final int CORRELATION_HIGH = 110;
    private static final int FRAME_TYPE = 7;
    private static final int FRAME_TYPE_DATA = 1;
    private static final int FRAME_TYPE_ACK = 2;
    static final int ACK_REQUEST = 32;
    private static final int INTRA_PAN = 64;
    private static final int DST_ADDR_BITS = 3072;
    private static final int DST_ADDR_NONE = 0;
    private static final int DST_ADDR_16 = 2048;
    private static final int DST_ADDR_64 = 3072;
    private static final int SRC_ADDR_BITS = 49152;
    private static final int SRC_ADDR_NONE = 0;
    private static final int SRC_ADDR_16 = 32768;
    private static final int SRC_ADDR_64 = 49152;
    private int destinationPanOffset;
    private int destinationAddressOffset;
    private int sourceAddressOffset;
    private int payloadOffset;
    private boolean dsnOK;
    byte[] buffer = new byte[128];
    int rssi;
    int corr;
    long timestamp;

    public static RadioPacket getDataPacket() {
        RadioPacket result = new RadioPacket();
        result.initAsData();
        return result;
    }

    public static RadioPacket getAckPacket() {
        RadioPacket result = new RadioPacket();
        result.initAsAck();
        return result;
    }

    public static RadioPacket getBroadcastPacket() {
        RadioPacket result = new RadioPacket();
        result.initAsBroadcast();
        return result;
    }

    private RadioPacket() {
    }

    private void initAsData() {
        this.setFrameControl(52321);
        this.setOffsets();
        this.setLength(this.payloadOffset - 1);
    }

    private void setOffsets() {
        int frameControl = this.getFrameControl();
        if (this.isAck()) {
            this.destinationPanOffset = -1;
            this.destinationAddressOffset = -1;
            this.sourceAddressOffset = -1;
            this.payloadOffset = -1;
        } else if (this.isData()) {
            if ((frameControl & 0x40) == 0) {
                throw new IllegalStateException("Inter-pan communication not supported");
            }
            int addrMode = frameControl & 0xC00;
            switch (addrMode) {
                case 0: {
                    this.destinationPanOffset = -1;
                    this.destinationAddressOffset = -1;
                    this.sourceAddressOffset = 4;
                    break;
                }
                case 3072: {
                    this.destinationPanOffset = 4;
                    this.destinationAddressOffset = 6;
                    this.sourceAddressOffset = 14;
                    break;
                }
                case 2048: {
                    this.destinationPanOffset = 4;
                    this.destinationAddressOffset = 6;
                    this.sourceAddressOffset = 8;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported dest addr mode " + addrMode);
                }
            }
            addrMode = frameControl & 0xC000;
            switch (addrMode) {
                case 0: {
                    this.payloadOffset = this.sourceAddressOffset;
                    this.sourceAddressOffset = -1;
                    break;
                }
                case 49152: {
                    this.payloadOffset = this.sourceAddressOffset + 8;
                    break;
                }
                case 32768: {
                    this.payloadOffset = this.sourceAddressOffset + 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported src addr mode " + addrMode);
                }
            }
        }
    }

    private void initAsBroadcast() {
        this.setFrameControl(51265);
        this.setOffsets();
        this.setDestinationAddress(65535L);
        this.setLength(this.payloadOffset - 1);
    }

    private void initAsAck() {
        this.setFrameControl(2);
        this.setLength(3);
        this.setOffsets();
    }

    public long getDestinationAddress() {
        if (this.destinationAddressOffset == -1) {
            throw new IllegalStateException("Field not valid for this packet");
        }
        long result = 0L;
        result = (this.getFrameControl() & 0xC00) == 2048 ? (long)this.getShortAt(this.destinationAddressOffset) : this.getLongAt(this.destinationAddressOffset);
        return result;
    }

    public void setDestinationAddress(long addr) {
        if (this.destinationAddressOffset == -1) {
            throw new IllegalStateException("Field not valid for this packet");
        }
        if ((this.getFrameControl() & 0xC00) == 2048) {
            if (addr > 65535L || addr < 0L) {
                throw new IllegalArgumentException("address uses too many bits for 16-bit mode");
            }
            this.setShortAt(this.destinationAddressOffset, (short)addr);
        } else {
            this.setLongAt(this.destinationAddressOffset, addr);
        }
    }

    public long getSourceAddress() {
        if (this.sourceAddressOffset == -1) {
            throw new IllegalStateException("Field not valid for this packet");
        }
        return this.getLongAt(this.sourceAddressOffset);
    }

    public void setSourceAddress(long addr) {
        if (this.sourceAddressOffset == -1) {
            throw new IllegalStateException("Field not valid for this packet");
        }
        this.setLongAt(this.sourceAddressOffset, addr);
    }

    public int getSourcePanID() {
        return this.getDestinationPanID();
    }

    public int getDestinationPanID() {
        if (this.destinationPanOffset == -1) {
            throw new IllegalStateException("Field not valid for this packet");
        }
        return this.getShortAt(this.destinationPanOffset);
    }

    public void setDestinationPanID(int id) {
        if (this.destinationPanOffset == -1) {
            throw new IllegalStateException("Field not valid for this packet");
        }
        this.setShortAt(this.destinationPanOffset, id);
    }

    public byte getDataSequenceNumber() {
        return this.buffer[3];
    }

    public int getFrameControl() {
        return this.getShortAt(1);
    }

    void setFrameControl(int fc) {
        this.setShortAt(1, fc);
    }

    public byte getMACPayloadAt(int offset) {
        return this.buffer[offset + this.getPayloadOffset()];
    }

    public void setMACPayloadAt(int offset, byte value) {
        this.buffer[offset + this.getPayloadOffset()] = value;
    }

    public void setMACPayloadLength(int macPayloadLength) {
        if (macPayloadLength > this.getMaxMacPayloadSize()) {
            throw new IllegalArgumentException("MAC payload size of " + macPayloadLength + " is too big");
        }
        this.setLength(macPayloadLength + this.getPayloadOffset() - 1);
    }

    public int getLinkQuality() {
        return (this.corr - 50) * 255 / 60;
    }

    public int getCorr() {
        return this.corr;
    }

    public int getRssi() {
        return this.rssi;
    }

    public boolean isSeqOK() {
        return this.dsnOK;
    }

    public void setSeqOK(boolean dsnOK) {
        this.dsnOK = dsnOK;
    }

    public int getMACPayloadLength() {
        return this.getLength() - this.getPayloadOffset() + 1;
    }

    int getLength() {
        return this.buffer[0] & 0xFF;
    }

    void setLength(int l) {
        this.buffer[0] = (byte)l;
    }

    public void decodeFrameControl() {
        if (this.getLength() == 0) {
            throw new SpotFatalException("[RadioPacket] decodeFrameControl decoding a zero-length packet");
        }
        this.setOffsets();
    }

    public void copyFrom(RadioPacket otherRP) {
        this.corr = otherRP.corr;
        this.rssi = otherRP.rssi;
        this.dsnOK = otherRP.dsnOK;
        this.timestamp = otherRP.timestamp;
        this.destinationPanOffset = otherRP.destinationPanOffset;
        this.destinationAddressOffset = otherRP.destinationAddressOffset;
        this.sourceAddressOffset = otherRP.sourceAddressOffset;
        this.payloadOffset = otherRP.payloadOffset;
        for (int i = 0; i <= otherRP.getLength(); ++i) {
            this.buffer[i] = otherRP.buffer[i];
        }
    }

    public void writeOnto(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.corr);
        dataOutputStream.writeByte(this.rssi);
        dataOutputStream.writeLong(this.timestamp);
        dataOutputStream.write(this.buffer, 0, this.getLength() + 1);
    }

    public RadioPacket readFrom(DataInputStream dataInputStream) throws IOException {
        this.corr = dataInputStream.readByte();
        this.rssi = dataInputStream.readByte();
        this.timestamp = dataInputStream.readLong();
        dataInputStream.read(this.buffer, 0, 1);
        dataInputStream.read(this.buffer, 1, this.buffer[0]);
        this.decodeFrameControl();
        return this;
    }

    public RadioPacket readWithoutTimestampFrom(DataInputStream dataInputStream) throws IOException {
        this.corr = dataInputStream.readByte();
        this.rssi = dataInputStream.readByte();
        dataInputStream.read(this.buffer, 0, 1);
        dataInputStream.read(this.buffer, 1, this.buffer[0]);
        this.decodeFrameControl();
        return this;
    }

    public int writeOnto(byte[] outputBuffer, int startingOffset) {
        outputBuffer[startingOffset++] = (byte)this.corr;
        outputBuffer[startingOffset++] = (byte)this.rssi;
        Utils.writeBigEndLong(outputBuffer, startingOffset, this.timestamp);
        System.arraycopy(this.buffer, 0, outputBuffer, startingOffset += 8, this.getLength() + 1);
        return this.getLength() + 11;
    }

    public int writeWithoutTimestampOnto(byte[] outputBuffer, int startingOffset) {
        outputBuffer[startingOffset++] = (byte)this.corr;
        outputBuffer[startingOffset++] = (byte)this.rssi;
        System.arraycopy(this.buffer, 0, outputBuffer, startingOffset, this.getLength() + 1);
        return this.getLength() + 3;
    }

    public RadioPacket readFrom(byte[] inputBuffer, int startingOffset) {
        this.corr = inputBuffer[startingOffset++];
        this.rssi = inputBuffer[startingOffset++];
        this.timestamp = Utils.readBigEndLong(inputBuffer, startingOffset);
        System.arraycopy(inputBuffer, startingOffset += 8, this.buffer, 0, 1);
        System.arraycopy(inputBuffer, startingOffset + 1, this.buffer, 1, this.buffer[0]);
        this.decodeFrameControl();
        return this;
    }

    public boolean isAck() {
        return (this.getFrameControl() & 7) == 2;
    }

    public boolean isData() {
        return (this.getFrameControl() & 7) == 1;
    }

    public boolean ackRequest() {
        return (this.getFrameControl() & 0x20) != 0;
    }

    void setDSN(byte macDSN) {
        this.buffer[3] = macDSN;
    }

    public int getMACPayloadIntAt(int macPayloadOffset) {
        return this.getIntAt(this.getPayloadOffset() + macPayloadOffset);
    }

    public int getMACPayloadBigEndIntAt(int macPayloadOffset) {
        return Utils.readBigEndInt(this.buffer, this.getPayloadOffset() + macPayloadOffset);
    }

    private long getLongAt(int offset) {
        return Utils.readLittleEndLong(this.buffer, offset);
    }

    private int getIntAt(int offset) {
        return Utils.readLittleEndInt(this.buffer, offset);
    }

    public long getMACPayloadLongAt(int macPayloadOffset) {
        return this.getLongAt(this.getPayloadOffset() + macPayloadOffset);
    }

    public long getMACPayloadBigEndLongAt(int macPayloadOffset) {
        return Utils.readBigEndLong(this.buffer, this.getPayloadOffset() + macPayloadOffset);
    }

    private void setLongAt(int offset, long value) {
        Utils.writeLittleEndLong(this.buffer, offset, value);
    }

    public void setMACPayloadIntAt(int macPayloadOffset, int value) {
        Utils.writeLittleEndInt(this.buffer, this.getPayloadOffset() + macPayloadOffset, value);
    }

    public void setMACPayloadBigEndIntAt(int macPayloadOffset, int value) {
        Utils.writeBigEndInt(this.buffer, this.getPayloadOffset() + macPayloadOffset, value);
    }

    public void setMACPayloadLongAt(int macPayloadOffset, long value) {
        this.setLongAt(this.getPayloadOffset() + macPayloadOffset, value);
    }

    private int getShortAt(int offset) {
        return Utils.readLittleEndShort(this.buffer, offset);
    }

    public void setMACPayloadBigEndLongAt(int macPayloadOffset, long value) {
        Utils.writeBigEndLong(this.buffer, this.getPayloadOffset() + macPayloadOffset, value);
    }

    public int getMACPayloadShortAt(int macPayloadOffset) {
        return this.getShortAt(this.getPayloadOffset() + macPayloadOffset);
    }

    public int getMACPayloadBigEndShortAt(int macPayloadOffset) {
        return Utils.readBigEndShort(this.buffer, this.getPayloadOffset() + macPayloadOffset);
    }

    public void setMACPayloadShortAt(int macPayloadOffset, int value) {
        this.setShortAt(this.getPayloadOffset() + macPayloadOffset, value);
    }

    private void setShortAt(int offset, int value) {
        Utils.writeLittleEndShort(this.buffer, offset, value);
    }

    public void setMACPayloadBigEndShortAt(int macPayloadOffset, int value) {
        Utils.writeBigEndShort(this.buffer, this.getPayloadOffset() + macPayloadOffset, value);
    }

    private void setFCS(short s) {
        this.setShortAt(this.getLength() + 1, s);
    }

    public short getFCS() {
        return (short)this.getShortAt(this.getLength() + 1);
    }

    public void calculateAndSetFCS() {
        short crc = CRC.crc(this.buffer, 1, this.getLength());
        this.setFCS(crc);
    }

    public boolean isFCSValid() {
        short crc = CRC.crc(this.buffer, 1, this.getLength());
        return crc == this.getFCS();
    }

    public int getMaxMacPayloadSize() {
        return 125 - this.getPayloadOffset() + 1;
    }

    int getPayloadOffset() {
        if (this.payloadOffset == -1) {
            throw new IllegalStateException("This packet cannot have a payload");
        }
        return this.payloadOffset;
    }

    void dump() {
        byte[] tempBuff = new byte[this.buffer[0] + 1];
        System.arraycopy(this.buffer, 0, tempBuff, 0, tempBuff.length);
        Utils.log(Utils.stringify(tempBuff));
        Utils.log("src addr: " + Long.toString(this.getSourceAddress(), 16) + " [offset=" + this.sourceAddressOffset + "]");
        Utils.log("dest addr: " + (this.destinationAddressOffset == -1 ? "(none)" : Long.toString(this.getDestinationAddress(), 16) + " [offset=" + this.destinationAddressOffset + "]"));
        Utils.log("");
    }

    public String toString() {
        StringBuffer result = new StringBuffer("RP: ");
        if (this.isAck()) {
            result.append("ack ");
        }
        if (this.isData()) {
            result.append("dat ");
        }
        result.append("seq ");
        result.append(this.getDataSequenceNumber());
        result.append(" (");
        result.append(this.getLength());
        result.append("bytes) from ");
        if (!this.isAck()) {
            result.append(IEEEAddress.toDottedHex(this.getSourceAddress()));
            result.append(" to ");
            result.append(IEEEAddress.toDottedHex(this.getDestinationAddress()));
            result.append(" [");
            for (int i = 0; i < this.getMACPayloadLength(); ++i) {
                result.append(i == 0 ? "" : " ");
                result.append(Integer.toHexString(0xFF & this.getMACPayloadAt(i)));
            }
            result.append("]");
        }
        return result.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

