/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.IDriver;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.peripheral.radio.IProprietaryMAC;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.RadioPolicy;
import java.util.Vector;

public class RadioPolicyManager
implements IRadioPolicyManager,
IDriver {
    private short panId;
    private int channelNumber;
    private int outputPower;
    private I802_15_4_MAC macDevice;
    private boolean macStarted = false;
    private Vector allConnections = new Vector();
    private Vector connectionsKeepingRadioOn = new Vector();
    private Vector connectionsRequestingRadioOff = new Vector();
    private boolean radioIsOn = false;
    private boolean radioStateBeforeTearDown;

    public RadioPolicyManager(I802_15_4_MAC macDevice, int initialChannel, short initialPanId, int initialOutputPower) {
        this.macDevice = macDevice;
        this.panId = initialPanId;
        this.channelNumber = initialChannel;
        this.outputPower = initialOutputPower;
    }

    public synchronized void policyHasChanged(IConnectionID conn, RadioPolicy selection) {
        if (!this.allConnections.contains(conn)) {
            throw new IllegalArgumentException("Attempt to change policy for unregistered connection: " + conn);
        }
        this.connectionsKeepingRadioOn.removeElement(conn);
        this.connectionsRequestingRadioOff.removeElement(conn);
        if (selection == RadioPolicy.ON) {
            this.connectionsKeepingRadioOn.addElement(conn);
        } else if (selection == RadioPolicy.OFF) {
            this.connectionsRequestingRadioOff.addElement(conn);
        }
        this.updateRadioState();
    }

    public synchronized void registerConnection(IConnectionID conn) {
        this.allConnections.addElement(conn);
    }

    public synchronized void deregisterConnection(IConnectionID conn) {
        this.allConnections.removeElement(conn);
        this.connectionsKeepingRadioOn.removeElement(conn);
        this.connectionsRequestingRadioOff.removeElement(conn);
        this.updateRadioState();
    }

    public boolean isRadioReceiverOn() {
        return this.radioIsOn;
    }

    public synchronized boolean setRxOn(boolean rxState) {
        if (rxState == this.radioIsOn) {
            return true;
        }
        if (rxState) {
            this.primTurnRxOn();
            return true;
        }
        if (this.connectionsKeepingRadioOn.isEmpty()) {
            this.primTurnRxOff();
            return true;
        }
        return false;
    }

    public String getDriverName() {
        return "RadioPolicyManager";
    }

    public boolean tearDown() {
        this.radioStateBeforeTearDown = this.radioIsOn;
        return this.setRxOn(false);
    }

    public void shutDown() {
    }

    public void setUp() {
        this.setRxOn(this.radioStateBeforeTearDown);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public long getIEEEAddress() {
        return this.macDevice.mlmeGet(368);
    }

    public int getOutputPower() {
        return this.getPLMETransmitPower() << 26 >> 26;
    }

    public short getPanId() {
        return this.panId;
    }

    public void setChannelNumber(int channel) {
        if (channel == this.channelNumber) {
            return;
        }
        if (this.macStarted) {
            this.macDevice.mlmeStart(this.panId, channel);
        }
        this.channelNumber = channel;
    }

    public void setOutputPower(int power) {
        if (power < -32 || power > 31) {
            throw new IllegalArgumentException("output power should be between -32dB and +31dB");
        }
        this.setPLMETransmitPower(power & 0x3F);
        this.outputPower = this.getOutputPower();
    }

    public void setPanId(short pid) {
        if (pid == this.panId) {
            return;
        }
        if (this.macStarted) {
            this.macDevice.mlmeStart(pid, this.channelNumber);
        }
        this.panId = pid;
    }

    public void closeBaseStation() {
        RadioFactory.closeBaseStation();
    }

    Vector getAllConnections() {
        return this.allConnections;
    }

    Vector getConnectionsKeepingRadioOn() {
        return this.connectionsKeepingRadioOn;
    }

    void unsetMacStarted() {
        this.macStarted = false;
    }

    private synchronized void startMAC() {
        if (!this.macStarted) {
            this.macDevice.mlmeStart(this.panId, this.channelNumber);
            this.setPLMETransmitPower(this.outputPower);
            this.macStarted = true;
        }
    }

    private int getPLMETransmitPower() {
        return this.getProprietaryMacDevice().getPLMETransmitPower();
    }

    private IProprietaryMAC getProprietaryMacDevice() {
        return (IProprietaryMAC)((Object)this.macDevice);
    }

    private void setPLMETransmitPower(int power) {
        this.getProprietaryMacDevice().setPLMETransmitPower(power);
    }

    private void updateRadioState() {
        if (!this.connectionsKeepingRadioOn.isEmpty() || this.connectionsRequestingRadioOff.isEmpty() && !this.allConnections.isEmpty()) {
            this.primTurnRxOn();
        } else {
            this.primTurnRxOff();
        }
    }

    private void primTurnRxOn() {
        if (!this.radioIsOn) {
            this.startMAC();
            this.macDevice.mlmeSet(82, 1L);
            this.radioIsOn = true;
        }
    }

    private void primTurnRxOff() {
        if (this.radioIsOn) {
            this.startMAC();
            this.macDevice.mlmeSet(82, 0L);
            this.macDevice.mlmeRxEnable(0);
            this.radioIsOn = false;
        }
    }
}

