/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.resourcesharing;

import com.sun.spot.resourcesharing.IResource;
import com.sun.spot.resourcesharing.IResourceHandle;
import com.sun.spot.resourcesharing.ResourceSharingException;
import com.sun.spot.resourcesharing.ResourceSharingScheme;
import com.sun.spot.resourcesharing.ResourceUnavailableException;
import java.util.Hashtable;

class HandleControl {
    private IResource resource;
    private Hashtable handles = new Hashtable();

    public HandleControl(IResource resource) {
        this.resource = resource;
    }

    public IResourceHandle allocateResource(ResourceSharingScheme scheme, boolean otherIsolateHasLock) throws ResourceUnavailableException, ResourceSharingException {
        IResourceHandle handle = this.resource.getHandle(scheme, otherIsolateHasLock);
        if (this.handles.containsKey(handle)) {
            throw new ResourceSharingException("resource " + this.resource.getResourceName() + " has issued a handle that is still in use");
        }
        this.handles.put(handle, scheme);
        return handle;
    }

    public ResourceSharingScheme getSchemeForHandle(IResourceHandle handle) throws ResourceSharingException {
        this.checkHandle(handle);
        return (ResourceSharingScheme)this.handles.get(handle);
    }

    public void unlock(IResourceHandle handle) throws ResourceSharingException {
        this.checkHandle(handle);
        this.handles.remove(handle);
        this.resource.unlocked(handle);
    }

    private void checkHandle(IResourceHandle handle) {
        if (!this.handles.containsKey(handle)) {
            throw new ResourceSharingException("Attempt to manipulate unregistered handle to " + handle.getResourceName());
        }
    }

    public IResourceHandle lockAdjusted(IResourceHandle handle, ResourceSharingScheme newScheme) throws ResourceSharingException, ResourceUnavailableException {
        this.checkHandle(handle);
        IResourceHandle newHandle = this.resource.lockAdjusted(handle, this.getSchemeForHandle(handle), newScheme);
        this.handles.remove(handle);
        this.handles.put(newHandle, newScheme);
        return newHandle;
    }
}

