/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.resourcesharing;

import com.sun.spot.interisolate.BooleanReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.RequestSender;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.resourcesharing.AdjustLockCommand;
import com.sun.spot.resourcesharing.IResourceRegistryMaster;
import com.sun.spot.resourcesharing.LockCommand;
import com.sun.spot.resourcesharing.RegisterCommand;
import com.sun.spot.resourcesharing.ResourceSharingScheme;
import com.sun.spot.resourcesharing.ResourceUnavailableException;
import com.sun.spot.resourcesharing.UnlockAllCommand;
import com.sun.spot.resourcesharing.UnlockCommand;
import com.sun.squawk.io.mailboxes.NoSuchMailboxException;

public class ProxyResourceRegistryMaster
implements IResourceRegistryMaster {
    public static final String RESOURCE_REGISTRY_SERVER = "RESOURCE_REGISTRY_SERVER";
    private RequestSender requestSender;

    public ProxyResourceRegistryMaster() {
        try {
            this.requestSender = RequestSender.lookup((String)RESOURCE_REGISTRY_SERVER);
        }
        catch (NoSuchMailboxException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public boolean lock(int isolateId, String resourceName, ResourceSharingScheme scheme) throws ResourceUnavailableException {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new LockCommand(isolateId, resourceName, scheme));
        try {
            resultEnvelope.checkForThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ResourceUnavailableException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SpotFatalException("Unexpected exception: " + e);
        }
        return ((BooleanReplyEnvelope)resultEnvelope).getBooleanContents();
    }

    public void register(String resourceName) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new RegisterCommand(resourceName));
        resultEnvelope.checkForRuntimeException();
    }

    public void unlock(int isolateId, String resourceName, ResourceSharingScheme scheme) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new UnlockCommand(isolateId, resourceName, scheme));
        resultEnvelope.checkForRuntimeException();
    }

    public void unlockAllResourcesHeldByIsolate(int isolateId) {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new UnlockAllCommand(isolateId));
        resultEnvelope.checkForRuntimeException();
    }

    public void adjustLock(int isolateId, String resourceName, ResourceSharingScheme oldScheme, ResourceSharingScheme newScheme) throws ResourceUnavailableException {
        ReplyEnvelope resultEnvelope = this.requestSender.send((RequestEnvelope)new AdjustLockCommand(isolateId, resourceName, oldScheme, newScheme));
        try {
            resultEnvelope.checkForThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ResourceUnavailableException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SpotFatalException("Unexpected exception: " + e);
        }
    }
}

