/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.resourcesharing;

import com.sun.spot.resourcesharing.ResourceSharingException;
import com.sun.spot.resourcesharing.ResourceSharingScheme;
import com.sun.spot.resourcesharing.ResourceUnavailableException;

class ResourceControl {
    private Lock highestLock;
    private String resourceName;

    public ResourceControl(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean lock(int isolateId, ResourceSharingScheme scheme) throws ResourceUnavailableException {
        if (this.highestLock != null && !scheme.compatibleWith(this.highestLock.scheme)) {
            throw new ResourceUnavailableException("resource " + this.resourceName + " is already locked by isolate " + this.highestLock.isolateId);
        }
        boolean result = false;
        Lock nextLock = this.highestLock;
        while (nextLock != null) {
            if (nextLock.isolateId != isolateId) {
                result = true;
                break;
            }
            nextLock = nextLock.nextLock;
        }
        Lock newLock = new Lock();
        newLock.scheme = scheme;
        newLock.isolateId = isolateId;
        this.insertIntoList(newLock);
        return result;
    }

    public void unlockAll(int isolateId) throws ResourceSharingException {
        Lock lock;
        while ((lock = this.findLock(isolateId)) != null) {
            this.removeLock(lock);
        }
    }

    public void unlock(int isolateId, ResourceSharingScheme scheme) throws ResourceSharingException {
        Lock lock = this.findLock(isolateId, scheme);
        if (lock == null) {
            throw new ResourceSharingException("cannot find lock for " + this.resourceName + " for isolate " + isolateId);
        }
        this.removeLock(lock);
    }

    public boolean isLockedBy(int isolateId) {
        return this.findLock(isolateId) != null;
    }

    private void removeLock(Lock lock) {
        if (lock == this.highestLock) {
            this.highestLock = lock.nextLock;
        } else {
            Lock nextLock = this.highestLock;
            while (nextLock != null && nextLock.nextLock != lock) {
                nextLock = nextLock.nextLock;
            }
            nextLock.nextLock = lock.nextLock;
        }
    }

    private Lock findLock(int isolateId) {
        Lock nextLock = this.highestLock;
        while (nextLock != null && nextLock.isolateId != isolateId) {
            nextLock = nextLock.nextLock;
        }
        return nextLock;
    }

    private Lock findLock(int isolateId, ResourceSharingScheme scheme) {
        Lock nextLock = this.highestLock;
        while (nextLock != null && (nextLock.isolateId != isolateId || nextLock.scheme != scheme)) {
            nextLock = nextLock.nextLock;
        }
        return nextLock;
    }

    private void insertIntoList(Lock newLock) {
        if (this.highestLock == null) {
            this.highestLock = newLock;
        } else if (this.highestLock.scheme.getRank() < newLock.scheme.getRank()) {
            newLock.nextLock = this.highestLock;
            this.highestLock = newLock;
        } else {
            Lock nextLock = this.highestLock;
            while (nextLock.nextLock != null && nextLock.nextLock.scheme.getRank() >= newLock.scheme.getRank()) {
                nextLock = nextLock.nextLock;
            }
            newLock.nextLock = nextLock.nextLock;
            nextLock.nextLock = newLock;
        }
    }

    private static class Lock {
        Lock nextLock;
        ResourceSharingScheme scheme;
        int isolateId;

        private Lock() {
        }
    }
}

