/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.resourcesharing;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.resourcesharing.HandleControl;
import com.sun.spot.resourcesharing.IResource;
import com.sun.spot.resourcesharing.IResourceHandle;
import com.sun.spot.resourcesharing.IResourceRegistry;
import com.sun.spot.resourcesharing.IResourceRegistryMaster;
import com.sun.spot.resourcesharing.ResourceSharingException;
import com.sun.spot.resourcesharing.ResourceSharingScheme;
import com.sun.spot.resourcesharing.ResourceUnavailableException;
import com.sun.squawk.Isolate;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResourceRegistryChild
implements IResourceRegistry {
    private int isolateId;
    private IResourceRegistryMaster masterRegistry;
    private Hashtable resourceTable = new Hashtable();

    public ResourceRegistryChild(int isolateId, IResourceRegistryMaster masterRegistry) {
        this.isolateId = isolateId;
        this.masterRegistry = masterRegistry;
        Isolate.currentIsolate().addLifecycleListener((Isolate.LifecycleListener)new ExitHook(), 3);
    }

    public synchronized IResourceHandle getResource(String resourceName, ResourceSharingScheme scheme) throws ResourceUnavailableException {
        HandleControl selectedResource = (HandleControl)this.resourceTable.get(resourceName);
        if (selectedResource != null) {
            boolean otherIsolateHasLock = this.masterRegistry.lock(this.isolateId, resourceName, scheme);
            try {
                return selectedResource.allocateResource(scheme, otherIsolateHasLock);
            }
            catch (ResourceUnavailableException e) {
                this.masterRegistry.unlock(this.isolateId, resourceName, scheme);
                throw e;
            }
            catch (RuntimeException e) {
                this.masterRegistry.unlock(this.isolateId, resourceName, scheme);
                throw e;
            }
        }
        throw new ResourceSharingException("unknown resource: " + resourceName);
    }

    public synchronized String[] getResourceNames() {
        Enumeration keys = this.resourceTable.keys();
        String[] result = new String[this.resourceTable.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            result[i++] = (String)keys.nextElement();
        }
        return result;
    }

    public synchronized void register(String resourceName, IResource resource) throws ResourceSharingException {
        if (this.resourceTable.containsKey(resourceName)) {
            throw new ResourceSharingException("resource already registered: " + resourceName);
        }
        this.masterRegistry.register(resourceName);
        this.resourceTable.put(resourceName, new HandleControl(resource));
    }

    public synchronized void unlock(IResourceHandle handle) throws ResourceSharingException {
        HandleControl selectedResource = (HandleControl)this.resourceTable.get(handle.getResourceName());
        if (selectedResource == null) {
            throw new ResourceSharingException("attempt to unlock unknown resource: " + handle.getResourceName());
        }
        this.masterRegistry.unlock(this.isolateId, handle.getResourceName(), selectedResource.getSchemeForHandle(handle));
        selectedResource.unlock(handle);
    }

    public void unlockAllResourcesHeldByIsolate(int isolateId) {
        this.masterRegistry.unlockAllResourcesHeldByIsolate(isolateId);
    }

    public synchronized IResourceHandle adjustLock(IResourceHandle handle, ResourceSharingScheme newScheme) throws ResourceUnavailableException {
        HandleControl selectedResource = (HandleControl)this.resourceTable.get(handle.getResourceName());
        if (selectedResource != null) {
            ResourceSharingScheme oldScheme = selectedResource.getSchemeForHandle(handle);
            if (newScheme == oldScheme) {
                return handle;
            }
            if (!newScheme.compatibleWith(oldScheme)) {
                this.masterRegistry.adjustLock(this.isolateId, handle.getResourceName(), oldScheme, newScheme);
                try {
                    return selectedResource.lockAdjusted(handle, newScheme);
                }
                catch (ResourceUnavailableException e) {
                    this.masterRegistry.adjustLock(this.isolateId, handle.getResourceName(), newScheme, oldScheme);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.masterRegistry.adjustLock(this.isolateId, handle.getResourceName(), newScheme, oldScheme);
                    throw e;
                }
            }
            IResourceHandle newHandle = selectedResource.lockAdjusted(handle, newScheme);
            try {
                this.masterRegistry.adjustLock(this.isolateId, handle.getResourceName(), oldScheme, newScheme);
            }
            catch (ResourceUnavailableException e) {
                throw new SpotFatalException("Internal error: attempt to downgrade lock failed");
            }
            return newHandle;
        }
        throw new ResourceSharingException("attempt to unlock unknown resource: " + handle.getResourceName());
    }

    private class ExitHook
    implements Isolate.LifecycleListener {
        private ExitHook() {
        }

        public void handleLifecycleListenerEvent(Isolate iso, int eventKind) {
            ResourceRegistryChild.this.masterRegistry.unlockAllResourcesHeldByIsolate(ResourceRegistryChild.this.isolateId);
        }
    }
}

