/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.resourcesharing;

import com.sun.spot.resourcesharing.IResourceRegistryMaster;
import com.sun.spot.resourcesharing.ResourceControl;
import com.sun.spot.resourcesharing.ResourceSharingException;
import com.sun.spot.resourcesharing.ResourceSharingScheme;
import com.sun.spot.resourcesharing.ResourceUnavailableException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResourceRegistryMaster
implements IResourceRegistryMaster {
    private Hashtable resourceTable = new Hashtable();

    public synchronized void register(String resourceName) throws ResourceSharingException {
        if (!this.resourceTable.containsKey(resourceName)) {
            this.resourceTable.put(resourceName, new ResourceControl(resourceName));
        }
    }

    public synchronized void unlock(int isolateId, String resourceName, ResourceSharingScheme scheme) throws ResourceSharingException {
        ResourceControl selectedResource = (ResourceControl)this.resourceTable.get(resourceName);
        if (selectedResource == null) {
            throw new ResourceSharingException("attempt to unlock unknown resource: " + resourceName);
        }
        selectedResource.unlock(isolateId, scheme);
    }

    public synchronized boolean lock(int isolateId, String resourceName, ResourceSharingScheme scheme) throws ResourceUnavailableException {
        ResourceControl selectedResource = (ResourceControl)this.resourceTable.get(resourceName);
        if (selectedResource != null) {
            return selectedResource.lock(isolateId, scheme);
        }
        throw new ResourceSharingException("unknown resource: " + resourceName);
    }

    public synchronized void unlockAllResourcesHeldByIsolate(int isolateId) {
        Enumeration resources = this.resourceTable.elements();
        while (resources.hasMoreElements()) {
            ResourceControl resource = (ResourceControl)resources.nextElement();
            if (!resource.isLockedBy(isolateId)) continue;
            try {
                resource.unlockAll(isolateId);
            }
            catch (ResourceSharingException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void adjustLock(int isolateId, String resourceName, ResourceSharingScheme oldScheme, ResourceSharingScheme newScheme) throws ResourceUnavailableException {
        this.unlock(isolateId, resourceName, oldScheme);
        try {
            this.lock(isolateId, resourceName, newScheme);
        }
        catch (ResourceUnavailableException e) {
            this.lock(isolateId, resourceName, oldScheme);
            throw e;
        }
    }
}

