/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.resourcesharing;

public abstract class ResourceSharingScheme {
    public static final ResourceSharingScheme EXCLUSIVE = new ResourceSharingScheme("ex", 40){

        boolean compatibleWith(ResourceSharingScheme scheme) {
            return false;
        }
    };
    public static final ResourceSharingScheme EXCLUSIVE_WRITE = new ResourceSharingScheme("ew", 30){

        boolean compatibleWith(ResourceSharingScheme scheme) {
            return scheme == READ;
        }
    };
    public static final ResourceSharingScheme WRITE = new ResourceSharingScheme("wr", 20){

        boolean compatibleWith(ResourceSharingScheme scheme) {
            return scheme == this || scheme == READ;
        }
    };
    public static final ResourceSharingScheme READ = new ResourceSharingScheme("rd", 10){

        boolean compatibleWith(ResourceSharingScheme scheme) {
            return scheme == this || scheme == WRITE || scheme == EXCLUSIVE_WRITE;
        }
    };
    private String id;
    private int rank;

    private ResourceSharingScheme(String id, int rank) {
        this.id = id;
        this.rank = rank;
    }

    abstract boolean compatibleWith(ResourceSharingScheme var1);

    public String toString() {
        return "ResourceSharingScheme:" + this.id;
    }

    int getRank() {
        return this.rank;
    }

    public static ResourceSharingScheme schemeMatching(ResourceSharingScheme scheme) {
        if (scheme.id.equals(ResourceSharingScheme.EXCLUSIVE.id)) {
            return EXCLUSIVE;
        }
        if (scheme.id.equals(ResourceSharingScheme.EXCLUSIVE_WRITE.id)) {
            return EXCLUSIVE_WRITE;
        }
        if (scheme.id.equals(ResourceSharingScheme.WRITE.id)) {
            return WRITE;
        }
        return READ;
    }
}

