/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.util;

import java.io.IOException;
import java.io.InputStream;

public class CRC {
    private static int[] crc_table = CRC.make_crc_table();

    public static short crc(byte[] buf, int offset, int len) {
        int c = 65535;
        for (int n = offset; n < len + offset; ++n) {
            c = CRC.update_crc(buf[n], c);
        }
        return (short)(c ^ 0xFFFF);
    }

    public static short crc(InputStream stream, int flashedByteCount) throws IOException {
        int c = 65535;
        for (int n = 0; n < flashedByteCount; ++n) {
            c = CRC.update_crc((byte)stream.read(), c);
        }
        return (short)(c ^ 0xFFFF);
    }

    private static int update_crc(byte b, int c) {
        return crc_table[(c ^ b) & 0xFF] ^ c >> 8;
    }

    private static int[] make_crc_table() {
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) != 0) {
                    c = 0x8408 ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            crc_table[n] = c;
        }
        return crc_table;
    }
}

