/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.util;

import com.sun.spot.util.CRC;
import com.sun.spot.util.CrcOutputStream;
import com.sun.spot.util.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class CrcInputStream
extends InputStream {
    private static final int PROBE_RESPONSE = -1073741824;
    private static final long PROBE_TIMEOUT_PERIOD = 200L;
    private byte[] buffer = new byte[0];
    private DataInputStream inData;
    private int byteIndex = 0;
    private int outstandingAck;
    private CrcOutputStream crcOutputStream;
    private byte[] pendingBuffer;
    private int pendingChecksum;

    public CrcInputStream(InputStream inputStream, CrcOutputStream crcOutputStream) {
        this.inData = new DataInputStream(inputStream);
        this.crcOutputStream = crcOutputStream;
    }

    public int available() throws IOException {
        return this.buffer.length - this.byteIndex + (this.pendingBuffer == null ? 0 : this.pendingBuffer.length);
    }

    public int read() throws IOException {
        this.ensureDataAvailable();
        return this.buffer[this.byteIndex++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        this.ensureDataAvailable();
        int bytesToRead = Math.min(this.buffer.length - this.byteIndex, len);
        System.arraycopy(this.buffer, this.byteIndex, b, off, bytesToRead);
        this.byteIndex += bytesToRead;
        return bytesToRead;
    }

    public void close() throws IOException {
        this.inData.close();
    }

    private void ensureDataAvailable() throws IOException {
        while (this.byteIndex == this.buffer.length) {
            while (this.pendingBuffer == null) {
                this.doRead(false);
                Thread.yield();
            }
            this.movePendingToCurrent();
        }
    }

    public int getAck() throws IOException {
        while (this.outstandingAck == 0) {
            this.doRead(true);
            Thread.yield();
        }
        int returnValue = this.outstandingAck & Integer.MAX_VALUE;
        this.outstandingAck = 0;
        return returnValue;
    }

    private synchronized void doRead(boolean ackRequired) throws IOException {
        if (ackRequired && this.outstandingAck != 0) {
            return;
        }
        if (!ackRequired && this.pendingBuffer != null) {
            return;
        }
        int length = this.inData.readInt();
        if (length == 0) {
            Utils.log("[CrcInputStream] Responding to probe");
            this.crcOutputStream.writeAck(-1073741824);
        } else if (length < 0) {
            if (this.outstandingAck != 0) {
                throw new IOException("Received new incoming ack before last ack was read");
            }
            this.outstandingAck = length;
        } else {
            if (length > 0x100000) {
                throw new IOException("Attempt to read unlikely checked byte array size: " + length);
            }
            if (this.pendingBuffer != null) {
                throw new IOException("Received new incoming data before last data was acknowledged");
            }
            byte[] newPendingBuffer = new byte[length];
            this.inData.readFully(newPendingBuffer);
            this.pendingChecksum = this.inData.readShort() & 0xFFFF;
            this.pendingBuffer = newPendingBuffer;
        }
    }

    private void movePendingToCurrent() throws IOException {
        int crc = CRC.crc(this.pendingBuffer, 0, this.pendingBuffer.length) & 0xFFFF;
        this.crcOutputStream.writeAck(crc | Integer.MIN_VALUE);
        if (crc != this.pendingChecksum) {
            this.pendingBuffer = null;
            throw new IOException("Checksum for received checked byte array is incorrect");
        }
        this.buffer = this.pendingBuffer;
        this.pendingBuffer = null;
        this.byteIndex = 0;
    }

    synchronized boolean getProbeResponse() throws IOException {
        long timeout = System.currentTimeMillis() + 200L;
        byte[] result = new byte[4];
        int offset = 0;
        while (System.currentTimeMillis() < timeout && offset < result.length) {
            if (this.inData.available() > 0) {
                offset += this.inData.read(result, offset, result.length - offset);
            }
            Utils.sleep(10L);
        }
        if (offset == result.length) {
            int response = Utils.readBigEndInt(result, 0);
            return response == -1073741824;
        }
        return false;
    }

    void clear() throws IOException {
        while (this.inData.available() > 0) {
            this.inData.skip(this.inData.available());
        }
    }
}

