/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.util;

import com.sun.spot.util.CRC;
import com.sun.spot.util.CrcInputStream;
import com.sun.spot.util.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CrcOutputStream
extends OutputStream {
    static final int DEFAULT_BLOCK_SIZE = 100;
    private static final int PROTOCOL_OVERHEAD = 6;
    private byte[] buffer;
    private byte[] ackBuffer = new byte[4];
    private DataOutputStream outData;
    private int byteCount = 0;
    private CrcInputStream inputStream;
    private int blockSize;

    public CrcOutputStream(OutputStream outputStream, InputStream inputStream) {
        this(outputStream, inputStream, 100);
    }

    public CrcOutputStream(OutputStream outputStream, InputStream inputStream, int blockSize) {
        this.buffer = new byte[blockSize + 6];
        this.blockSize = blockSize;
        this.outData = new DataOutputStream(outputStream);
        this.inputStream = new CrcInputStream(inputStream, this);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void write(int b) throws IOException {
        this.buffer[this.byteCount++ + 4] = (byte)b;
        if (this.byteCount == this.blockSize) {
            this.writeBuffer();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int bytesToWriteThisLoop = Math.min(len, this.blockSize - this.byteCount);
            System.arraycopy(b, off, this.buffer, this.byteCount + 4, bytesToWriteThisLoop);
            this.byteCount += bytesToWriteThisLoop;
            if (this.byteCount == this.blockSize) {
                this.writeBuffer();
            }
            len -= bytesToWriteThisLoop;
            off += bytesToWriteThisLoop;
        }
    }

    public void flush() throws IOException {
        this.writeBuffer();
    }

    public void close() throws IOException {
        this.flush();
        this.outData.close();
    }

    public synchronized boolean probe() throws IOException {
        if (this.probeOnce()) {
            return true;
        }
        boolean secondTryResult = this.probeOnce();
        this.inputStream.clear();
        return secondTryResult;
    }

    private boolean probeOnce() throws IOException {
        this.inputStream.clear();
        this.outData.writeInt(0);
        this.outData.flush();
        return this.inputStream.getProbeResponse();
    }

    synchronized void writeAck(int i) throws IOException {
        Utils.writeBigEndInt(this.ackBuffer, 0, i);
        this.outData.write(this.ackBuffer);
        this.outData.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffer() throws IOException {
        int crc;
        CrcOutputStream crcOutputStream = this;
        synchronized (crcOutputStream) {
            if (this.byteCount == 0) {
                return;
            }
            Utils.writeBigEndInt(this.buffer, 0, this.byteCount);
            crc = CRC.crc(this.buffer, 4, this.byteCount) & 0xFFFF;
            Utils.writeBigEndShort(this.buffer, this.byteCount + 4, crc);
            this.outData.write(this.buffer, 0, this.byteCount + 6);
            this.outData.flush();
            this.byteCount = 0;
        }
        int ackValue = this.inputStream.getAck();
        if (crc != ackValue) {
            throw new IOException("Received incorrect CRC ack of 0x" + Integer.toHexString(ackValue) + " (expected 0x" + Integer.toHexString(crc) + ")");
        }
    }
}

