/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.util;

import com.sun.spot.peripheral.radio.SpotNameLookup;

public class IEEEAddress {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private long address;

    public static String toDottedHex(long address) {
        char[] c = new char[19];
        int i = 60;
        int j = 0;
        while (i >= 0) {
            int digit = (int)(address >> i) & 0xF;
            c[j] = hexDigits[digit];
            if (i % 16 == 0 && i != 0) {
                c[++j] = 46;
            }
            i -= 4;
            ++j;
        }
        return new String(c);
    }

    public static long toLong(String ieeeAddressString) {
        String phyAddr = SpotNameLookup.logicalToPhysical((String)ieeeAddressString);
        long result = IEEEAddress.parseDottedHex(phyAddr);
        try {
            result = result == -1L ? Long.parseLong(phyAddr) : result;
        }
        catch (NumberFormatException e) {
            if (ieeeAddressString.equals(phyAddr)) {
                throw new IllegalArgumentException("'" + ieeeAddressString + "' is not a valid address");
            }
            throw new IllegalArgumentException("'" + ieeeAddressString + "' (" + phyAddr + ") is not a valid address");
        }
        if (result == 0L || result == -1L) {
            throw new IllegalArgumentException("Reserved address: " + ieeeAddressString + " cannot be used here");
        }
        return result;
    }

    public IEEEAddress(long address) {
        this.address = address;
    }

    public IEEEAddress(String ieeeAddressString) {
        long result;
        this.address = result = IEEEAddress.toLong(ieeeAddressString);
    }

    public String asDottedHex() {
        return IEEEAddress.toDottedHex(this.address);
    }

    public long asLong() {
        return this.address;
    }

    public String toString() {
        return this.asDottedHex();
    }

    public boolean equals(Object anObject) {
        return anObject instanceof IEEEAddress && ((IEEEAddress)anObject).address == this.address;
    }

    public int hashCode() {
        return (int)this.address;
    }

    private static long parseDottedHex(String dottedHexAddress) {
        long result = 0L;
        if ((dottedHexAddress = dottedHexAddress + ".").length() != 20) {
            return -1L;
        }
        for (int fromIndex = 0; fromIndex < 20; fromIndex += 5) {
            String hexBlock = dottedHexAddress.substring(fromIndex, fromIndex + 4);
            if (dottedHexAddress.charAt(fromIndex + 4) != '.') {
                return -1L;
            }
            try {
                result = (result << 16) + Long.parseLong(hexBlock, 16);
                continue;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return result;
    }
}

