/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.util;

public class PrettyPrint {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int BYTES_IN_ROW = 16;
    private static final int OFFSET_SIZE = 4;
    private static final int SEPARATOR1_SIZE = 3;
    private static final int SEPARATOR2_SIZE = 2;
    private static final int ASCII_START = 57;
    private static final char PRINTABLE_LOW = ' ';
    private static final char PRINTABLE_HIGH = '~';
    private static final char[] buffer = new char[73];
    private static final char[] hc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String prettyPrint(byte[] b) {
        return PrettyPrint.prettyPrint(b, 0, b.length);
    }

    public static String prettyPrint(byte[] b, int off, int len) {
        String out = "";
        int rows = len / 16;
        for (int i = 0; i < rows; ++i) {
            out = out + new String(PrettyPrint.prettyPrintToCharArray(b, off + i * 16, 16)) + LINE_SEPARATOR;
        }
        if (len % 16 != 0) {
            out = out + new String(PrettyPrint.prettyPrintToCharArray(b, off + rows * 16, len % 16)) + LINE_SEPARATOR;
        }
        return out;
    }

    public static StringBuffer prettyPrint(StringBuffer buf, byte[] b, int off, int len) {
        int rows = len / 16;
        for (int i = 0; i < rows; ++i) {
            buf.append(PrettyPrint.prettyPrintToCharArray(b, off + i * 16, 16));
            buf.append(LINE_SEPARATOR);
        }
        if (len % 16 != 0) {
            buf.append(PrettyPrint.prettyPrintToCharArray(b, off + rows * 16, len % 16));
            buf.append(LINE_SEPARATOR);
        }
        return buf;
    }

    private static char[] prettyPrintToCharArray(byte[] b, int off, int len) {
        int i;
        char[] r = buffer;
        int byteVal = 0;
        int j = 0;
        for (i = 0; i < r.length; ++i) {
            r[i] = 32;
        }
        for (i = 1; i <= 4; ++i) {
            r[j++] = hc[off >> 4 * (4 - i) & 0xF];
        }
        r[j++] = 32;
        r[j++] = 45;
        r[j++] = 32;
        for (i = 0; i < len; ++i) {
            byteVal = b[off + i] & 0xFF;
            r[j++] = hc[byteVal >> 4];
            r[j++] = hc[byteVal & 0xF];
            r[j++] = i == 7 ? 45 : 32;
            r[57 + i] = byteVal < 32 || byteVal > 126 ? 46 : (char)byteVal;
        }
        return r;
    }

    public static void main(String[] args) {
        byte[] test = new byte[]{22, 3, 0, 0, 56, -18, -70, -33, -6, -6, 100, 12, 69, 94, 17, -29, 90, 15, 17, 51, 72, 35, -40, 2, -83, 23, -101, 69, 3, -35, -10, 125, -120, -111, -44, 44, -31, 46, 120, -38, 90, 111, 44, 57, 126, 14, 56, -43, 127, 41, -99, 17, -108, -118, 70, 72, -29, 57, 86, 119, -92};
        System.out.println(PrettyPrint.prettyPrint(test));
    }
}

