/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.util;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.util.CRC;
import com.sun.squawk.VM;
import com.sun.squawk.util.Arrays;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Utils {
    public static int SIZE_OF_SHORT = 2;
    public static int SIZE_OF_INT = 4;
    public static int SIZE_OF_LONG = 8;

    public static void log(String message) {
        if (Utils.isOptionSelected("spot.diagnostics", false)) {
            if (message.length() == 0 || message.charAt(0) != '[') {
                System.err.print("[SpotLib] ");
            }
            System.err.println(message);
        }
    }

    public static byte[] copy(byte[] aByteArray) {
        return Arrays.copy((byte[])aByteArray, (int)0, (int)aByteArray.length, (int)0, (int)aByteArray.length);
    }

    public static int readNumber(String number) {
        return (int)(Utils.readLong(number) & 0xFFFFFFFFL);
    }

    public static long readLong(String number) {
        int radix = 10;
        if (number.startsWith("0x")) {
            number = number.substring(2);
            radix = 16;
        }
        if (number.startsWith("x")) {
            number = number.substring(1);
            radix = 16;
        }
        long answer = Long.parseLong(number, radix);
        return answer;
    }

    public static long readLittleEndLong(byte[] byteArray, int offset) {
        return Utils.readLittleEndNumber(byteArray, offset, SIZE_OF_LONG);
    }

    public static int readLittleEndInt(byte[] byteArray, int offset) {
        return (int)Utils.readLittleEndNumber(byteArray, offset, SIZE_OF_INT);
    }

    public static int readBigEndInt(byte[] byteArray, int offset) {
        return (int)Utils.readBigEndNumber(byteArray, offset, SIZE_OF_INT);
    }

    public static int readLittleEndShort(byte[] byteArray, int offset) {
        return (int)Utils.readLittleEndNumber(byteArray, offset, SIZE_OF_SHORT);
    }

    public static int readBigEndShort(byte[] byteArray, int offset) {
        return (int)Utils.readBigEndNumber(byteArray, offset, SIZE_OF_SHORT);
    }

    public static long readBigEndLong(byte[] byteArray, int offset) {
        return Utils.readBigEndNumber(byteArray, offset, SIZE_OF_LONG);
    }

    public static void writeBigEndLong(byte[] byteArray, int offset, long value) {
        Utils.writeBigEndNumber(byteArray, offset, SIZE_OF_LONG, value);
    }

    public static void writeLittleEndLong(byte[] byteArray, int offset, long value) {
        Utils.writeLittleEndNumber(byteArray, offset, SIZE_OF_LONG, value);
    }

    public static void writeBigEndInt(byte[] byteArray, int offset, int value) {
        Utils.writeBigEndNumber(byteArray, offset, SIZE_OF_INT, value);
    }

    public static void writeLittleEndInt(byte[] byteArray, int offset, int value) {
        Utils.writeLittleEndNumber(byteArray, offset, SIZE_OF_INT, value);
    }

    public static void writeLittleEndShort(byte[] byteArray, int offset, int value) {
        Utils.writeLittleEndNumber(byteArray, offset, SIZE_OF_SHORT, value);
    }

    public static void writeBigEndShort(byte[] byteArray, int offset, int value) {
        Utils.writeBigEndNumber(byteArray, offset, SIZE_OF_SHORT, value);
    }

    private static long readLittleEndNumber(byte[] byteArray, int offset, int numberOfBytes) {
        long result = 0L;
        for (int i = numberOfBytes - 1; i >= 0; --i) {
            result = result << 8 | (long)(byteArray[offset + i] & 0xFF);
        }
        return result;
    }

    private static long readBigEndNumber(byte[] byteArray, int offset, int numberOfBytes) {
        long result = 0L;
        for (int i = 0; i < numberOfBytes; ++i) {
            result = result << 8 | (long)(byteArray[offset + i] & 0xFF);
        }
        return result;
    }

    private static void writeBigEndNumber(byte[] byteArray, int offset, int numberOfBytes, long value) {
        for (int i = numberOfBytes - 1; i >= 0; --i) {
            byteArray[offset + i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    private static void writeLittleEndNumber(byte[] byteArray, int offset, int numberOfBytes, long value) {
        for (int i = 0; i < numberOfBytes; ++i) {
            byteArray[offset + i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    public static int as6BitNumber(int number) {
        return number & 0x3F;
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getManifestProperty(String manifestPropertyName, String valueIfNotInManifest) {
        String value = VM.getManifestProperty((String)manifestPropertyName);
        if (value != null) {
            return value;
        }
        return valueIfNotInManifest;
    }

    public static int getManifestProperty(String manifestPropertyName, int valueIfNotInManifest) {
        String value = VM.getManifestProperty((String)manifestPropertyName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return valueIfNotInManifest;
    }

    public static int getSystemProperty(String propertyName, int valueIfNotDefined) {
        String property = System.getProperty(propertyName);
        if (property == null) {
            return valueIfNotDefined;
        }
        return Integer.parseInt(property);
    }

    public static Vector enumToVector(Enumeration items) {
        Vector result = new Vector();
        while (items.hasMoreElements()) {
            result.addElement(items.nextElement());
        }
        return result;
    }

    public static String stringify(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 6);
        for (int i = 0; i < b.length; ++i) {
            result.append("[");
            String hexString = Integer.toHexString(b[i] & 0xFF);
            if (hexString.length() == 1) {
                result.append('0');
            }
            result.append(hexString);
            result.append("]");
        }
        return result.toString();
    }

    public static String withSpacesReplacedByZeros(String string) {
        StringBuffer result = new StringBuffer();
        boolean previousCharWasSpace = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (previousCharWasSpace) continue;
                previousCharWasSpace = true;
            } else {
                previousCharWasSpace = false;
            }
            result.append(c);
        }
        return result.toString().replace(' ', '\u0000');
    }

    public static boolean isOptionSelected(String optionName, boolean defaultIfAbsent) {
        String option = System.getProperty(optionName);
        return option == null ? defaultIfAbsent : "true".equalsIgnoreCase(option);
    }

    public static String[] split(String s, char marker) {
        int startIndex;
        int partCount = 1;
        for (startIndex = 0; startIndex < s.length(); ++startIndex) {
            if (s.charAt(startIndex) != marker) continue;
            ++partCount;
        }
        String[] result = new String[partCount];
        startIndex = 0;
        for (int i = 0; i < partCount; ++i) {
            int endIndex = s.indexOf(marker, startIndex);
            if (endIndex == -1) {
                endIndex = s.length();
            }
            result[i] = s.substring(startIndex, endIndex);
            startIndex = endIndex + 1;
        }
        return result;
    }

    public static byte[] getDataWithCRC(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        if (length < 0) {
            length = 0;
        }
        if (length > 0x100000 || length < 0) {
            throw new SpotFatalException("Attempt to read unlikely checked byte array size: " + length);
        }
        byte[] data = new byte[length];
        dataInputStream.readFully(data);
        int checksum = dataInputStream.readShort() & 0xFFFF;
        int crc = CRC.crc(data, 0, length) & 0xFFFF;
        if (crc != checksum) {
            throw new SpotFatalException("Checksum for received checked byte array is incorrect");
        }
        return data;
    }

    public static void putDataWithCRC(DataOutputStream dataOutputStream, byte[] data, int offset, int length) throws IOException {
        dataOutputStream.writeInt(length);
        if (length > 0) {
            dataOutputStream.write(data, offset, length);
        }
        dataOutputStream.writeShort(CRC.crc(data, offset, length));
    }
}

