/*
 * Decompiled with CFR 0.152.
 */
package com.growl;

import java.io.IOException;
import java.util.HashSet;

public class GrowlWrapper {
    private String application;
    private HashSet notifications = new HashSet();
    private int state;
    public static final int GROWL_OK = 0;
    public static final int GROWL_NOT_MAC = 1;
    public static final int GROWL_NO_APPLESCRIPT = 2;
    public static final int GROWL_UNAVAILABLE = 3;
    public static final int GROWL_UNEXPECTED_ERROR = 4;

    public GrowlWrapper(String application, String applicationForIcon, String[] allNotifications, String[] defaultNotifications) throws IllegalArgumentException {
        if (application == null || allNotifications == null || defaultNotifications == null) {
            throw new IllegalArgumentException("application,allNotifications and defaultNotifications are required parameters");
        }
        if (allNotifications.length < 1) {
            throw new IllegalArgumentException("Must specify at least one notification type");
        }
        this.application = application;
        int i = 0;
        while (i < allNotifications.length) {
            this.notifications.add(allNotifications[i]);
            ++i;
        }
        i = 0;
        while (i < defaultNotifications.length) {
            if (!this.notifications.contains(defaultNotifications[i])) {
                throw new IllegalArgumentException("Default notifications must be included in the allNotifications array too");
            }
            ++i;
        }
        this.state = 0;
        String lcOSName = System.getProperty("os.name").toLowerCase();
        if (!lcOSName.startsWith("mac os x")) {
            this.state = 1;
        } else {
            Process p = null;
            try {
                p = Runtime.getRuntime().exec("osascript");
            }
            catch (IOException e) {
                this.state = 2;
            }
            if (this.state == 0) {
                try {
                    p.getOutputStream().write(GrowlWrapper.getScript(application, applicationForIcon, allNotifications, defaultNotifications, null, null, null).getBytes("UTF-8"));
                    p.getOutputStream().close();
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (p.getErrorStream().read() != -1) {
                        this.state = 3;
                    }
                }
                catch (IOException e) {
                    this.state = 4;
                }
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public void notify(String notification, String title, String description) throws IllegalArgumentException {
        if (notification == null || title == null || description == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        if (!this.notifications.contains(notification)) {
            throw new IllegalArgumentException("Unknown notification '" + notification + "'");
        }
        if (this.state != 0) {
            return;
        }
        try {
            Process p = Runtime.getRuntime().exec("osascript");
            p.getOutputStream().write(GrowlWrapper.getScript(this.application, null, null, null, notification, title, description).getBytes("UTF-8"));
            p.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String appleScriptQuote(String input) {
        StringBuffer sb = new StringBuffer("\"");
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String getScript(String application, String applicationForIcon, String[] allNotifications, String[] defaultNotifications, String notification, String title, String description) {
        StringBuffer sb = new StringBuffer();
        sb.append("tell application \"GrowlHelperApp\"\n");
        if (allNotifications != null) {
            sb.append("register as application ");
            sb.append(GrowlWrapper.appleScriptQuote(application));
            sb.append(" all notifications {");
            int i = 0;
            while (i < allNotifications.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(GrowlWrapper.appleScriptQuote(allNotifications[i]));
                ++i;
            }
            sb.append("} default notifications {");
            i = 0;
            while (i < defaultNotifications.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(GrowlWrapper.appleScriptQuote(defaultNotifications[i]));
                ++i;
            }
            if (applicationForIcon != null) {
                sb.append("} icon of application ");
                sb.append(GrowlWrapper.appleScriptQuote(applicationForIcon));
            } else {
                sb.append("}");
            }
        }
        if (notification != null) {
            sb.append("\nnotify with name");
            sb.append(GrowlWrapper.appleScriptQuote(notification));
            sb.append(" title ");
            sb.append(GrowlWrapper.appleScriptQuote(title));
            sb.append(" description ");
            sb.append(GrowlWrapper.appleScriptQuote(description));
            sb.append(" application name ");
            sb.append(GrowlWrapper.appleScriptQuote(application));
        }
        sb.append("\nend tell\n");
        return sb.toString();
    }
}

