/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.jme.emulator.events.spi.EventDataProvider;
import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.jme.toolkit.location.script.player.LocationScript;
import com.sun.jme.toolkit.location.script.player.ScriptLocation;
import com.sun.kvem.ExternalEventManager;
import com.sun.kvem.environment.EventGenUI;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.midp.ScriptPanel;
import com.sun.kvem.util.LabeledComponentBlock;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class LocationEventGenPanel
extends JPanel
implements EventGenUI,
ChangeListener,
PropertyChangeListener,
EventDataProvider {
    private static final Logger LOGGER = Logger.getLogger(LocationEventGenPanel.class);
    private static final String STATE = "4000";
    private static final String ORIENTATION = "4100";
    private static final String LOCATION = "4200";
    private static final String ACCURACY = "4300";
    private static final int ORIENTATION_UNSUPPORTED = 0;
    private static final int ORIENTATION_SUPPORTED = 1;
    private static final int ORIENTATION_UNAVAILABLE = 2;
    private EventManagerSpi eventManager;
    private JFrame parent;
    private JComboBox providerState;
    private JComboBox orientationState;
    private JCheckBox magneticOrientation;
    private JSlider pitchSlider;
    private JFormattedTextField pitchField;
    private JSlider rollSlider;
    private JFormattedTextField rollField;
    private JSlider azimuthSlider;
    private JFormattedTextField azimuthField;
    private static JFormattedTextField latField;
    private static JFormattedTextField longField;
    private static JFormattedTextField altField;
    private static JFormattedTextField speedField;
    private static JFormattedTextField courseField;
    private JTextField scriptField;
    private boolean propertyChange;
    private LocationScript loadedLocationScript;
    private boolean invalidScriptName;
    private Random generator;
    private float horizontalAccuracy;
    private float verticalAccuracy;
    private Icon prevWaypointIcon;
    private Icon nextWaypointIcon;
    private Icon stopIcon;
    private Icon pauseIcon;
    private Icon startIcon;
    private Observer locationScriptObserver = new Observer(){

        @Override
        public void update(Observable observable, Object object) {
            LocationEventGenPanel.this.updateLocationFromScript();
        }
    };
    WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            JFormattedTextField[] jFormattedTextFieldArray = new JFormattedTextField[]{latField, longField, altField, speedField, courseField};
            for (int i = 0; i < jFormattedTextFieldArray.length; ++i) {
                LocationEventGenPanel.this.validate(jFormattedTextFieldArray[i]);
            }
        }
    };

    public void setEventManager(EventManagerSpi eventManagerSpi) {
        this.eventManager = eventManagerSpi;
    }

    public void setExternalEventManager(ExternalEventManager externalEventManager) {
        externalEventManager.register((EventGenUI)this);
    }

    public void setPrevWaypointIcon(Icon icon) {
        this.prevWaypointIcon = icon;
    }

    public void setStopIcon(Icon icon) {
        this.stopIcon = icon;
    }

    public void setPauseIcon(Icon icon) {
        this.pauseIcon = icon;
    }

    public void setStartIcon(Icon icon) {
        this.startIcon = icon;
    }

    public void setNextWaypointIcon(Icon icon) {
        this.nextWaypointIcon = icon;
    }

    public void start() {
        try {
            this.createUI();
            this.generator = new Random();
            String string = System.getProperty("lapi.horizontalAccuracy", "0");
            String string2 = System.getProperty("lapi.verticalAccuracy", "0");
            try {
                this.horizontalAccuracy = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.horizontalAccuracy = 0.0f;
            }
            try {
                this.verticalAccuracy = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.verticalAccuracy = 0.0f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getEventData(String string) {
        LOGGER.debug((Object)("Requested event data, code=" + string));
        if (string.equals(STATE)) {
            String string2 = String.valueOf(this.providerState.getSelectedIndex() + 1);
            LOGGER.debug((Object)("State = " + string2));
            return string2;
        }
        if (string.equals(ORIENTATION)) {
            LOGGER.debug((Object)"Requested ORIENTATION");
            switch (this.orientationState.getSelectedIndex()) {
                case 0: {
                    return "false";
                }
                case 1: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.azimuthField.getValue());
                    stringBuffer.append(";");
                    stringBuffer.append(this.magneticOrientation.isSelected());
                    stringBuffer.append(";");
                    stringBuffer.append(this.pitchField.getValue());
                    stringBuffer.append(";");
                    stringBuffer.append(this.rollField.getValue());
                    LOGGER.debug((Object)("Orientation = " + stringBuffer.toString()));
                    return stringBuffer.toString();
                }
                case 2: {
                    return "null";
                }
            }
        }
        if (string.equals(LOCATION)) {
            LOGGER.debug((Object)"Requested LOCATION");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(latField.getValue());
            stringBuffer.append(";");
            stringBuffer.append(longField.getValue());
            stringBuffer.append(";");
            stringBuffer.append(altField.getValue());
            stringBuffer.append(";");
            stringBuffer.append(speedField.getValue());
            stringBuffer.append(";");
            stringBuffer.append(courseField.getValue());
            LOGGER.debug((Object)("Location = " + stringBuffer.toString()));
            return stringBuffer.toString();
        }
        if (string.equals(ACCURACY)) {
            LOGGER.debug((Object)"Requested LOCATION");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.generator.nextFloat() * this.horizontalAccuracy);
            stringBuffer.append(";");
            stringBuffer.append(this.generator.nextFloat() * this.verticalAccuracy);
            LOGGER.debug((Object)("Accuracy = " + stringBuffer.toString()));
            return stringBuffer.toString();
        }
        LOGGER.warn((Object)"Unrecognized code");
        return null;
    }

    private void updateLocationFromScript() {
        ScriptLocation scriptLocation = this.loadedLocationScript.getCurrentLocation();
        if (scriptLocation != null) {
            latField.setValue(new Double(scriptLocation.getLatitude()));
            longField.setValue(new Double(scriptLocation.getLongitude()));
            altField.setValue(new Float(scriptLocation.getAltitude()));
            speedField.setValue(new Float(this.loadedLocationScript.getCurrentSpeed()));
            courseField.setValue(new Float(scriptLocation.getCourse()));
            this.eventManager.injectSystemEvent(Integer.parseInt(LOCATION));
        }
    }

    private void updateSliderStates() {
        boolean bl = this.orientationState.getSelectedIndex() == 1;
        this.azimuthSlider.setEnabled(bl);
        this.azimuthField.setEnabled(bl);
        this.rollSlider.setEnabled(bl);
        this.pitchSlider.setEnabled(bl);
        this.rollField.setEnabled(bl);
        this.pitchField.setEnabled(bl);
    }

    private void createUI() {
        JPanel jPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(jPanel));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        LabeledComponentBlock labeledComponentBlock = new LabeledComponentBlock();
        labeledComponentBlock.setBorder(BorderFactory.createTitledBorder(ToolkitResources.getString((String)"LAPI.PROVIDER")));
        this.providerState = new JComboBox<String>(new String[]{ToolkitResources.getString((String)"LAPI.PROVIDER_STATE_AVAILABLE"), ToolkitResources.getString((String)"LAPI.PROVIDER_STATE_UNAVAILABLE"), ToolkitResources.getString((String)"LAPI.PROVIDER_STATE_NO_SERVICE")});
        this.providerState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocationEventGenPanel.this.eventManager.injectSystemEvent(Integer.parseInt(LocationEventGenPanel.STATE) + LocationEventGenPanel.this.providerState.getSelectedIndex() + 1);
            }
        });
        labeledComponentBlock.addRow(ToolkitResources.getString((String)"LAPI.PROVIDER_STATE"), this.providerState);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)labeledComponentBlock, gridBagConstraints);
        LabeledComponentBlock labeledComponentBlock2 = new LabeledComponentBlock();
        labeledComponentBlock2.setBorder(BorderFactory.createTitledBorder(ToolkitResources.getString((String)"LAPI.PROVIDER_ORIENTATION")));
        this.orientationState = new JComboBox<String>(new String[]{ToolkitResources.getString((String)"LAPI.PROVIDER_ORIENTATION_UNSUPPORTED"), ToolkitResources.getString((String)"LAPI.PROVIDER_ORIENTATION_SUPPORTED"), ToolkitResources.getString((String)"LAPI.PROVIDER_ORIENTATION_UNAVAILABLE")});
        this.orientationState.setSelectedIndex(1);
        labeledComponentBlock2.addRow(ToolkitResources.getString((String)"LAPI.ORIENTATION_STATE"), this.orientationState);
        this.azimuthSlider = this.createJSlider(0, 360, 0, 60, 15);
        this.azimuthSlider.addChangeListener(this);
        this.azimuthField = this.createSliderField(0.0f, 359.99f);
        this.azimuthField.addPropertyChangeListener(this);
        labeledComponentBlock2.addRow(ToolkitResources.getString((String)"LAPI.AZIMUTH"), this.azimuthSlider, this.azimuthField);
        this.pitchSlider = this.createJSlider(-90, 90, 0, 30, 10);
        this.pitchSlider.addChangeListener(this);
        this.pitchField = this.createSliderField(-90.0f, 90.0f);
        this.pitchField.addPropertyChangeListener(this);
        labeledComponentBlock2.addRow(ToolkitResources.getString((String)"LAPI.PITCH"), this.pitchSlider, this.pitchField);
        this.rollSlider = this.createJSlider(-180, 180, 0, 60, 15);
        this.rollSlider.addChangeListener(this);
        this.rollField = this.createSliderField(-180.0f, 179.99f);
        this.rollField.addPropertyChangeListener(this);
        labeledComponentBlock2.addRow(ToolkitResources.getString((String)"LAPI.ROLL"), this.rollSlider, this.rollField);
        this.orientationState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocationEventGenPanel.this.updateSliderStates();
            }
        });
        this.magneticOrientation = new JCheckBox(ToolkitResources.getString((String)"LAPI.MAGNETIC_ORIENTATION"));
        this.magneticOrientation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocationEventGenPanel.this.eventManager.injectSystemEvent(Integer.parseInt(LocationEventGenPanel.ORIENTATION));
            }
        });
        labeledComponentBlock2.addRow(null, this.magneticOrientation);
        jPanel.add((Component)labeledComponentBlock2, gridBagConstraints);
        LabeledComponentBlock labeledComponentBlock3 = new LabeledComponentBlock();
        labeledComponentBlock3.setBorder(BorderFactory.createTitledBorder(ToolkitResources.getString((String)"LAPI.DEVICE_LOCATION")));
        latField = this.createFormattedField(-90.0f, 90.0f);
        longField = this.createFormattedField(-180.0f, 179.99998f);
        altField = this.createFormattedField(Float.NEGATIVE_INFINITY, Float.MAX_VALUE);
        speedField = this.createFormattedField(0.0f, Float.MAX_VALUE);
        courseField = this.createFormattedField(0.0f, 360.0f);
        JButton jButton = new JButton(ToolkitResources.getString((String)"LAPI.SEND"));
        jButton.setToolTipText(ToolkitResources.getString((String)"LAPI.TOOLTIP_SEND"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocationEventGenPanel.this.eventManager.injectSystemEvent(Integer.parseInt(LocationEventGenPanel.LOCATION));
            }
        });
        labeledComponentBlock3.addRow(ToolkitResources.getString((String)"LAPI.LAT"), latField);
        labeledComponentBlock3.addRow(ToolkitResources.getString((String)"LAPI.LONG"), longField);
        labeledComponentBlock3.addRow(ToolkitResources.getString((String)"LAPI.ALT"), altField);
        labeledComponentBlock3.addRow(ToolkitResources.getString((String)"LAPI.SPEED"), speedField);
        labeledComponentBlock3.addRow(ToolkitResources.getString((String)"LAPI.COURSE"), courseField);
        labeledComponentBlock3.addRow(null, new int[0], jButton);
        labeledComponentBlock3.addRow(null, new JSeparator());
        this.scriptField = new JTextField(20);
        final ScriptNavigatorPanel scriptNavigatorPanel = new ScriptNavigatorPanel(new Icon[]{this.prevWaypointIcon, this.startIcon, this.pauseIcon, this.stopIcon, this.nextWaypointIcon});
        this.scriptField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.eventResponse();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.eventResponse();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.eventResponse();
            }

            private void eventResponse() {
                if (LocationEventGenPanel.this.loadedLocationScript != null) {
                    LocationEventGenPanel.this.loadedLocationScript.deleteLocationChangeObserver(LocationEventGenPanel.this.locationScriptObserver);
                    LocationEventGenPanel.this.loadedLocationScript.deleteStateChangeObserver(LocationEventGenPanel.this.locationScriptObserver);
                    LocationEventGenPanel.this.loadedLocationScript = null;
                    scriptNavigatorPanel.setLocationScript(LocationEventGenPanel.this.loadedLocationScript);
                    return;
                }
                LocationEventGenPanel.this.invalidScriptName = false;
                scriptNavigatorPanel.updateButtons();
            }
        });
        JButton jButton2 = LocationEventGenPanel.createButton(ToolkitResources.getString((String)"LAPI.BROWSE_SCRIPT"), ToolkitResources.getString((String)"LAPI.BROWSE_SCRIPT_SHORTCUT"), ToolkitResources.getString((String)"LAPI.BROWSE_SCRIPT_TOOLTIP"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmartFileChooser smartFileChooser = new SmartFileChooser(ToolkitDirs.APPS);
                smartFileChooser.putClientProperty("JFileChooser.appBundleIsTraversable", "always");
                if (smartFileChooser.showOpenDialog(LocationEventGenPanel.this.parent) == 0) {
                    LocationEventGenPanel.this.scriptField.setText(smartFileChooser.getSelectedFile().toString());
                }
            }
        });
        labeledComponentBlock3.addRow(ToolkitResources.getString((String)"LAPI.SCRIPT"), this.scriptField, jButton2);
        labeledComponentBlock3.addRow(null, scriptNavigatorPanel);
        jPanel.add((Component)labeledComponentBlock3, gridBagConstraints);
        this.updateSliderStates();
    }

    public JPanel getGUI() {
        return this;
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"LOCATION");
    }

    private void validate(JFormattedTextField jFormattedTextField) {
        try {
            jFormattedTextField.commitEdit();
        }
        catch (ParseException parseException) {
            jFormattedTextField.setValue(jFormattedTextField.getValue());
        }
    }

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
        jFrame.addWindowListener(this.windowListener);
    }

    private JFormattedTextField createFormattedField(float f, float f2) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(9);
        numberFormat.setMinimumFractionDigits(1);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(new Float(f));
        numberFormatter.setMaximum(new Float(f2));
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        return jFormattedTextField;
    }

    private JFormattedTextField createSliderField(float f, float f2) {
        boolean bl = false;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(new Float(f));
        numberFormatter.setMaximum(new Float(f2));
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        jFormattedTextField.setValue(new Float(0.0f));
        jFormattedTextField.setColumns(4);
        jFormattedTextField.setMaximumSize(new Dimension(30, 30));
        return jFormattedTextField;
    }

    private JSlider createJSlider(int n, int n2, int n3, int n4, int n5) {
        JSlider jSlider = new JSlider(n, n2, n3);
        jSlider.setMajorTickSpacing(n4);
        jSlider.setMinorTickSpacing(n5);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        return jSlider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (this.propertyChange) {
            this.propertyChange = false;
            return;
        }
        if (jSlider.equals(this.pitchSlider)) {
            this.pitchField.setValue(new Float(n));
        }
        if (jSlider.equals(this.azimuthSlider)) {
            if (n == 360) {
                this.azimuthField.setValue(Float.valueOf(359.99f));
            } else {
                this.azimuthField.setValue(new Float(n));
            }
        }
        if (jSlider.equals(this.rollSlider)) {
            if (n == 180) {
                this.rollField.setValue(Float.valueOf(179.99f));
            } else {
                this.rollField.setValue(new Float(n));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)propertyChangeEvent.getSource();
            this.propertyChange = true;
            Number number = (Number)propertyChangeEvent.getNewValue();
            if (jFormattedTextField.equals(this.pitchField)) {
                this.pitchSlider.setValue(number.intValue());
            }
            if (jFormattedTextField.equals(this.azimuthField)) {
                this.azimuthSlider.setValue(number.intValue());
            }
            if (jFormattedTextField.equals(this.rollField)) {
                this.rollSlider.setValue(number.intValue());
            }
            this.eventManager.injectSystemEvent(Integer.parseInt(ORIENTATION));
        }
    }

    private static JButton createButton(String string, String string2, String string3) {
        JButton jButton = new JButton(string);
        if (string2 != null && string2.length() > 0) {
            jButton.setMnemonic(string2.charAt(0));
        }
        jButton.setToolTipText(string3);
        return jButton;
    }

    private class ScriptNavigatorPanel
    extends ScriptPanel {
        ScriptNavigatorPanel(Icon[] iconArray) {
            super(iconArray);
        }

        @Override
        protected boolean enableStartButton() {
            if (super.enableStartButton()) {
                return true;
            }
            return !LocationEventGenPanel.this.invalidScriptName && LocationEventGenPanel.this.scriptField.getText().length() > 0 && LocationEventGenPanel.this.loadedLocationScript == null;
        }

        @Override
        protected void startButtonAction() {
            if (LocationEventGenPanel.this.loadedLocationScript == null) {
                try {
                    LocationEventGenPanel.this.loadedLocationScript = LocationScript.load((InputStream)new FileInputStream(LocationEventGenPanel.this.scriptField.getText()));
                    LocationEventGenPanel.this.updateLocationFromScript();
                    LocationEventGenPanel.this.loadedLocationScript.addLocationChangeObserver(LocationEventGenPanel.this.locationScriptObserver);
                    LocationEventGenPanel.this.loadedLocationScript.addStateChangeObserver(LocationEventGenPanel.this.locationScriptObserver);
                    this.setLocationScript(LocationEventGenPanel.this.loadedLocationScript);
                    if (!super.enableStartButton()) {
                        JOptionPane.showMessageDialog(LocationEventGenPanel.this, ToolkitResources.getString((String)"LAPI.SCRIPT_NO_WAYPOINTS"), ToolkitResources.getString((String)"ERROR"), 0);
                        return;
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(LocationEventGenPanel.this, ToolkitResources.getString((String)"LAPI.SCRIPT_LOADING_FAILED"), ToolkitResources.getString((String)"ERROR"), 0);
                    LocationEventGenPanel.this.invalidScriptName = true;
                    this.updateButtons();
                    return;
                }
            }
            super.startButtonAction();
        }
    }
}

