/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.jme.toolkit.location.script.player.LocationScript;
import com.sun.jme.toolkit.location.script.player.ScriptLocation;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScriptPanel
extends JPanel {
    private JSlider timeSlider = new JSlider();
    private JButton prevWaypointButton = new JButton();
    private JButton stopButton = new JButton();
    private JButton pauseButton = new JButton();
    private JButton startButton = new JButton();
    private JButton nextWaypointButton = new JButton();
    private String timeString = ToolkitResources.getString((String)"LAPI.SCRIPT_TIME");
    private JLabel timeLabel = new JLabel(this.timeString);
    private JButton[][] navComponents;
    private static final int OUTER_GAP = 4;
    private static final int INNER_GAP = 1;
    private static final int GRP_INNER = 0;
    private static final int GRP_FIRST = 1;
    private static final int GRP_LAST = 2;
    private static final int CTL_INNER = 0;
    private static final int CTL_FIRST = 1;
    private static final int CTL_LAST = 2;
    private static final NavConstraints[][] NAV_CONSTRAINS_TABLE = new NavConstraints[][]{{new NavConstraints(1, 1, 0, 0, 10), new NavConstraints(4, 1, 1, 0, 13), new NavConstraints(1, 4, 1, 0, 17), new NavConstraints(4, 4, 1, 0, 10)}, {new NavConstraints(1, 1, 0, 0, 10), new NavConstraints(0, 1, 0, 0, 10), new NavConstraints(1, 4, 1, 0, 17), new NavConstraints(0, 4, 1, 0, 17)}, {new NavConstraints(1, 1, 0, 0, 10), new NavConstraints(4, 1, 1, 0, 13), new NavConstraints(1, 0, 0, 0, 10), new NavConstraints(4, 0, 1, 0, 13)}, {new NavConstraints(1, 1, 0, 0, 10), new NavConstraints(0, 1, 1, 0, 13), new NavConstraints(1, 0, 1, 0, 17), new NavConstraints(0, 0, 1, 0, 10)}};
    private LocationScript locationScript;
    private Observer locationChangeObserver = new Observer(){

        @Override
        public void update(Observable observable, Object object) {
            long l = ScriptPanel.this.locationScript.getCurrentLocation().getTime();
            ScriptPanel.this.setTimeLabel(l);
            ScriptPanel.this.timeSlider.setValue((int)l);
            ScriptPanel.this.updateButtons();
        }
    };
    private Observer stateChangeObserver = new Observer(){

        @Override
        public void update(Observable observable, Object object) {
            ScriptPanel.this.updateButtons();
        }
    };

    private void setButtonIcons(Icon[] iconArray) {
        JButton[] jButtonArray = new JButton[]{this.prevWaypointButton, this.startButton, this.pauseButton, this.stopButton, this.nextWaypointButton};
        for (int i = 0; i < jButtonArray.length; ++i) {
            jButtonArray[i].setIcon(iconArray[i]);
        }
    }

    public ScriptPanel(Icon[] iconArray) {
        super(new GridBagLayout());
        this.setButtonIcons(iconArray);
        this.navComponents = new JButton[][]{{this.prevWaypointButton}, {this.stopButton, this.pauseButton, this.startButton}, {this.nextWaypointButton}};
        int n = 0;
        Insets insets = new Insets(-2, -2, -2, -2);
        for (int i = 0; i < this.navComponents.length; ++i) {
            for (int j = 0; j < this.navComponents[i].length; ++j) {
                this.navComponents[i][j].setMargin(insets);
                Dimension dimension = this.navComponents[i][j].getPreferredSize();
                if (n >= dimension.width) continue;
                n = dimension.width;
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.timeLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 0, 4, 0);
        this.add((Component)this.timeSlider, gridBagConstraints);
        Dimension dimension = new Dimension(n, n);
        gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        for (int i = 0; i < this.navComponents.length; ++i) {
            int n3 = 0;
            if (i == 0) {
                n3 |= 1;
            }
            if (i == this.navComponents.length - 1) {
                n3 |= 2;
            }
            int n4 = 0;
            while (n4 < this.navComponents[i].length) {
                int n5 = 0;
                if (n4 == 0) {
                    n5 |= 1;
                }
                if (n4 == this.navComponents[i].length - 1) {
                    n5 |= 2;
                }
                gridBagConstraints.insets = new Insets(4, NAV_CONSTRAINS_TABLE[n3][n5].getLeft(), 0, NAV_CONSTRAINS_TABLE[n3][n5].getRight());
                gridBagConstraints.weightx = NAV_CONSTRAINS_TABLE[n3][n5].getWeight();
                gridBagConstraints.fill = NAV_CONSTRAINS_TABLE[n3][n5].getFill();
                gridBagConstraints.anchor = NAV_CONSTRAINS_TABLE[n3][n5].getAnchor();
                this.navComponents[i][n4].setMinimumSize(dimension);
                this.navComponents[i][n4].setMaximumSize(dimension);
                this.navComponents[i][n4].setPreferredSize(dimension);
                this.add((Component)this.navComponents[i][n4], gridBagConstraints);
                ++n4;
                ++n2;
            }
        }
        this.prevWaypointButton.setToolTipText(ToolkitResources.getString((String)"LAPI.TOOLTIP_PREVWP"));
        this.stopButton.setToolTipText(ToolkitResources.getString((String)"LAPI.TOOLTIP_STOP"));
        this.pauseButton.setToolTipText(ToolkitResources.getString((String)"LAPI.TOOLTIP_PAUSE"));
        this.startButton.setToolTipText(ToolkitResources.getString((String)"LAPI.TOOLTIP_START"));
        this.nextWaypointButton.setToolTipText(ToolkitResources.getString((String)"LAPI.TOOLTIP_NEXTWP"));
        this.resetTimeSlider();
        this.updateButtons();
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.startButtonAction();
            }
        });
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.locationScript.stop();
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScriptPanel.this.locationScript.getCurrentState() == 1) {
                    ScriptPanel.this.locationScript.stop();
                }
                ScriptPanel.this.locationScript.moveToFirstWaypoint();
            }
        });
        this.nextWaypointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.locationScript.moveToNextWaypoint();
            }
        });
        this.prevWaypointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.locationScript.moveToPreviousWaypoint();
            }
        });
        this.timeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ScriptPanel.this.locationScript != null) {
                    ScriptPanel.this.locationScript.setTime((long)ScriptPanel.this.timeSlider.getValue());
                }
            }
        });
    }

    public void setLocationScript(LocationScript locationScript) {
        if (this.locationScript != null) {
            if (this.locationScript.getCurrentState() == 1) {
                this.locationScript.stop();
            }
            this.locationScript.deleteLocationChangeObserver(this.locationChangeObserver);
            this.locationScript.deleteStateChangeObserver(this.stateChangeObserver);
        }
        this.locationScript = locationScript;
        if (this.locationScript == null) {
            this.resetTimeSlider();
            this.updateButtons();
            return;
        }
        this.locationScript.addLocationChangeObserver(this.locationChangeObserver);
        this.locationScript.addStateChangeObserver(this.stateChangeObserver);
        ScriptLocation scriptLocation = this.locationScript.getFirstWaypoint();
        ScriptLocation scriptLocation2 = this.locationScript.getLastWaypoint();
        if (scriptLocation == null) {
            this.resetTimeSlider();
        } else if (scriptLocation.equals((Object)scriptLocation2)) {
            this.resetTimeSlider();
            this.setTimeLabel(scriptLocation.getTime());
        } else {
            int n = (int)scriptLocation.getTime();
            int n2 = (int)scriptLocation2.getTime();
            int n3 = (n2 - n) / 10;
            int n4 = n3 / 2;
            this.timeSlider.setMinimum(n);
            this.timeSlider.setMaximum(n2);
            this.timeSlider.setMajorTickSpacing(n3);
            this.timeSlider.setMinorTickSpacing(n4);
            this.timeSlider.setPaintTicks(n4 > 0);
            this.setTimeLabel(n);
            this.timeSlider.setValue(n);
            this.timeSlider.setEnabled(true);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.locationScript == null) {
            this.prevWaypointButton.setEnabled(false);
            this.stopButton.setEnabled(false);
            this.pauseButton.setEnabled(false);
            this.nextWaypointButton.setEnabled(false);
        } else {
            boolean bl = this.locationScript.isFirstLocation();
            boolean bl2 = this.locationScript.isLastLocation();
            boolean bl3 = this.locationScript.getCurrentState() == 1;
            this.prevWaypointButton.setEnabled(!bl);
            this.stopButton.setEnabled(bl3 || !bl && !bl2);
            this.pauseButton.setEnabled(bl3);
            this.nextWaypointButton.setEnabled(!bl2);
        }
        this.startButton.setEnabled(this.enableStartButton());
    }

    protected boolean enableStartButton() {
        if (this.locationScript == null) {
            return false;
        }
        boolean bl = this.locationScript.isFirstLocation();
        boolean bl2 = this.locationScript.isLastLocation();
        boolean bl3 = this.locationScript.getCurrentState() == 1;
        return !bl3 && (!bl || !bl2);
    }

    protected void startButtonAction() {
        if (this.locationScript.isLastLocation()) {
            this.locationScript.moveToFirstWaypoint();
        }
        this.locationScript.start();
    }

    private void resetTimeSlider() {
        this.timeLabel.setText(this.timeString);
        this.timeSlider.setMinimum(0);
        this.timeSlider.setMaximum(600000);
        this.timeSlider.setMajorTickSpacing(60000);
        this.timeSlider.setMinorTickSpacing(30000);
        this.timeSlider.setPaintTicks(true);
        this.timeSlider.setValue(0);
        this.timeSlider.setEnabled(false);
    }

    private void setTimeLabel(long l) {
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss.SSS");
        this.timeLabel.setText(this.timeString + " " + simpleDateFormat.format(date));
    }

    private static class NavConstraints {
        private int left;
        private int right;
        private int weight;
        private int fill;
        private int anchor;

        public NavConstraints(int n, int n2, int n3, int n4, int n5) {
            this.left = n;
            this.right = n2;
            this.weight = n3;
            this.fill = n4;
            this.anchor = n5;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getFill() {
            return this.fill;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }
}

