/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.util;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.util.ExtFileFilter;
import com.sun.kvem.util.ToolkitResources;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SmartFileChooser
extends JFileChooser {
    private static final Debug debug = Debug.create(SmartFileChooser.class);
    private MessageFormat fileExistsMsgFormat = new MessageFormat(ToolkitResources.getString((String)"FILE_EXISTS_MSG"));
    private String fileExistsMsgTitle = ToolkitResources.getString((String)"FILE_EXISTS_TITLE");
    private MessageFormat fileNotExistsMsgFormat = new MessageFormat(ToolkitResources.getString((String)"FILE_NOT_EXISTS_MSG"));
    private String fileNotExistsMsgTitle = ToolkitResources.getString((String)"FILE_NOT_EXISTS_TITLE");
    private boolean allowOpenNonExistFilesFlag = false;
    private boolean askBeforeOverriteFileFlag = true;
    private boolean addDefaultExtensionOnOpenFlag = true;
    private boolean addDefaultExtensionOnSaveFlag = true;

    public SmartFileChooser() {
    }

    public SmartFileChooser(File file) {
        super(file);
    }

    public SmartFileChooser(String string) {
        super(string);
    }

    public SmartFileChooser(File file, File file2) {
        if (file != null) {
            this.setSelectedFile(file);
        } else {
            this.setCurrentDirectory(file2);
        }
    }

    public void setFileNotExistMessagePattern(String string, String string2) {
        this.fileNotExistsMsgTitle = string;
        this.fileNotExistsMsgFormat = new MessageFormat(string2);
    }

    public void setOverriteMessagePattern(String string, String string2) {
        this.fileExistsMsgTitle = string;
        this.fileExistsMsgFormat = new MessageFormat(string2);
    }

    public void allowOpenNonExistFiles(boolean bl) {
        this.allowOpenNonExistFilesFlag = bl;
    }

    public void askBeforeOverriteFile(boolean bl) {
        this.askBeforeOverriteFileFlag = bl;
    }

    public void addDefaultExtension(boolean bl) {
        this.addDefaultExtensionOnOpenFlag = bl;
        this.addDefaultExtensionOnSaveFlag = bl;
    }

    public void addDefaultExtensionOnOpen(boolean bl) {
        this.addDefaultExtensionOnOpenFlag = bl;
    }

    public void addDefaultExtensionOnSave(boolean bl) {
        this.addDefaultExtensionOnSaveFlag = bl;
    }

    public void addExtFilter(String string, String string2) {
        this.setFileFilter(new ExtFileFilter(string, string2));
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 0) {
            this.approveSelectionOpen();
        } else {
            this.approveSelectionSave();
        }
    }

    public void approveSelectionSave() {
        File file = this.getSelectedFile();
        if (file != null) {
            if (this.addDefaultExtensionOnSaveFlag) {
                file = this.addDefaultExt(file);
                this.setSelectedFile(file);
            }
            if (this.askBeforeOverriteFileFlag && file.exists()) {
                int n = JOptionPane.showConfirmDialog(this, this.fileExistsMsgFormat.format(new Object[]{file.getName()}), this.fileExistsMsgTitle, 0, 2);
                if (n == 0) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }
    }

    private void approveSelectionOpen() {
        File file = this.getSelectedFile();
        if (file != null) {
            if (this.addDefaultExtensionOnOpenFlag) {
                file = this.addDefaultExt(file);
                this.setSelectedFile(file);
            }
            if (!this.allowOpenNonExistFilesFlag && !file.exists()) {
                JOptionPane.showMessageDialog(this, this.fileNotExistsMsgFormat.format(new Object[]{file.getName()}), this.fileNotExistsMsgTitle, 2);
            } else {
                super.approveSelection();
            }
        }
    }

    private File addDefaultExt(File file) {
        String string = file.getName();
        FileFilter fileFilter = this.getFileFilter();
        if (string.indexOf(46) < 0 && fileFilter instanceof ExtFileFilter) {
            return new File(file.getAbsolutePath() + "." + ((ExtFileFilter)fileFilter).getDefaultExt());
        }
        return file;
    }

    private File correctFileName(File file, FileFilter fileFilter) {
        if (file == null) {
            return null;
        }
        if (fileFilter == null || fileFilter.accept(file) || !(fileFilter instanceof ExtFileFilter)) {
            return file;
        }
        String string = ((ExtFileFilter)fileFilter).getDefaultExt();
        debug.println(1, "File name \"{0}\" is corrected to \"{1}\"", (Object)file.getName(), (Object)(file.getPath() + "." + string));
        return new File(file.getPath() + "." + string);
    }

    @Override
    public File getSelectedFile() {
        FileFilter fileFilter = this.getFileFilter();
        File file = super.getSelectedFile();
        return this.correctFileName(file, fileFilter);
    }

    @Override
    public File[] getSelectedFiles() {
        FileFilter fileFilter = this.getFileFilter();
        File[] fileArray = super.getSelectedFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = this.correctFileName(fileArray[i], fileFilter);
        }
        return fileArray;
    }
}

