/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.asyncstopper;

import com.sun.jme.toolkit.util.asyncstopper.AsyncStopperClient;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public final class AsyncStopper {
    private static final Logger LOGGER = Logger.getLogger(AsyncStopper.class);
    private final Set<AsyncStopperClient> clients = new HashSet<AsyncStopperClient>();
    private long stopTimeout;

    public void setStopTimeout(long l) {
        this.stopTimeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(AsyncStopperClient asyncStopperClient) {
        Set<AsyncStopperClient> set = this.clients;
        synchronized (set) {
            this.clients.add(asyncStopperClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientStopped(AsyncStopperClient asyncStopperClient) {
        Set<AsyncStopperClient> set = this.clients;
        synchronized (set) {
            this.clients.remove(asyncStopperClient);
            this.clients.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopClients() {
        AsyncStopperClient[] asyncStopperClientArray;
        LOGGER.debug((Object)"Stopping initialized...");
        Set<AsyncStopperClient> object = this.clients;
        synchronized (object) {
            asyncStopperClientArray = this.getCurrentClients();
        }
        AsyncStopperClient[] asyncStopperClientArray2 = asyncStopperClientArray;
        int n = asyncStopperClientArray2.length;
        for (int i = 0; i < n; ++i) {
            AsyncStopperClient asyncStopperClient = asyncStopperClientArray2[i];
            asyncStopperClient.startStopping();
        }
        LOGGER.debug((Object)"All clients asked to start stopping...");
        Set<AsyncStopperClient> set = this.clients;
        synchronized (set) {
            long l = System.currentTimeMillis();
            long l2 = l + this.stopTimeout;
            while (!this.clients.isEmpty() && l < l2) {
                try {
                    this.clients.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
            }
            asyncStopperClientArray = this.getCurrentClients();
        }
        if (asyncStopperClientArray.length > 0) {
            LOGGER.debug((Object)("Stopping timeouted: " + asyncStopperClientArray + " clients" + " failed to stop in time!"));
            for (AsyncStopperClient asyncStopperClient : asyncStopperClientArray) {
                asyncStopperClient.stopTimeout();
            }
        }
        LOGGER.debug((Object)"Stopping done.");
    }

    private AsyncStopperClient[] getCurrentClients() {
        AsyncStopperClient[] asyncStopperClientArray = new AsyncStopperClient[this.clients.size()];
        return this.clients.toArray(asyncStopperClientArray);
    }
}

