/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.shared.rmiimpl;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public final class LoopbackSocketFactory
implements RMIServerSocketFactory,
RMIClientSocketFactory,
Serializable {
    private final InetAddress loopbackAddress = LoopbackSocketFactory.getLoopbackAddress();

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n, 0, this.loopbackAddress);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        return new Socket(this.loopbackAddress, n);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof LoopbackSocketFactory;
    }

    public int hashCode() {
        return 0;
    }

    private static InetAddress getLoopbackAddress() {
        InetAddress inetAddress = null;
        byte[] byArray = new byte[]{127, 0, 0, 1};
        try {
            inetAddress = InetAddress.getByAddress("127.0.0.1", byArray);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress;
    }
}

