/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.jsr120.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class Sms
implements Serializable {
    private int encodingType;
    private byte[] destinationPhoneNumber;
    private int destinationPort;
    private byte[] sourcePhoneNumber;
    private int sourcePort;
    private long timeStamp;
    private byte[] message;

    public void setEncodingType(int n) {
        this.encodingType = n;
    }

    public int getEncodingType() {
        return this.encodingType;
    }

    public void setSourcePhoneNumber(byte[] byArray) {
        this.sourcePhoneNumber = byArray;
    }

    public byte[] getSourcePhoneNumber() {
        return this.sourcePhoneNumber;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int n) {
        this.sourcePort = n;
    }

    public void setDestinationPhoneNumber(byte[] byArray) {
        this.destinationPhoneNumber = byArray;
    }

    public byte[] getDestinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public void setDestinationPort(int n) {
        this.destinationPort = n;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.encode(dataOutputStream);
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.encodingType);
        dataOutput.writeLong(this.timeStamp);
        dataOutput.writeInt(this.destinationPort);
        this.encodeByteArray(dataOutput, this.destinationPhoneNumber);
        dataOutput.writeInt(this.sourcePort);
        this.encodeByteArray(dataOutput, this.sourcePhoneNumber);
        this.encodeByteArray(dataOutput, this.message);
    }

    private void encodeByteArray(DataOutput dataOutput, byte[] byArray) throws IOException {
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
        dataOutput.write(0);
    }

    public void decode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.decode(dataInputStream);
        dataInputStream.close();
    }

    public void decode(DataInput dataInput) throws IOException {
        this.encodingType = dataInput.readInt();
        this.timeStamp = dataInput.readLong();
        this.destinationPort = dataInput.readInt();
        this.destinationPhoneNumber = this.decodeByteArray(dataInput);
        this.sourcePort = dataInput.readInt();
        this.sourcePhoneNumber = this.decodeByteArray(dataInput);
        this.message = this.decodeByteArray(dataInput);
    }

    private byte[] decodeByteArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        if (dataInput.readByte() != 0) {
            throw new IllegalStateException();
        }
        return byArray;
    }

    public static Sms fromByteArray(byte[] byArray) throws IOException {
        Sms sms = new Sms();
        sms.decode(byArray);
        return sms;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SmsMessage[");
        stringBuilder.append("timeStamp=").append(this.timeStamp).append(',');
        stringBuilder.append("encodingType=").append(this.encodingType).append(',');
        stringBuilder.append("sourcePhoneNumber=").append(new String(this.sourcePhoneNumber)).append(',');
        stringBuilder.append("sourcePort=").append(this.sourcePort).append(',');
        stringBuilder.append("destinationPhoneNumber=").append(new String(this.destinationPhoneNumber)).append(',');
        stringBuilder.append("destinationPort=").append(this.destinationPort).append(',');
        stringBuilder.append("message=").append(new String(this.message));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

