/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic.colorfiltering;

import com.sun.jme.emulator.generic.colorfiltering.ColorConversionUtil;
import com.sun.jme.emulator.generic.colorfiltering.DitheringMatrix;
import com.sun.jme.emulator.generic.colorfiltering.Filter;
import com.sun.jme.emulator.generic.colorfiltering.FourByFourMatrix;
import org.apache.log4j.Logger;

final class DitheringColorFilter
extends Filter {
    public static final Logger LOGGER = Logger.getLogger(DitheringColorFilter.class);
    private final int ditheringWidthMask;
    private final int ditheringHeightMask;
    private final int ditheringWidthBits;
    private final int ditheringMidIndex;
    private final int[][] rConvTable8;
    private final int[][] gConvTable8;
    private final int[][] bConvTable8;
    private final int[][] rConvTable5;
    private final int[][] gConvTable6;
    private final int[][] bConvTable5;

    DitheringColorFilter(int n) {
        int n2 = ColorConversionUtil.logBase2(n);
        int n3 = n2 / 3;
        int n4 = n3 + (n2 % 3 > 1 ? 1 : 0);
        int n5 = n3 + (n2 % 3 > 0 ? 1 : 0);
        int n6 = 1 << n4;
        int n7 = 1 << n5;
        int n8 = 1 << n3;
        DitheringMatrix ditheringMatrix = FourByFourMatrix.getInstance();
        int[] nArray = ditheringMatrix.getElements();
        int n9 = ditheringMatrix.getDenominator();
        this.ditheringHeightMask = ditheringMatrix.getHeight() - 1;
        int n10 = ditheringMatrix.getWidth();
        this.ditheringWidthMask = n10 - 1;
        this.ditheringWidthBits = ColorConversionUtil.logBase2(n10);
        this.ditheringMidIndex = ColorConversionUtil.midOffset(nArray, n9);
        this.rConvTable8 = ColorConversionUtil.createConversionTable(256, n6, nArray, n9);
        this.gConvTable8 = ColorConversionUtil.createConversionTable(256, n7, nArray, n9);
        this.bConvTable8 = ColorConversionUtil.createConversionTable(256, n8, nArray, n9);
        this.rConvTable5 = ColorConversionUtil.createConversionTable(32, n6, nArray, n9);
        this.gConvTable6 = ColorConversionUtil.createConversionTable(64, n7, nArray, n9);
        this.bConvTable5 = ColorConversionUtil.createConversionTable(32, n8, nArray, n9);
        LOGGER.debug((Object)("Created DitheringColorFilter for " + n + " colors"));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4 = this.calcDitheringIndex(n, n2);
        return this.filterRGB(n4, n3);
    }

    @Override
    public int filterRGB(int n) {
        return this.filterRGB(this.ditheringMidIndex, n);
    }

    @Override
    public void filterPixelsToDestination16(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 + 2 * n2 <= n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n3 + 1] << 8 | byArray[n3] & 0xFF;
                int n8 = n7 & 0x1F;
                int n9 = n7 >> 5 & 0x3F;
                int n10 = n7 >> 11 & 0x1F;
                int n11 = this.calcDitheringIndex(n6, n5);
                nArray[n4] = 0xFF000000 | this.rConvTable5[n11][n10] << 16 | this.gConvTable6[n11][n9] << 8 | this.bConvTable5[n11][n8];
                ++n6;
                n3 += 2;
                ++n4;
            }
            ++n5;
        }
    }

    @Override
    public void filterPixelsToDestination32(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 + 4 * n2 <= n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n3 + 0] & 0xFF;
                int n8 = byArray[n3 + 1] & 0xFF;
                int n9 = byArray[n3 + 2] & 0xFF;
                int n10 = this.calcDitheringIndex(n6, n5);
                nArray[n4] = 0xFF000000 | this.rConvTable8[n10][n9] << 16 | this.gConvTable8[n10][n8] << 8 | this.bConvTable8[n10][n7];
                ++n6;
                n3 += 4;
                ++n4;
            }
            ++n5;
        }
    }

    private int filterRGB(int n, int n2) {
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        return n2 & 0xFF000000 | this.rConvTable8[n][n3] << 16 | this.gConvTable8[n][n4] << 8 | this.bConvTable8[n][n5];
    }

    private int calcDitheringIndex(int n, int n2) {
        return (n2 & this.ditheringHeightMask) << this.ditheringWidthBits | n & this.ditheringWidthMask;
    }
}

