/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic.colorfiltering;

import com.sun.jme.emulator.generic.colorfiltering.ColorConversionUtil;
import com.sun.jme.emulator.generic.colorfiltering.Filter;
import org.apache.log4j.Logger;

final class GrayscaleFilter
extends Filter {
    public static final Logger LOGGER = Logger.getLogger(GrayscaleFilter.class);
    private final int[] cConvTable8;

    GrayscaleFilter(int n) {
        int n2 = ColorConversionUtil.logBase2(n);
        int n3 = 1 << n2;
        if (n3 > 256) {
            n3 = 256;
        }
        this.cConvTable8 = ColorConversionUtil.createConversionTable(256, n3);
        LOGGER.debug((Object)("Created GrayscaleFilter for " + n3 + " colors"));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        return this.filterRGB(n3);
    }

    @Override
    public int filterRGB(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        int n5 = this.cConvTable8[19595 * n2 + 38470 * n3 + 7471 * n4 + 32768 >>> 16];
        return n & 0xFF000000 | n5 << 16 | n5 << 8 | n5;
    }

    @Override
    public void filterPixelsToDestination16(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; i += 2) {
            int n4 = byArray[i + 1] << 8 | byArray[i] & 0xFF;
            int n5 = n4 & 0x1F;
            int n6 = n4 >> 5 & 0x3F;
            int n7 = n4 >> 11 & 0x1F;
            int n8 = this.cConvTable8[161187 * n7 + 155710 * n6 + 61456 * n5 + 32768 >>> 16];
            nArray[n3++] = 0xFF000000 | n8 << 16 | n8 << 8 | n8;
        }
    }

    @Override
    public void filterPixelsToDestination32(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; i += 4) {
            int n4 = byArray[i + 0] & 0xFF;
            int n5 = byArray[i + 1] & 0xFF;
            int n6 = byArray[i + 2] & 0xFF;
            int n7 = this.cConvTable8[19595 * n6 + 38470 * n5 + 7471 * n4 + 32768 >>> 16];
            nArray[n3++] = 0xFF000000 | n7 << 16 | n7 << 8 | n7;
        }
    }
}

