/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic.colorfiltering;

import com.sun.jme.emulator.generic.colorfiltering.ColorConversionUtil;
import com.sun.jme.emulator.generic.colorfiltering.Filter;
import org.apache.log4j.Logger;

final class NullFilter
extends Filter {
    public static final Logger LOGGER = Logger.getLogger(NullFilter.class);
    private final int[] convert5To8 = ColorConversionUtil.createConversionTable(32, 256);
    private final int[] convert6To8 = ColorConversionUtil.createConversionTable(64, 256);

    NullFilter() {
        LOGGER.debug((Object)"Created NullFilter");
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        return n3;
    }

    @Override
    public int filterRGB(int n) {
        return n;
    }

    @Override
    public void filterPixelsToDestination16(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; i += 2) {
            int n4 = byArray[i + 1] << 8 | byArray[i] & 0xFF;
            int n5 = n4 & 0x1F;
            int n6 = n4 >> 5 & 0x3F;
            int n7 = n4 >> 11 & 0x1F;
            nArray[n3++] = 0xFF000000 | this.convert5To8[n7] << 16 | this.convert6To8[n6] << 8 | this.convert5To8[n5];
        }
    }

    @Override
    public void filterPixelsToDestination32(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; i += 4) {
            int n4 = byArray[i + 0] & 0xFF;
            int n5 = byArray[i + 1] & 0xFF;
            int n6 = byArray[i + 2] & 0xFF;
            nArray[n3++] = 0xFF000000 | n6 << 16 | n5 << 8 | n4;
        }
    }
}

