/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.kvem.environment.KvemHome;
import com.sun.kvem.environment.PropertiesFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Config {
    private static Config instance;
    private static Properties properties;
    public static final int MAX_RATE = 800000;
    public static final int MIN_RATE = 10000;
    public static final int MAX_BUFFER = 255;

    public static synchronized Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
        properties = Config.loadProperties();
        Config.initInternalProperties();
    }

    private static void initInternalProperties() {
        properties.setProperty("mmapi.camera.file", Config.getPathPrefix() + "camera.mpg");
        properties.setProperty("mmapi.camera.mime", "video/mpeg");
        properties.setProperty("mmapi.startup.file", Config.getPathPrefix() + "startup.mov");
        properties.setProperty("mmapi.startup.mime", "video/mp4");
        properties.setProperty("mmapi.splashscreen.file", Config.getPathPrefix() + "splash.png");
    }

    private static Properties loadProperties() {
        PropertiesFile propertiesFile;
        try {
            propertiesFile = new PropertiesFile(new File(Config.getPathPrefix() + "mmapi.properties"));
        }
        catch (IOException iOException) {
            System.out.println("Error: can't load MMAPI configuration file.\n" + iOException);
            return new Properties();
        }
        return propertiesFile.getProperties();
    }

    private static String getPathPrefix() {
        return KvemHome.HOME + File.separator + "toolkit-lib" + File.separator + "emulator" + File.separator + "generic" + File.separator + "core" + File.separator + "conf" + File.separator + "media" + File.separator;
    }

    public String getProperty(String string) {
        return properties.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileAsStream(String string) {
        byte[] byArray = new byte[255];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(new File(string));
            while ((n = fileInputStream.read(byArray)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

