/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devicedetection.odt;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DefaultNamedObjectRegistry;
import com.sun.jme.remoting.NamedObjectRegistry;
import com.sun.jme.remoting.RemotingHandler;
import com.sun.jme.remoting.Version;
import com.sun.jme.remoting.VersionProvider;
import com.sun.jme.services.productdesc.ProductDescription;
import com.sun.jme.services.productdesc.ProductDescriptor;
import com.sun.jme.services.productdesc.ProductInstanceId;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceState;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateManager;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.devicedetection.api.DetectionProcessListener;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceTypeDetector;
import com.sun.jme.toolkit.devicedetection.api.VerbosityLevel;
import com.sun.jme.toolkit.devicedetection.odt.OdtDetectionResult;
import com.sun.jme.toolkit.devicedetection.odt.OdtDetectorClient;
import com.sun.jme.toolkit.devicedetection.odt.OdtProductAddress;
import com.sun.jme.toolkit.devicedetection.odt.OdtProductPort;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public final class OdtDeviceDetector
implements DeviceTypeDetector {
    private static final Logger LOGGER = Logger.getLogger(OdtDeviceDetector.class);
    private static final String REPORT_SRC = "ODT";
    private final Map<OdtProductAddress, OdtDetectionResult> addressToDetectionResult = new HashMap<OdtProductAddress, OdtDetectionResult>();
    private final Set<Integer> odtPortNumbers = new HashSet<Integer>();
    private final Set<OdtDetectorClient> odtDetectorClients = new CopyOnWriteArraySet<OdtDetectorClient>();
    private final Object notificationLock = new Object();
    private DeviceManager deviceManager;
    private DeviceStateManager deviceStateManager;
    private int connectTimeout;
    private Version minOdtVersion;

    public void addPortNumber(OdtProductPort odtProductPort) {
        this.odtPortNumbers.add(odtProductPort.getPortNumber());
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setMinOdtVersion(String string) {
        this.minOdtVersion = new Version(string);
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public void setDeviceStateManager(DeviceStateManager deviceStateManager) {
        this.deviceStateManager = deviceStateManager;
    }

    public void addOdtDetectorClient(OdtDetectorClient odtDetectorClient) {
        this.odtDetectorClients.add(odtDetectorClient);
    }

    public void removeOdtDetectorClient(OdtDetectorClient odtDetectorClient) {
        this.odtDetectorClients.remove(odtDetectorClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(DeviceAddress deviceAddress, boolean bl, DetectionProcessListener detectionProcessListener) {
        if (!(deviceAddress instanceof DeviceIpAddress)) {
            return false;
        }
        boolean bl2 = false;
        for (Integer n : this.odtPortNumbers) {
            OdtProductAddress odtProductAddress = new OdtProductAddress(deviceAddress, n);
            OdtDetectionResult odtDetectionResult = null;
            OdtDeviceDetector odtDeviceDetector = this;
            synchronized (odtDeviceDetector) {
                if (!bl && this.addressToDetectionResult.containsKey(odtProductAddress) && (odtDetectionResult = this.addressToDetectionResult.get(odtProductAddress)) == null) {
                    continue;
                }
            }
            long l = System.currentTimeMillis();
            bl2 = odtDetectionResult != null ? (bl2 |= this.verifyCachedResult(odtDetectionResult, detectionProcessListener)) : (bl2 |= this.accept(odtProductAddress, detectionProcessListener));
            l = System.currentTimeMillis() - l;
            detectionProcessListener.reportProgress(odtProductAddress.getDeviceAddress(), VerbosityLevel.HIGH, REPORT_SRC, "It took " + l + "ms to check port " + odtProductAddress.getPort());
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DeviceAddress deviceAddress) {
        if (!(deviceAddress instanceof DeviceIpAddress)) {
            return;
        }
        Object object = this.notificationLock;
        synchronized (object) {
            HashSet<ProductInstanceId> hashSet = new HashSet<ProductInstanceId>();
            OdtDeviceDetector odtDeviceDetector = this;
            synchronized (odtDeviceDetector) {
                OdtDetectionResult odtDetectionResult;
                ProductInstanceId productInstanceId = this.addressToDetectionResult.entrySet().iterator();
                while (productInstanceId.hasNext()) {
                    Map.Entry<OdtProductAddress, OdtDetectionResult> entry = productInstanceId.next();
                    OdtProductAddress object2 = entry.getKey();
                    if (!object2.getDeviceAddress().equals(deviceAddress)) continue;
                    odtDetectionResult = (OdtDetectionResult)entry.getValue();
                    if (odtDetectionResult != null) {
                        hashSet.add(odtDetectionResult.getProductInstanceId());
                    }
                    productInstanceId.remove();
                }
                for (Map.Entry entry : this.addressToDetectionResult.entrySet()) {
                    odtDetectionResult = (OdtDetectionResult)entry.getValue();
                    if (odtDetectionResult == null) continue;
                    hashSet.remove(odtDetectionResult.getProductInstanceId());
                }
            }
            for (ProductInstanceId productInstanceId : hashSet) {
                LOGGER.debug((Object)("Removed product " + productInstanceId));
                this.notifyProductRemoved(productInstanceId);
            }
        }
    }

    public void invalidate(OdtProductAddress odtProductAddress) {
        this.updateDetectionResult(odtProductAddress, null, true, null);
    }

    public synchronized OdtDetectionResult getDetectionResult(ProductInstanceId productInstanceId) {
        return this.getLatestDetectionResult(productInstanceId);
    }

    public synchronized Collection<ProductInstanceId> getDetectedProducts() {
        HashSet<ProductInstanceId> hashSet = new HashSet<ProductInstanceId>();
        for (Map.Entry<OdtProductAddress, OdtDetectionResult> entry : this.addressToDetectionResult.entrySet()) {
            OdtDetectionResult odtDetectionResult = entry.getValue();
            if (odtDetectionResult == null) continue;
            hashSet.add(odtDetectionResult.getProductInstanceId());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdtDetectionResult executeOdtDetection(OdtProductAddress odtProductAddress, int n, DetectionProcessListener detectionProcessListener) throws IOException, CommException {
        Socket socket = this.openSocket(odtProductAddress);
        try {
            OdtDetectionResult odtDetectionResult;
            RemotingHandler remotingHandler;
            BufferedOutputStream bufferedOutputStream;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            try {
                bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                remotingHandler = RemotingHandler.createInstance((NamedObjectRegistry)this.constructNamedObjectRegistry(), (InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
            }
            catch (IOException iOException) {
                ((InputStream)bufferedInputStream).close();
                throw iOException;
            }
            bufferedOutputStream = remotingHandler;
            new Thread((RemotingHandler)bufferedOutputStream){
                final /* synthetic */ RemotingHandler val$remotingHandler;
                {
                    this.val$remotingHandler = remotingHandler;
                }

                @Override
                public void run() {
                    this.val$remotingHandler.executeDispatchingLoop();
                }
            }.start();
            if (detectionProcessListener != null) {
                detectionProcessListener.reportProgress(odtProductAddress.getDeviceAddress(), VerbosityLevel.HIGH, REPORT_SRC, "Started remote calls dispatching loop");
            }
            try {
                OdtDetectionResult odtDetectionResult2;
                odtDetectionResult = odtDetectionResult2 = this.executeOdtDetection(odtProductAddress, (RemotingHandler)bufferedOutputStream, detectionProcessListener);
            }
            catch (Throwable throwable) {
                bufferedOutputStream.stopDispatchingLoop();
                throw throwable;
            }
            bufferedOutputStream.stopDispatchingLoop();
            return odtDetectionResult;
        }
        finally {
            socket.close();
        }
    }

    private boolean accept(OdtProductAddress odtProductAddress, DetectionProcessListener detectionProcessListener) {
        try {
            OdtDetectionResult odtDetectionResult = this.executeOdtDetection(odtProductAddress, this.connectTimeout, detectionProcessListener);
            String string = "Detected product " + odtDetectionResult.getProductDescriptor() + ", ID " + odtDetectionResult.getProductInstanceId() + ", ODT " + odtDetectionResult.getOdtVersion();
            detectionProcessListener.reportSuccess(odtProductAddress.getDeviceAddress(), VerbosityLevel.MEDIUM, REPORT_SRC, string);
            this.updateDetectionResult(odtProductAddress, odtDetectionResult, false, detectionProcessListener);
            return true;
        }
        catch (CommException commException) {
            detectionProcessListener.reportFailure(odtProductAddress.getDeviceAddress(), VerbosityLevel.LOW, REPORT_SRC, "Failed to communicate on port " + odtProductAddress.getPort() + ": " + commException.getMessage());
            this.updateDetectionResult(odtProductAddress, null, false, detectionProcessListener);
            return false;
        }
        catch (IOException iOException) {
            detectionProcessListener.reportFailure(odtProductAddress.getDeviceAddress(), VerbosityLevel.LOW, REPORT_SRC, "Failed to connect to port " + odtProductAddress.getPort() + ": " + iOException.getMessage());
            this.updateDetectionResult(odtProductAddress, null, true, detectionProcessListener);
            return false;
        }
    }

    private boolean verifyCachedResult(OdtDetectionResult odtDetectionResult, DetectionProcessListener detectionProcessListener) {
        OdtProductAddress odtProductAddress = odtDetectionResult.getProductAddress();
        try {
            Socket socket = this.openSocket(odtProductAddress);
            socket.close();
            detectionProcessListener.reportSuccess(odtProductAddress.getDeviceAddress(), VerbosityLevel.MEDIUM, REPORT_SRC, "Successfully verified connection to port " + odtProductAddress.getPort());
            this.updateDetectionResult(odtProductAddress, odtDetectionResult, false, detectionProcessListener);
        }
        catch (IOException iOException) {
            detectionProcessListener.reportFailure(odtProductAddress.getDeviceAddress(), VerbosityLevel.LOW, REPORT_SRC, "Failed to connect to port " + odtProductAddress.getPort() + ": " + iOException.getMessage());
            this.updateDetectionResult(odtProductAddress, null, true, detectionProcessListener);
            return false;
        }
        return true;
    }

    private OdtDetectionResult executeOdtDetection(OdtProductAddress odtProductAddress, RemotingHandler remotingHandler, DetectionProcessListener detectionProcessListener) throws CommException {
        DeviceAddress deviceAddress = odtProductAddress.getDeviceAddress();
        remotingHandler.versionCheck();
        if (detectionProcessListener != null) {
            detectionProcessListener.reportSuccess(deviceAddress, VerbosityLevel.HIGH, REPORT_SRC, "Remoting protocol and generator version check succeeded");
        }
        VersionProvider versionProvider = (VersionProvider)remotingHandler.getRemoteObject("OdtVersion");
        Version version = versionProvider.getVersion();
        if (detectionProcessListener != null) {
            detectionProcessListener.reportProgress(deviceAddress, VerbosityLevel.HIGH, REPORT_SRC, "Received ODT version " + version);
        }
        if (this.minOdtVersion.compareTo(version) > 0) {
            throw new CommException("The device ODT version \"" + version + "\" is less than required \"" + this.minOdtVersion + "\"!");
        }
        if (detectionProcessListener != null) {
            detectionProcessListener.reportSuccess(deviceAddress, VerbosityLevel.HIGH, REPORT_SRC, "Minimal ODT version check succeeded");
        }
        ProductDescription productDescription = (ProductDescription)remotingHandler.getRemoteObject("OdtProductDescription");
        if (detectionProcessListener != null) {
            detectionProcessListener.reportProgress(deviceAddress, VerbosityLevel.HIGH, REPORT_SRC, "Received product description: product " + productDescription.getDescriptor() + ", ID " + productDescription.getInstanceId());
        }
        return new OdtDetectionResult(System.currentTimeMillis(), productDescription.getInstanceId(), productDescription.getDescriptor(), version, odtProductAddress);
    }

    private NamedObjectRegistry constructNamedObjectRegistry() {
        DefaultNamedObjectRegistry defaultNamedObjectRegistry = new DefaultNamedObjectRegistry();
        defaultNamedObjectRegistry.registerObjectStubClass("OdtVersion", VersionProvider.class);
        defaultNamedObjectRegistry.registerObjectStubClass("OdtProductDescription", ProductDescription.class);
        return defaultNamedObjectRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDetectionResult(OdtProductAddress odtProductAddress, OdtDetectionResult odtDetectionResult, boolean bl, DetectionProcessListener detectionProcessListener) {
        OdtDetectionResult odtDetectionResult2 = bl ? null : odtDetectionResult;
        Object object = this.notificationLock;
        synchronized (object) {
            boolean bl2;
            boolean bl3;
            OdtDetectionResult odtDetectionResult3;
            OdtDeviceDetector odtDeviceDetector = this;
            synchronized (odtDeviceDetector) {
                odtDetectionResult3 = this.addressToDetectionResult.get(odtProductAddress);
                if (odtDetectionResult3 != null && odtDetectionResult2 != null && odtDetectionResult3.getProductInstanceId().equals((Object)odtDetectionResult2.getProductInstanceId())) {
                    bl3 = false;
                    bl2 = false;
                    odtDetectionResult3 = null;
                } else {
                    boolean bl4 = bl3 = odtDetectionResult2 != null && !this.hasDetectionResult(odtDetectionResult2.getProductInstanceId());
                    if (bl) {
                        this.addressToDetectionResult.remove(odtProductAddress);
                    } else {
                        this.addressToDetectionResult.put(odtProductAddress, odtDetectionResult2);
                    }
                    bl2 = odtDetectionResult3 != null && !this.hasDetectionResult(odtDetectionResult3.getProductInstanceId());
                }
            }
            if (bl2) {
                this.notifyProductRemoved(odtDetectionResult3.getProductInstanceId());
            }
            if (bl3) {
                this.notifyProductDetected(odtDetectionResult2.getProductInstanceId(), odtDetectionResult2.getProductDescriptor());
            }
            if (detectionProcessListener != null) {
                if (odtDetectionResult3 != null) {
                    this.reportDeviceStates(odtDetectionResult3, detectionProcessListener, VerbosityLevel.MEDIUM);
                }
                if (odtDetectionResult2 != null) {
                    this.reportDeviceStates(odtDetectionResult2, detectionProcessListener, VerbosityLevel.LOW);
                }
            }
        }
    }

    private void notifyProductDetected(ProductInstanceId productInstanceId, ProductDescriptor productDescriptor) {
        for (OdtDetectorClient odtDetectorClient : this.odtDetectorClients) {
            odtDetectorClient.productDetected(productInstanceId, productDescriptor);
        }
    }

    private void notifyProductRemoved(ProductInstanceId productInstanceId) {
        for (OdtDetectorClient odtDetectorClient : this.odtDetectorClients) {
            odtDetectorClient.productRemoved(productInstanceId);
        }
    }

    private OdtDetectionResult getLatestDetectionResult(ProductInstanceId productInstanceId) {
        long l = 0L;
        OdtDetectionResult odtDetectionResult = null;
        for (Map.Entry<OdtProductAddress, OdtDetectionResult> entry : this.addressToDetectionResult.entrySet()) {
            OdtDetectionResult odtDetectionResult2 = entry.getValue();
            if (odtDetectionResult2 == null || !odtDetectionResult2.getProductInstanceId().equals((Object)productInstanceId) || odtDetectionResult2.getTimestamp() < l) continue;
            l = odtDetectionResult2.getTimestamp();
            odtDetectionResult = odtDetectionResult2;
        }
        return odtDetectionResult;
    }

    private boolean hasDetectionResult(ProductInstanceId productInstanceId) {
        return this.getLatestDetectionResult(productInstanceId) != null;
    }

    private Socket openSocket(OdtProductAddress odtProductAddress) throws IOException {
        DeviceIpAddress deviceIpAddress = (DeviceIpAddress)odtProductAddress.getDeviceAddress();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(deviceIpAddress.getDeviceAddress(), odtProductAddress.getPort());
        Socket socket = new Socket();
        socket.connect(inetSocketAddress, this.connectTimeout);
        return socket;
    }

    private void reportDeviceStates(OdtDetectionResult odtDetectionResult, DetectionProcessListener detectionProcessListener, VerbosityLevel verbosityLevel) {
        DeviceAddress deviceAddress = odtDetectionResult.getProductAddress().getDeviceAddress();
        ProductInstanceId productInstanceId = odtDetectionResult.getProductInstanceId();
        boolean bl = true;
        for (OdtDetectorClient odtDetectorClient : this.odtDetectorClients) {
            int n = odtDetectorClient.getAssignedDeviceId(productInstanceId);
            if (n == -1) continue;
            DeviceState deviceState = this.deviceStateManager.getDeviceState(n);
            String string = this.getDeviceName(n);
            bl = false;
            if (deviceState.isAvailable()) {
                detectionProcessListener.reportSuccess(deviceAddress, verbosityLevel, REPORT_SRC, string + " is available");
                continue;
            }
            detectionProcessListener.reportFailure(deviceAddress, verbosityLevel, REPORT_SRC, string + " is unavailable");
        }
        if (bl) {
            detectionProcessListener.reportFailure(deviceAddress, verbosityLevel, REPORT_SRC, "Product " + odtDetectionResult.getProductDescriptor() + " not supported currently");
        }
    }

    private String getDeviceName(int n) {
        RegistrationData registrationData = this.deviceManager.getDeviceRegistration(n);
        String string = registrationData != null ? registrationData.getName() : null;
        return string != null ? string : "<unknown>";
    }
}

