/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.genericemulator;

import com.sun.jme.toolkit.device.connmanager.api.ConnectionException;
import com.sun.jme.toolkit.device.connmanager.api.ConnectionManager;
import com.sun.jme.toolkit.device.sysmanager.api.SystemManager;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistration;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationManager;
import com.sun.jme.toolkit.deviceadapter.api.DeviceNotAvailableException;
import com.sun.jme.toolkit.deviceadapter.genericemulator.DeviceClassAdapter;
import com.sun.jme.toolkit.deviceadapter.genericemulator.EmulatorConnectionListener;
import com.sun.jme.toolkit.deviceadapter.genericemulator.GenericEmulatorRunner;
import com.sun.jme.toolkit.deviceadapter.genericemulator.PortPool;
import com.sun.jme.toolkit.environment.WorkdirHelper;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.jme.toolkit.remoting.registry.api.RegistryService;
import com.sun.jme.toolkit.util.process.AbstractProcessRunner;
import com.sun.jme.toolkit.util.process.ProcessListener;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class EmulatorConnection
implements DeviceRegistration,
ProcessListener {
    private static final int EMULATOR_TERMINATED = 0;
    private static final int EMULATOR_STARTED = 1;
    private static final int EMULATOR_REGISTERED = 2;
    private static final int EMULATOR_UNREGISTERED = 3;
    private static final Logger logger = Logger.getLogger(EmulatorConnection.class);
    private final DeviceRegistrationManager deviceRegistrationManager;
    private final RegistryService registryService;
    private final PortPool portPool;
    private final int deviceId;
    private final String deviceName;
    private final String[] connectArgs;
    private int stdoutPortNumber;
    private int stderrPortNumber;
    private int jdwpPortNumber;
    private final Object emulatorStateLock;
    private final EmulatorConnectionListener listener;
    private int emulatorState;
    private boolean emulatorConnected;
    private GenericEmulatorRunner emulatorRunner;
    private DeviceClassAdapter parent;
    private final String deviceSkin;
    private WorkdirHelper workdirHelper;
    private DeviceConnectionManager deviceConnectionManager;

    public EmulatorConnection(DeviceClassAdapter deviceClassAdapter, DeviceRegistrationManager deviceRegistrationManager, RegistryService registryService, PortPool portPool, int n, String string, String[] stringArray, String string2, WorkdirHelper workdirHelper, DeviceConnectionManager deviceConnectionManager, EmulatorConnectionListener emulatorConnectionListener) {
        this.parent = deviceClassAdapter;
        this.deviceRegistrationManager = deviceRegistrationManager;
        this.registryService = registryService;
        this.portPool = portPool;
        this.deviceId = n;
        this.deviceName = string;
        this.connectArgs = stringArray;
        this.emulatorStateLock = new Object();
        this.deviceSkin = string2;
        this.workdirHelper = workdirHelper;
        this.deviceConnectionManager = deviceConnectionManager;
        this.listener = emulatorConnectionListener;
    }

    public void start() throws DeviceNotAvailableException {
        this.stdoutPortNumber = this.portPool.reservePortNumber();
        this.stderrPortNumber = this.portPool.reservePortNumber();
        this.jdwpPortNumber = this.portPool.reservePortNumber();
        if (this.stdoutPortNumber == -1 || this.stderrPortNumber == -1 || this.jdwpPortNumber == -1) {
            this.freePortNumbers();
            throw new DeviceNotAvailableException("Failed to assign ports for device " + this.deviceId + "!");
        }
        this.deviceRegistrationManager.addDeviceManagerListener((DeviceRegistration)this);
        try {
            this.startEmulatorProcess();
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            this.deviceRegistrationManager.removeDeviceManagerListener((DeviceRegistration)this);
            this.freePortNumbers();
            throw deviceNotAvailableException;
        }
        this.waitEmulatorRegistered();
        this.initEmulatorConnection();
    }

    public void stop() {
        this.emulatorRunner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registeredDevice(int n) {
        if (this.deviceId != n) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Emulator " + n + " has been registered."));
        }
        Object object = this.emulatorStateLock;
        synchronized (object) {
            this.emulatorState = 2;
            this.emulatorStateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisteredDevice(int n) {
        if (this.deviceId != n) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Emulator " + n + " has been unregistered."));
        }
        Object object = this.emulatorStateLock;
        synchronized (object) {
            if (this.emulatorState != 0) {
                this.emulatorState = 3;
                this.emulatorStateLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTerminated(AbstractProcessRunner abstractProcessRunner, int n) {
        boolean bl;
        int n2;
        Object object = this.emulatorStateLock;
        synchronized (object) {
            n2 = this.emulatorState;
            bl = this.emulatorConnected;
            this.emulatorState = 0;
            this.emulatorStateLock.notifyAll();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Emulator " + this.deviceId + " process terminated with" + " exit code " + n));
        }
        this.deviceRegistrationManager.removeDeviceManagerListener((DeviceRegistration)this);
        this.freePortNumbers();
        if (n2 == 2) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Emulator " + this.deviceId + " hasn't been" + " properly unregistered!"));
                logger.debug((Object)"Doing the unregistration now.");
            }
            this.deviceRegistrationManager.unregisteredDevice(this.deviceId);
        }
        this.registryService.unbind("device-" + this.deviceId);
        if (bl && this.listener != null) {
            this.listener.connectionStopped(this);
        }
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getStdoutPortNumber() {
        return this.stdoutPortNumber;
    }

    public int getStderrPortNumber() {
        return this.stderrPortNumber;
    }

    public int getJdwpPortNumber() {
        return this.jdwpPortNumber;
    }

    public void stopEmulator() {
        try {
            SystemManager systemManager = this.getEmulatorSystemManager();
            systemManager.exit(0);
        }
        catch (Exception exception) {
            logger.debug((Object)("Failed to send stop to emulator " + this.deviceId + "!"));
        }
    }

    public boolean checkConnection() {
        try {
            ConnectionManager connectionManager = this.getEmulatorConnectionManager();
            connectionManager.checkConnection();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEmulatorProcess() throws DeviceNotAvailableException {
        File file = this.workdirHelper.deviceWorkDirectory(Integer.toString(this.deviceId));
        this.emulatorRunner = new GenericEmulatorRunner(this);
        this.emulatorRunner.setDeviceId(this.deviceId);
        this.emulatorRunner.setDeviceName(this.deviceName);
        this.emulatorRunner.setConnectArgs(this.connectArgs);
        this.emulatorRunner.setDeviceSkin(this.deviceSkin);
        this.emulatorRunner.setStdoutPortNumber(this.stdoutPortNumber);
        this.emulatorRunner.setStderrPortNumber(this.stderrPortNumber);
        this.emulatorRunner.setJdwpPortNumber(this.jdwpPortNumber);
        this.emulatorRunner.setCommandLineFileProperties(this.parent.getCommandLineFileProperties());
        this.emulatorRunner.setCommandLineStringProperties(this.parent.getCommandLineStringProperties());
        this.emulatorRunner.setCommandLine(this.parent.getCommandLine());
        this.emulatorRunner.setWorkdir(file);
        Object object = this.emulatorStateLock;
        synchronized (object) {
            try {
                this.emulatorRunner.start();
            }
            catch (IOException iOException) {
                throw new DeviceNotAvailableException("Device " + this.deviceId + " not available!", (Throwable)iOException);
            }
            this.emulatorState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitEmulatorRegistered() throws DeviceNotAvailableException {
        int n;
        int n2 = this.parent.getConnectTimeout();
        logger.debug((Object)("Waiting for emulator to register with timeout " + n2));
        Object object = this.emulatorStateLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            long l2 = l + (long)n2;
            while (this.emulatorState == 1 && l < l2) {
                try {
                    this.emulatorStateLock.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
            }
            n = this.emulatorState;
        }
        switch (n) {
            case 0: 
            case 3: {
                throw new DeviceNotAvailableException("Emulator " + this.deviceId + " terminated while" + " waiting for it to register!");
            }
            case 1: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Emulator " + this.deviceId + " failed to register in time!"));
                }
                this.emulatorRunner.stop();
                throw new DeviceNotAvailableException("Emulator " + this.deviceId + " failed to register" + " in time!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEmulatorConnection() throws DeviceNotAvailableException {
        Object object;
        try {
            object = this.getEmulatorConnectionManager();
            object.initializeConnection();
        }
        catch (ConnectionException connectionException) {
            throw new DeviceNotAvailableException(connectionException.getMessage());
        }
        catch (Exception exception) {
            throw new DeviceNotAvailableException("Failed to initialize connection with emulator " + this.deviceId + "! (possible runtime incompatibility)");
        }
        object = this.emulatorStateLock;
        synchronized (object) {
            if (this.emulatorState != 2) {
                throw new DeviceNotAvailableException("Emulator " + this.deviceId + " terminated prematurely!");
            }
            this.emulatorConnected = true;
        }
    }

    private void freePortNumbers() {
        this.portPool.freePortNumber(this.stdoutPortNumber);
        this.portPool.freePortNumber(this.stderrPortNumber);
        this.portPool.freePortNumber(this.jdwpPortNumber);
    }

    private SystemManager getEmulatorSystemManager() throws Exception {
        ObjectServerConnection objectServerConnection = this.deviceConnectionManager.openDeviceConnection(this.deviceId);
        SystemManager systemManager = (SystemManager)objectServerConnection.findObject(SystemManager.class, SystemManager.class.getSimpleName());
        return systemManager;
    }

    private ConnectionManager getEmulatorConnectionManager() throws Exception {
        ObjectServerConnection objectServerConnection = this.deviceConnectionManager.openDeviceConnection(this.deviceId);
        ConnectionManager connectionManager = (ConnectionManager)objectServerConnection.findObject(ConnectionManager.class, ConnectionManager.class.getSimpleName());
        return connectionManager;
    }
}

