/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.genericemulator;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationManager;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.deviceadapter.api.DeviceNotAvailableException;
import com.sun.jme.toolkit.deviceadapter.api.DeviceProperties;
import com.sun.jme.toolkit.deviceadapter.genericemulator.DeviceClassAdapter;
import com.sun.jme.toolkit.deviceadapter.genericemulator.EmulatorConnection;
import com.sun.jme.toolkit.deviceadapter.genericemulator.EmulatorConnectionListener;
import com.sun.jme.toolkit.deviceadapter.genericemulator.GenericEmulatorDeviceAdapterMBean;
import com.sun.jme.toolkit.deviceadapter.genericemulator.InitialDevice;
import com.sun.jme.toolkit.deviceadapter.genericemulator.PortPool;
import com.sun.jme.toolkit.environment.WorkdirHelper;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.remoting.registry.api.RegistryService;
import com.sun.jme.toolkit.util.asyncstopper.AsyncStopper;
import com.sun.jme.toolkit.util.asyncstopper.AsyncStopperClient;
import com.sun.jme.toolkit.util.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenericEmulatorDeviceAdapter
implements GenericEmulatorDeviceAdapterMBean,
EmulatorConnectionListener,
AsyncStopperClient {
    private static final String PROPERTIES_FILE_NAME = "device.properties";
    private static final Logger logger = Logger.getLogger(GenericEmulatorDeviceAdapter.class);
    private static final int MIN_PORT_NUMBER = 51300;
    private static final int MAX_PORT_NUMBER = 51400;
    private static final PortPool PORT_POOL = new PortPool(51300, 51400);
    private String name;
    private DeviceManager deviceManager;
    private DeviceClassAdapter deviceAdapter;
    private DeviceProperties deviceProperties;
    private DeviceRegistrationManager deviceRegistrationManager;
    private List<InitialDevice> initialDevices = new ArrayList<InitialDevice>();
    private WorkdirHelper workdirHelper;
    private DeviceConnectionManager deviceConnectionManager;
    private AsyncStopper adapterStopper;
    private RegistryService registryService;
    private boolean stopped;
    private final Map<Integer, EmulatorConnection> connectedDevices;
    private Comparator nameOrderer = new Comparator(){

        public int compare(Object object, Object object2) {
            String string = ((InitialDevice)object).getDeviceName();
            String string2 = ((InitialDevice)object2).getDeviceName();
            return string.compareTo(string2);
        }
    };

    public GenericEmulatorDeviceAdapter() {
        logger.trace((Object)"GenericEmulatorDeviceAdapter() -->");
        this.connectedDevices = new HashMap<Integer, EmulatorConnection>();
        logger.trace((Object)"<-- GenericEmulatorDeviceAdapter()");
    }

    public void setWorkdirHelper(WorkdirHelper workdirHelper) {
        this.workdirHelper = workdirHelper;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addInitialDevice(Object object) {
        this.initialDevices.add((InitialDevice)object);
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public void setDeviceAdapter(DeviceClassAdapter deviceClassAdapter) {
        this.deviceAdapter = deviceClassAdapter;
    }

    public void setDeviceRegistrationManager(DeviceRegistrationManager deviceRegistrationManager) {
        this.deviceRegistrationManager = deviceRegistrationManager;
    }

    public void setDeviceProperties(DeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
    }

    public void setDeviceConnectionManager(DeviceConnectionManager deviceConnectionManager) {
        this.deviceConnectionManager = deviceConnectionManager;
    }

    public void setAdapterStopper(AsyncStopper asyncStopper) {
        this.adapterStopper = asyncStopper;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void start() {
        logger.trace((Object)"start() -->");
        Collections.sort(this.initialDevices, this.nameOrderer);
        for (InitialDevice initialDevice : this.initialDevices) {
            String string = initialDevice.getDeviceName();
            int n = this.deviceManager.lookupDeviceId(string);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Got device ID: " + n + " for device name: " + string));
            }
            if (n != -1) continue;
            n = this.deviceManager.allocateDeviceId(new RegistrationData(string, this.getName()));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Allocated device ID: " + n + " for device name: " + string + " and device adapter: " + this.getName()));
            }
            this.init(n, initialDevice.getPropertyFileName());
            this.deviceAdapter.init(n);
        }
        if (this.deviceProperties != null) {
            this.deviceProperties.setBootClassPathAsArray(this.createBootClassPath(this.deviceProperties.getBootClassPath()));
        }
        this.adapterStopper.registerClient((AsyncStopperClient)this);
        logger.trace((Object)"<-- start()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStopping() {
        EmulatorConnection[] emulatorConnectionArray;
        EmulatorConnection[] emulatorConnectionArray2 = this;
        synchronized (emulatorConnectionArray2) {
            this.stopped = true;
        }
        emulatorConnectionArray2 = this.connectedDevices;
        synchronized (emulatorConnectionArray2) {
            emulatorConnectionArray = this.getCurrentConnections();
        }
        for (EmulatorConnection emulatorConnection : emulatorConnectionArray) {
            emulatorConnection.stopEmulator();
        }
        if (emulatorConnectionArray.length == 0) {
            this.adapterStopper.clientStopped((AsyncStopperClient)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimeout() {
        EmulatorConnection[] emulatorConnectionArray = this.connectedDevices;
        synchronized (this.connectedDevices) {
            EmulatorConnection[] emulatorConnectionArray2 = this.getCurrentConnections();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(emulatorConnectionArray2.length + " emulator connections" + " remained to be stopped."));
            }
            for (EmulatorConnection emulatorConnection : emulatorConnectionArray2) {
                emulatorConnection.stop();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(int n, String[] stringArray) throws DeviceNotAvailableException {
        EmulatorConnection emulatorConnection;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("connect(deviceId = " + n + "," + ", connectArgs = " + Arrays.toString(stringArray) + ") -->"));
        }
        if (this.stopped) {
            throw new DeviceNotAvailableException("Device adapter has been stopped!");
        }
        RegistrationData registrationData = this.connectedDevices;
        synchronized (registrationData) {
            emulatorConnection = this.connectedDevices.get(n);
            if (emulatorConnection != null && emulatorConnection.checkConnection()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Emulator " + n + " is alive and" + " the connection to it is up."));
                }
                return;
            }
        }
        if (emulatorConnection != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connection to emulator " + n + " has" + " been lost."));
                logger.debug((Object)"Destroying its process.");
            }
            emulatorConnection.stop();
        }
        String string = (registrationData = this.deviceManager.getDeviceRegistration(n)) != null ? registrationData.getName() : this.deviceProperties.getSkin();
        EmulatorConnection emulatorConnection2 = new EmulatorConnection(this.deviceAdapter, this.deviceRegistrationManager, this.registryService, PORT_POOL, n, string, this.filterConnectArgs(stringArray), this.deviceProperties.getSkin(), this.workdirHelper, this.deviceConnectionManager, this);
        Map<Integer, EmulatorConnection> map = this.connectedDevices;
        synchronized (map) {
            emulatorConnection2.start();
            this.connectedDevices.put(n, emulatorConnection2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection to device " + n + " established:" + " stdout port = " + emulatorConnection2.getStdoutPortNumber() + ", stderr port = " + emulatorConnection2.getStderrPortNumber() + ", jdwp port = " + emulatorConnection2.getJdwpPortNumber() + "."));
        }
        logger.trace((Object)"<-- connect()");
    }

    public DeviceProperties getDeviceProperties(int n) {
        return this.deviceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int n, String string) {
        InputStream inputStream;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("init(deviceId = " + n + ", fileName = " + string + ") -->"));
        }
        if (string != null && (inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string)) != null) {
            FileOutputStream fileOutputStream = null;
            File file = new File(this.workdirHelper.deviceWorkDirectory(String.valueOf(n)), PROPERTIES_FILE_NAME);
            try {
                try {
                    int n2;
                    byte[] byArray = new byte[1024];
                    fileOutputStream = new FileOutputStream(file);
                    while ((n2 = inputStream.read(byArray)) > -1) {
                        fileOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException("File Not Found: " + fileNotFoundException);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    finally {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.out.print("Warning! Cannot copy file: " + iOException.getMessage());
                logger.warn((Object)"Cannot copy file", (Throwable)iOException);
            }
        }
        logger.trace((Object)"<-- init()");
    }

    private EmulatorConnection[] getCurrentConnections() {
        Collection<EmulatorConnection> collection = this.connectedDevices.values();
        EmulatorConnection[] emulatorConnectionArray = new EmulatorConnection[collection.size()];
        collection.toArray(emulatorConnectionArray);
        return emulatorConnectionArray;
    }

    protected String[] createBootClassPath(String[] stringArray) {
        File[] fileArray = FileUtils.getAPIFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            for (String string : stringArray) {
                if (!file.getName().equals(string)) continue;
                arrayList.add(file.getAbsolutePath().replace(File.separatorChar, '/'));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionStopped(EmulatorConnection emulatorConnection) {
        boolean bl;
        int n = emulatorConnection.getDeviceId();
        Map<Integer, EmulatorConnection> map = this.connectedDevices;
        synchronized (map) {
            this.connectedDevices.remove(n);
            bl = this.stopped && this.connectedDevices.isEmpty();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection to emulator " + n + " removed" + " from the adapter."));
        }
        if (bl) {
            this.adapterStopper.clientStopped((AsyncStopperClient)this);
        }
    }

    private String[] filterConnectArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.acceptConnectArgs(arrayList, stringArray, i);
            if (n <= 0) continue;
            i += n - 1;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    protected int acceptConnectArgs(List<String> list, String[] stringArray, int n) {
        String string = stringArray[n];
        if (string.startsWith("-D")) {
            list.add(string);
            return 1;
        }
        if (n + 1 < stringArray.length && (string.equals("-classpath") || string.equals("-cp"))) {
            list.add("-classpath");
            list.add(stringArray[n + 1]);
            return 2;
        }
        return 0;
    }
}

