/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.genericemulator;

import com.sun.jme.toolkit.util.CmdLineSplitter;
import com.sun.jme.toolkit.util.process.AbstractProcessRunner;
import com.sun.jme.toolkit.util.process.ProcessListener;
import com.sun.jme.toolkit.util.propstrparser.PropStringParser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class GenericEmulatorRunner
extends AbstractProcessRunner {
    private static final Logger logger = Logger.getLogger(GenericEmulatorRunner.class);
    private static final Logger vmLogger = Logger.getLogger((String)"VM");
    private String commandLineFileProperties;
    private String commandLineStringProperties;
    private String commandLine;
    private int deviceId;
    private String deviceName;
    private String deviceSkin;
    private String[] connectArgs;
    private File workdir;
    private int stdoutPortNumber;
    private int stderrPortNumber;
    private int jdwpPortNumber;

    public GenericEmulatorRunner(ProcessListener processListener) {
        super(processListener);
    }

    public void setDeviceSkin(String string) {
        this.deviceSkin = string;
    }

    public void setDeviceId(int n) {
        this.deviceId = n;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public void setConnectArgs(String[] stringArray) {
        this.connectArgs = stringArray;
    }

    public void setStdoutPortNumber(int n) {
        this.stdoutPortNumber = n;
    }

    public void setStderrPortNumber(int n) {
        this.stderrPortNumber = n;
    }

    public void setJdwpPortNumber(int n) {
        this.jdwpPortNumber = n;
    }

    public void setCommandLineFileProperties(String string) {
        this.commandLineFileProperties = string;
    }

    public void setCommandLineStringProperties(String string) {
        this.commandLineStringProperties = string;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public void setWorkdir(File file) {
        this.workdir = file;
    }

    protected Process startProcess() throws IOException {
        List<String> list = this.splitCommandLine();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Going to execute following command:");
            for (String string : list) {
                logger.debug((Object)string);
            }
        }
        String[] stringArray = new String[list.size()];
        return Runtime.getRuntime().exec((String[])list.toArray(stringArray), null, this.workdir);
    }

    private List<String> splitCommandLine() {
        CmdLineSplitter cmdLineSplitter = new CmdLineSplitter();
        if (this.commandLineFileProperties != null) {
            GenericEmulatorRunner.addFileProperties(cmdLineSplitter, this.commandLineFileProperties);
        }
        if (this.commandLineStringProperties != null) {
            GenericEmulatorRunner.addStringProperties(cmdLineSplitter, this.commandLineStringProperties);
        }
        this.addCommonProperties(cmdLineSplitter);
        return cmdLineSplitter.splitCommandLine(this.commandLine);
    }

    private void addCommonProperties(CmdLineSplitter cmdLineSplitter) {
        cmdLineSplitter.setProperty("%DEVICE_ID%", Integer.toString(this.deviceId));
        cmdLineSplitter.setProperty("%DEVICE%", this.deviceSkin);
        cmdLineSplitter.setProperty("%DEVICE_NAME%", this.deviceName);
        cmdLineSplitter.setProperty("%CONNECT_ARGS%", GenericEmulatorRunner.createArgsString(this.connectArgs));
        GenericEmulatorRunner.addFileProperty(cmdLineSplitter, "DEVICE_WORKDIR_PATH", this.workdir);
        cmdLineSplitter.setProperty("%STDOUT_PORT_NUMBER%", Integer.toString(this.stdoutPortNumber));
        cmdLineSplitter.setProperty("%STDERR_PORT_NUMBER%", Integer.toString(this.stderrPortNumber));
        cmdLineSplitter.setProperty("%JDWP_PORT_NUMBER%", Integer.toString(this.jdwpPortNumber));
    }

    private static void addFileProperties(CmdLineSplitter cmdLineSplitter, String string) {
        PropStringParser propStringParser = PropStringParser.createInstance((String)string);
        for (Map.Entry entry : propStringParser) {
            GenericEmulatorRunner.addFileProperty(cmdLineSplitter, (String)entry.getKey(), new File((String)entry.getValue()));
        }
    }

    private static void addStringProperties(CmdLineSplitter cmdLineSplitter, String string) {
        PropStringParser propStringParser = PropStringParser.createInstance((String)string);
        for (Map.Entry entry : propStringParser) {
            cmdLineSplitter.setProperty("%" + (String)entry.getKey() + "%", (String)entry.getValue());
        }
    }

    private static void addFileProperty(CmdLineSplitter cmdLineSplitter, String string, File file) {
        String string2 = file.getAbsolutePath();
        String string3 = string2.replace(File.separatorChar, '/');
        String string4 = string2.replace(File.separatorChar, '\\');
        cmdLineSplitter.setProperty("%" + string + "%", string2);
        cmdLineSplitter.setProperty("%" + string + "_FS%", string3);
        cmdLineSplitter.setProperty("%" + string + "_BS%", string4);
    }

    private static String createArgsString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            CmdLineSplitter.appendQuotedValue((StringBuilder)stringBuilder, (String)stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(' ');
                CmdLineSplitter.appendQuotedValue((StringBuilder)stringBuilder, (String)stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    protected void handleOutput(String string) {
        vmLogger.debug((Object)string);
    }
}

