/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.genericemulator;

import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public final class PortPool {
    public static final int INVALID_PORT_NUMBER = -1;
    private final SortedSet<Integer> reservedPortNumbers = new TreeSet<Integer>();
    private final int minPortNumber;
    private final int maxPortNumber;

    public PortPool(int n, int n2) {
        this.minPortNumber = n;
        this.maxPortNumber = n2;
    }

    public synchronized int reservePortNumber() {
        Iterator iterator = this.reservedPortNumbers.iterator();
        for (int i = this.minPortNumber; i <= this.maxPortNumber; ++i) {
            if (iterator.hasNext() && (Integer)iterator.next() == i) continue;
            try {
                DatagramSocket datagramSocket = new DatagramSocket(i);
                datagramSocket.close();
            }
            catch (SocketException socketException) {
                continue;
            }
            this.reservedPortNumbers.add(i);
            return i;
        }
        return -1;
    }

    public synchronized void freePortNumber(int n) {
        this.reservedPortNumbers.remove(n);
    }
}

