/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.process;

import com.sun.jme.toolkit.util.process.ProcessListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractProcessRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger(AbstractProcessRunner.class);
    private final ProcessListener listener;
    private Process process;
    private StreamConsumerThread stdoutConsumerThread;
    private StreamConsumerThread stderrConsumerThread;
    private Thread stopDetectionThread;
    private boolean stopped;
    private CountDownLatch finishedLatch = new CountDownLatch(1);

    public AbstractProcessRunner() {
        this(null);
    }

    public AbstractProcessRunner(ProcessListener processListener) {
        this.listener = processListener;
    }

    public int getExitValue() throws InterruptedException {
        this.finishedLatch.await();
        return this.process.exitValue();
    }

    public boolean waitForProcessTerminated(int n) throws InterruptedException {
        return this.finishedLatch.await(n, TimeUnit.MILLISECONDS);
    }

    public void start() throws IOException {
        this.process = this.startProcess();
        this.stdoutConsumerThread = new StreamConsumerThread(this.process.getInputStream());
        this.stdoutConsumerThread.setName("stdout consumer for " + this.process);
        this.stderrConsumerThread = new StreamConsumerThread(this.process.getErrorStream());
        this.stderrConsumerThread.setName("stderr consumer for " + this.process);
        this.stdoutConsumerThread.start();
        this.stderrConsumerThread.start();
        this.stopped = false;
        this.stopDetectionThread = new Thread((Runnable)this, "Stop detection thread for " + this.process);
        this.stopDetectionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AbstractProcessRunner abstractProcessRunner = this;
        synchronized (abstractProcessRunner) {
            if (this.stopped) {
                return;
            }
            this.process.destroy();
        }
        try {
            this.stopDetectionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug((Object)"Stopping done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.listener != null) {
            this.listener.processTerminated(this, this.process.exitValue());
        }
        AbstractProcessRunner abstractProcessRunner = this;
        synchronized (abstractProcessRunner) {
            this.stopped = true;
            this.stdoutConsumerThread = null;
            this.stderrConsumerThread = null;
        }
        this.finishedLatch.countDown();
    }

    protected abstract Process startProcess() throws IOException;

    protected abstract void handleOutput(String var1);

    private final class StreamConsumerThread
    extends Thread {
        private final BufferedReader reader;
        private boolean stop;

        public StreamConsumerThread(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            logger.debug((Object)"Stream consumer thread started.");
            try {
                String string = this.reader.readLine();
                while (string != null) {
                    AbstractProcessRunner.this.handleOutput(string);
                    string = this.reader.readLine();
                }
            }
            catch (IOException iOException) {
                logger.debug((Object)"Got an IOException while consuming stream!", (Throwable)iOException);
            }
            this.cleanup();
            logger.debug((Object)"Stream consumer thread finished.");
        }

        public void finish() {
            this.cleanup();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private synchronized void cleanup() {
            if (!this.stop) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    logger.debug((Object)"Exception while closing the consumer stream!", (Throwable)iOException);
                }
                this.stop = true;
            }
        }
    }
}

