/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.lime.NullProfiler;
import com.sun.kvem.lime.Profiler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public abstract class Lime {
    protected static boolean debug = Boolean.getBoolean("lime.debug");
    protected static boolean synchronous = Boolean.getBoolean("lime.synchronous");
    protected Profiler profiler = null;
    protected Object lock = new Object();

    public static Lime createLime() {
        String string = System.getProperty("lime.implementation", "com.sun.kvem.lime.LimeImpl");
        try {
            return (Lime)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Cannot instantiate LIME implementation " + string + "'");
            return null;
        }
    }

    protected Lime() {
        this.profiler = this.createProfiler();
    }

    protected Profiler createProfiler() {
        String string = System.getProperty("lime.profiler", "com.sun.kvem.lime.NullProfiler");
        try {
            return (Profiler)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Cannot instantiate LIME profiler " + string + "'");
            return new NullProfiler();
        }
    }

    public Process runClient(String string, String[] stringArray) throws IOException {
        return this.runClient(string, stringArray, null);
    }

    public Process runClient(String string, String[] stringArray, String[] stringArray2) throws IOException {
        return this.runClient(string, stringArray, stringArray2, new File(System.getProperty("user.dir")));
    }

    public abstract Process runClient(String var1, String[] var2, String[] var3, File var4) throws IOException;

    public abstract void disconnect();

    public abstract void incrementEventCount();

    public Object getLock() {
        return this.lock;
    }

    protected class FakeProcess
    extends Process
    implements Runnable {
        Integer result;
        List<String> argv;

        public FakeProcess(List<String> list) {
            this.argv = list;
            System.loadLibrary("zayit");
            new Thread(this).start();
        }

        @Override
        public native void run();

        @Override
        public void destroy() {
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public InputStream getErrorStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public OutputStream getOutputStream() {
            return null;
        }

        @Override
        public int waitFor() {
            while (this.result == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return this.result;
        }
    }
}

