/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.lime;

import com.sun.kvem.lime.Profiler;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollatingProfiler
implements Profiler {
    private static Comparator countOrderer = new Comparator(){

        public int compare(Object object, Object object2) {
            MethodEntry methodEntry = (MethodEntry)object;
            MethodEntry methodEntry2 = (MethodEntry)object2;
            return methodEntry2.callCount - methodEntry.callCount;
        }
    };
    private static Comparator timeOrderer = new Comparator(){

        public int compare(Object object, Object object2) {
            MethodEntry methodEntry = (MethodEntry)object;
            MethodEntry methodEntry2 = (MethodEntry)object2;
            return methodEntry2.totalTime - methodEntry.totalTime;
        }
    };
    private Map threadMap = new HashMap();

    @Override
    public synchronized void profileMethodCallStart(Method method, Object[] objectArray) {
        Thread thread = Thread.currentThread();
        ThreadEntry threadEntry = (ThreadEntry)this.threadMap.get(thread);
        if (threadEntry == null) {
            threadEntry = new ThreadEntry();
            this.threadMap.put(thread, threadEntry);
        }
        if (threadEntry.inCall) {
            throw new RuntimeException("Profiling call stack corrupted");
        }
        threadEntry.inCall = true;
        threadEntry.lastCallStartTime = System.currentTimeMillis();
        MethodEntry methodEntry = (MethodEntry)threadEntry.methodMap.get(method);
        if (methodEntry == null) {
            methodEntry = new MethodEntry();
            methodEntry.method = method;
            threadEntry.methodMap.put(method, methodEntry);
        }
    }

    @Override
    public synchronized void profileMethodCallEnd(Method method, Object[] objectArray) {
        Thread thread = Thread.currentThread();
        ThreadEntry threadEntry = (ThreadEntry)this.threadMap.get(thread);
        if (!threadEntry.inCall) {
            throw new RuntimeException("Profiling call stack corrupted");
        }
        threadEntry.inCall = false;
        long l = threadEntry.lastCallStartTime;
        long l2 = System.currentTimeMillis();
        int n = (int)(l2 - l);
        MethodEntry methodEntry = (MethodEntry)threadEntry.methodMap.get(method);
        ++methodEntry.callCount;
        methodEntry.totalTime += n;
        methodEntry.totalSquaredTime += n * n;
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        Object object;
        Object object22;
        HashMap<Method, MethodEntry> hashMap = new HashMap<Method, MethodEntry>();
        for (Object object22 : this.threadMap.values()) {
            object = ((ThreadEntry)object22).methodMap;
            for (MethodEntry methodEntry : object.values()) {
                MethodEntry methodEntry2 = (MethodEntry)hashMap.get(methodEntry.method);
                if (methodEntry2 == null) {
                    hashMap.put(methodEntry.method, methodEntry);
                    continue;
                }
                methodEntry2.callCount += methodEntry.callCount;
                methodEntry2.totalTime += methodEntry.totalTime;
            }
        }
        object22 = new ArrayList();
        object22.addAll(hashMap.values());
        Collections.sort(object22, timeOrderer);
        Collections.sort(object22, countOrderer);
        printWriter.println("Calls in order of frequency");
        printWriter.println("---------------------------");
        printWriter.println("count     average/ms      total/ms  method");
        printWriter.println("-----------------------------------------");
        object = "{2}  {4}  {3}  {0}.{1}";
        this.writeList((List)object22, printWriter, (String)object);
        Collections.sort(object22, countOrderer);
        Collections.sort(object22, timeOrderer);
        printWriter.println("\n\nCalls in order of total time");
        printWriter.println("----------------------------");
        printWriter.println("total/ms     average/ms      count  method");
        printWriter.println("------------------------------------------");
        object = "{3}  {4}  {2}  {0}.{1}";
        this.writeList((List)object22, printWriter, (String)object);
    }

    private void writeList(List list, PrintWriter printWriter, String string) {
        Object[] objectArray = new Object[5];
        for (MethodEntry methodEntry : list) {
            objectArray[0] = methodEntry.method.getDeclaringClass().getName();
            objectArray[1] = methodEntry.method.getName();
            objectArray[2] = this.pad(String.valueOf(methodEntry.callCount), 5);
            objectArray[3] = this.pad(String.valueOf(methodEntry.totalTime), 8);
            if (methodEntry.callCount == 0) {
                objectArray[4] = "N/A";
            } else {
                double d = (double)methodEntry.totalSquaredTime / (double)methodEntry.callCount;
                double d2 = (double)methodEntry.totalTime / (double)methodEntry.callCount;
                double d3 = d - d2 * d2;
                double d4 = Math.sqrt(d3);
                String string2 = d4 == 0.0 ? MessageFormat.format("{0,number,###0.00}       ", new Double(d2)) : MessageFormat.format("{0,number,###0.00} \u00b1 {1,number,###0.00}", new Double(d2), new Double(d4));
                objectArray[4] = this.pad(string2, 17);
            }
            String string3 = MessageFormat.format(string, objectArray);
            printWriter.println(string3);
        }
    }

    String pad(String string, int n) {
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    private static class MethodEntry {
        Method method;
        int callCount = 0;
        int totalTime = 0;
        int totalSquaredTime = 0;

        private MethodEntry() {
        }
    }

    private static class ThreadEntry {
        Map methodMap = new HashMap();
        long lastCallStartTime;
        boolean inCall = false;

        private ThreadEntry() {
        }
    }
}

