/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.lime;

import com.sun.kvem.lime.ArrayHandler;
import com.sun.kvem.lime.ByteBufferType;
import com.sun.kvem.lime.CharBufferType;
import com.sun.kvem.lime.DataHandler;
import com.sun.kvem.lime.PrimitiveBoolean;
import com.sun.kvem.lime.PrimitiveByte;
import com.sun.kvem.lime.PrimitiveCharacter;
import com.sun.kvem.lime.PrimitiveInteger;
import com.sun.kvem.lime.PrimitiveLong;
import com.sun.kvem.lime.PrimitiveShort;
import com.sun.kvem.lime.PrimitiveVoid;
import com.sun.kvem.lime.StringType;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DataManager {
    private static DataManager instance = new DataManager();
    private Hashtable handlers = new Hashtable();
    private Vector index = new Vector();

    private void registerHandler(Class clazz, DataHandler dataHandler) {
        Class<?> clazz2 = clazz.getComponentType();
        this.handlers.put(clazz2, dataHandler);
        if (clazz2.isPrimitive() && clazz2 == Integer.TYPE) {
            this.handlers.put(Integer.class, dataHandler);
        }
        this.handlers.put(clazz, new ArrayHandler(dataHandler));
    }

    private DataManager() {
        this.handlers.put(Void.TYPE, new PrimitiveVoid());
        this.registerHandler(boolean[].class, new PrimitiveBoolean());
        this.registerHandler(byte[].class, new PrimitiveByte());
        this.registerHandler(char[].class, new PrimitiveCharacter());
        this.registerHandler(short[].class, new PrimitiveShort());
        this.registerHandler(int[].class, new PrimitiveInteger());
        this.registerHandler(long[].class, new PrimitiveLong());
        this.handlers.put(String.class, new StringType());
        this.handlers.put(ByteBuffer.class, new ByteBufferType());
        this.handlers.put(CharBuffer.class, new CharBufferType());
        Enumeration enumeration = this.handlers.elements();
        while (enumeration.hasMoreElements()) {
            DataHandler dataHandler = (DataHandler)enumeration.nextElement();
            int n = dataHandler.getTypeNumber();
            while (this.index.size() <= n) {
                this.index.addElement(null);
            }
            this.index.setElementAt(dataHandler, n);
        }
    }

    public static DataManager getManager() {
        return instance;
    }

    public DataHandler getHandler(Class clazz) {
        DataHandler dataHandler = (DataHandler)this.handlers.get(clazz);
        if (dataHandler == null) {
            System.err.println("No LIME data handler found for class '" + clazz + "'.");
        }
        return dataHandler;
    }

    public DataHandler getHandler(int n) {
        DataHandler dataHandler = (DataHandler)this.index.elementAt(n);
        if (dataHandler == null) {
            System.err.println("No LIME data handler found for type #" + n);
        }
        return dataHandler;
    }
}

