/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.tray;

import com.growl.GrowlWrapper;
import com.sun.jme.toolkit.tray.IconItem;
import com.sun.jme.toolkit.tray.IconSection;
import com.sun.jme.toolkit.tray.SystemTrayAdapter;
import com.sun.jme.toolkit.tray.TrayIconManager;
import java.awt.AWTException;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

class Java6Adapter
implements SystemTrayAdapter {
    private MessageNotifier notifier;
    private boolean isSupported = false;
    private static Logger LOGGER = Logger.getLogger(Java6Adapter.class);
    private TrayIcon icon;
    private Map<IconSection, NavigableMap<Integer, IconItem>> itemMap = this.generateBlankEnumMap();
    private List<IconItem> overFlow = new LinkedList<IconItem>();
    private PopupMenu popup = Java6Adapter.generateSectionedPopup();

    Java6Adapter() {
    }

    private Map<IconSection, NavigableMap<Integer, IconItem>> generateBlankEnumMap() {
        EnumMap<IconSection, NavigableMap<Integer, IconItem>> enumMap = new EnumMap<IconSection, NavigableMap<Integer, IconItem>>(IconSection.class);
        for (IconSection iconSection : IconSection.values()) {
            enumMap.put(iconSection, new TreeMap());
        }
        return enumMap;
    }

    private static PopupMenu generateSectionedPopup() {
        PopupMenu popupMenu = new PopupMenu();
        for (int i = 0; i < IconSection.values().length - 1; ++i) {
            popupMenu.add("-");
        }
        return popupMenu;
    }

    private String getIconPath() {
        return "/com/sun/jme/toolkit/tray/icon" + (System.getProperty("os.name").equals("Mac OS X") ? "_mac" : "") + ".png";
    }

    public void start() throws AWTException {
        try {
            this.isSupported = SystemTray.isSupported();
            if (!this.isSupported) {
                LOGGER.warn((Object)"Cannot create tray icon!");
                return;
            }
            this.initializeIcon();
            SystemTray.getSystemTray().add(this.icon);
            if (System.getProperty("os.name").equals("Mac OS X")) {
                try {
                    this.notifier = new GrowlNotifier();
                }
                catch (GrowlCannotStartException growlCannotStartException) {
                    this.notifier = new DefaultNotifier();
                }
            } else {
                this.notifier = new DefaultNotifier();
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error during the tray initialization", (Throwable)exception);
        }
    }

    private void initializeIcon() throws Exception {
        this.icon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(TrayIconManager.class.getResource(this.getIconPath())), System.getProperty("device-manager.title"), this.popup);
        this.icon.setImageAutoSize(true);
    }

    public void stop() {
        if (this.isSupported) {
            SystemTray.getSystemTray().remove(this.icon);
        }
    }

    private int sectionToMenuIndex(int n, IconSection iconSection) {
        int n2 = 0;
        for (IconSection iconSection2 : IconSection.values()) {
            if (iconSection == iconSection2) {
                n2 += n;
                break;
            }
            n2 += this.itemMap.get(iconSection2).size() + 1;
        }
        return n2;
    }

    public void addItem(IconItem iconItem) {
        if (iconItem.isVisible()) {
            this.itemMap.get(iconItem.getSection()).put(iconItem.getPosition(), iconItem);
            int n = this.itemMap.get(iconItem.getSection()).headMap(iconItem.getPosition()).size();
            this.popup.insert(iconItem.getMenuItem(), this.sectionToMenuIndex(n, iconItem.getSection()));
        }
    }

    public void showMessage(String string, String string2) {
        this.notifier.showMessage(string, string2);
    }

    private static class GrowlNotifier
    implements MessageNotifier {
        private static final String NOTIFICATION_1 = "General notification";
        private GrowlWrapper growl = new GrowlWrapper(System.getProperty("device-manager.title"), "device-manager", new String[]{"General notification"}, new String[]{"General notification"});

        public GrowlNotifier() throws GrowlCannotStartException {
            if (this.growl.getState() != 0) {
                throw new GrowlCannotStartException();
            }
        }

        @Override
        public void showMessage(String string, String string2) {
            this.growl.notify(NOTIFICATION_1, string, string2);
        }
    }

    private static class GrowlCannotStartException
    extends Exception {
        private GrowlCannotStartException() {
        }
    }

    private class DefaultNotifier
    implements MessageNotifier {
        private DefaultNotifier() {
        }

        @Override
        public void showMessage(String string, String string2) {
            Java6Adapter.this.icon.displayMessage(string, string2, TrayIcon.MessageType.NONE);
        }
    }

    private static interface MessageNotifier {
        public void showMessage(String var1, String var2);
    }
}

