/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.genericdevice;

import com.sun.jme.services.connmanager.ConnectionManagerService;
import com.sun.jme.services.productdesc.ProductInstanceId;
import com.sun.jme.toolkit.device.connection.rmiimpl.ConnectionImpl;
import com.sun.jme.toolkit.device.connmanager.api.ConnectionException;
import com.sun.jme.toolkit.device.connmanager.api.ConnectionManager;
import com.sun.jme.toolkit.device.debugging.rmiimpl.DebuggingImpl;
import com.sun.jme.toolkit.device.outputredirect.rmiimpl.OutputRedirectionImpl;
import com.sun.jme.toolkit.deviceadapter.api.DeviceNotAvailableException;
import com.sun.jme.toolkit.deviceadapter.genericdevice.DeviceConnectionListener;
import com.sun.jme.toolkit.deviceadapter.genericdevice.ProductParams;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import com.sun.jme.toolkit.devicedetection.odt.OdtProductAddress;
import com.sun.jme.toolkit.remoting.bridge.JavameNetworking;
import com.sun.jme.toolkit.remoting.bridge.JavameRemotingService;
import com.sun.jme.toolkit.remoting.bridge.JavameRemotingServiceListener;
import com.sun.jme.toolkit.remoting.bridge.JavameServicesBridge;
import com.sun.jme.toolkit.remoting.bridge.JavameServicesBridgeFactory;
import com.sun.jme.toolkit.remoting.bridge.SocketConfiguration;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.jme.toolkit.remoting.server.api.ObjectServer;
import com.sun.jme.toolkit.remoting.server.rmiimpl.ObjectServerImpl;
import com.sun.jme.toolkit.remoting.server.rmiimpl.RemotingConnectorImpl;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.LoopbackSocketFactory;
import com.sun.jme.toolkit.socket.portforwarder.PortForwarder;
import com.sun.jme.toolkit.socket.portforwarder.PortForwarderImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.apache.log4j.Logger;

public class DeviceConnection
implements JavameRemotingServiceListener {
    private static final Logger logger = Logger.getLogger(DeviceConnection.class);
    private final int deviceId;
    private final ProductInstanceId productId;
    private final OdtProductAddress productAddress;
    private final ProductParams productParams;
    private JavameServicesBridgeFactory javameServicesBridgeFactory;
    private DeviceConnectionManager deviceConnectionManager;
    private String rmiRegistryHost;
    private int rmiRegistryPort;
    private DeviceConnectionListener listener;
    private SocketConfiguration socketConfiguration;
    private JavameRemotingService javameRemotingService;
    private JavameServicesBridge javameServicesBridge;
    private ObjectServerImpl objectServer;
    private RemotingConnectorImpl remotingConnector;
    private PortForwarder stdoutPortForwarder;
    private PortForwarder stderrPortForwarder;
    private PortForwarder jdwpPortForwarder;
    private final Object startStopLock = new Object();
    private boolean started;

    public DeviceConnection(int n, ProductInstanceId productInstanceId, OdtProductAddress odtProductAddress, ProductParams productParams) {
        this.deviceId = n;
        this.productId = productInstanceId;
        this.productAddress = odtProductAddress;
        this.productParams = productParams;
    }

    public final void setJavameServicesBridgeFactory(JavameServicesBridgeFactory javameServicesBridgeFactory) {
        this.javameServicesBridgeFactory = javameServicesBridgeFactory;
    }

    public final void setDeviceConnectionManager(DeviceConnectionManager deviceConnectionManager) {
        this.deviceConnectionManager = deviceConnectionManager;
    }

    public final void setRmiRegistryHost(String string) {
        this.rmiRegistryHost = string;
    }

    public final void setRmiRegistryPort(int n) {
        this.rmiRegistryPort = n;
    }

    public final void setListener(DeviceConnectionListener deviceConnectionListener) {
        this.listener = deviceConnectionListener;
    }

    public final void setSocketConfiguration(SocketConfiguration socketConfiguration) {
        this.socketConfiguration = socketConfiguration;
    }

    public final ProductInstanceId getProductId() {
        return this.productId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws DeviceNotAvailableException {
        DeviceIpAddress deviceIpAddress = (DeviceIpAddress)this.productAddress.getDeviceAddress();
        try {
            InetAddress inetAddress = InetAddress.getByName(deviceIpAddress.getDeviceAddress());
            Object object = this.startStopLock;
            synchronized (object) {
                this.createJavameRemotingService(inetAddress);
                this.startImpl(inetAddress, this.getHostAddress());
                this.started = true;
            }
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            logger.trace((Object)("Failed to connect to device " + this.deviceId + "!"), (Throwable)deviceNotAvailableException);
            this.stopJavameRemotingService();
            throw deviceNotAvailableException;
        }
        catch (Exception exception) {
            logger.trace((Object)("Failed to connect to device " + this.deviceId + "!"), (Throwable)exception);
            this.stopJavameRemotingService();
            throw new DeviceNotAvailableException(exception.getMessage());
        }
    }

    private void startImpl(InetAddress inetAddress, InetAddress inetAddress2) throws Exception {
        this.createObjectServer();
        this.javameServicesBridge = this.javameServicesBridgeFactory.createInstance((ObjectServer)this.objectServer, this.javameRemotingService);
        this.javameServicesBridge.start();
        this.connectStandardOuptut(inetAddress, this.productParams.getProductStdoutPort());
        this.connectErrorOutput(inetAddress, this.productParams.getProductStderrPort());
        this.connectDebugger(inetAddress, this.productParams.getProductJdwpPort());
        this.registerCommonServices(inetAddress2);
        this.initDeviceConnection();
    }

    protected void connectStandardOuptut(InetAddress inetAddress, int n) throws Exception {
        this.stdoutPortForwarder = DeviceConnection.createAndStartPortForwarder(inetAddress, n);
    }

    protected void connectErrorOutput(InetAddress inetAddress, int n) throws Exception {
        this.stderrPortForwarder = DeviceConnection.createAndStartPortForwarder(inetAddress, n);
    }

    protected void connectDebugger(InetAddress inetAddress, int n) throws Exception {
        this.jdwpPortForwarder = DeviceConnection.createAndStartPortForwarder(inetAddress, n);
    }

    protected final OdtProductAddress getProductAddress() {
        return this.productAddress;
    }

    public final void stop() {
        this.stopJavameRemotingService();
    }

    public final int getStdoutPortNumber() {
        return DeviceConnection.getPortNumber(this.stdoutPortForwarder);
    }

    public final int getStderrPortNumber() {
        return DeviceConnection.getPortNumber(this.stderrPortForwarder);
    }

    public final int getDeviceId() {
        return this.deviceId;
    }

    public int getJdwpPortNumber() {
        return DeviceConnection.getPortNumber(this.jdwpPortForwarder);
    }

    public boolean checkConnection() {
        try {
            ConnectionManagerService connectionManagerService = (ConnectionManagerService)this.javameRemotingService.getRemoteObject("ConnectionManager", ConnectionManagerService.class);
            connectionManagerService.checkConnection();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void registerCommonServices(InetAddress inetAddress) {
        ConnectionImpl connectionImpl = new ConnectionImpl();
        connectionImpl.setDeviceHostAddress(inetAddress);
        this.objectServer.registerObject((Object)connectionImpl, "Connection");
        OutputRedirectionImpl outputRedirectionImpl = new OutputRedirectionImpl();
        outputRedirectionImpl.setStdoutPortNumber(DeviceConnection.getPortNumber(this.stdoutPortForwarder));
        outputRedirectionImpl.setStderrPortNumber(DeviceConnection.getPortNumber(this.stderrPortForwarder));
        this.objectServer.registerObject((Object)outputRedirectionImpl, "OutputRedirection");
        DebuggingImpl debuggingImpl = new DebuggingImpl();
        debuggingImpl.setJdwpPortNumber(this.getJdwpPortNumber());
        this.objectServer.registerObject((Object)debuggingImpl, "Debugging");
    }

    private void createJavameRemotingService(InetAddress inetAddress) throws IOException {
        JavameRemotingService javameRemotingService = new JavameRemotingService((JavameRemotingServiceListener)this);
        JavameNetworking javameNetworking = new JavameNetworking();
        javameNetworking.setServerAddress(inetAddress);
        javameNetworking.setServerportNumber(this.productAddress.getPort());
        javameRemotingService.setJavameNetworking(javameNetworking);
        javameRemotingService.setSocketConfiguration(this.socketConfiguration);
        javameRemotingService.start();
        this.javameRemotingService = javameRemotingService;
    }

    private void stopJavameRemotingService() {
        if (this.javameRemotingService != null) {
            this.javameRemotingService.stop();
        }
    }

    private void createObjectServer() throws Exception {
        ObjectServerImpl objectServerImpl = new ObjectServerImpl();
        objectServerImpl.setName("device-" + this.deviceId);
        objectServerImpl.start();
        this.objectServer = objectServerImpl;
        RemotingConnectorImpl remotingConnectorImpl = new RemotingConnectorImpl();
        remotingConnectorImpl.setRmiRegistryHost(this.rmiRegistryHost);
        remotingConnectorImpl.setRmiRegistryPort(this.rmiRegistryPort);
        remotingConnectorImpl.setObjectServerImpl(this.objectServer);
        LoopbackSocketFactory loopbackSocketFactory = new LoopbackSocketFactory();
        remotingConnectorImpl.setServerSocketFactory((RMIServerSocketFactory)loopbackSocketFactory);
        remotingConnectorImpl.setClientSocketFactory((RMIClientSocketFactory)loopbackSocketFactory);
        remotingConnectorImpl.start();
        this.remotingConnector = remotingConnectorImpl;
    }

    private void stopObjectServer() {
        if (this.remotingConnector != null) {
            try {
                this.remotingConnector.stop();
            }
            catch (Exception exception) {
                logger.trace((Object)"Failed to stop remoting connector!", (Throwable)exception);
            }
            this.remotingConnector = null;
        }
        if (this.objectServer != null) {
            try {
                this.objectServer.stop();
            }
            catch (Exception exception) {
                logger.trace((Object)"Failed to stop object server!", (Throwable)exception);
            }
            this.objectServer = null;
        }
    }

    private void initDeviceConnection() throws DeviceNotAvailableException {
        try {
            ConnectionManager connectionManager = this.getDeviceConnectionManager();
            connectionManager.initializeConnection();
        }
        catch (ConnectionException connectionException) {
            logger.trace((Object)("Failed to initialize connection with device " + this.deviceId + "!"), (Throwable)connectionException);
            throw new DeviceNotAvailableException(connectionException.getMessage());
        }
        catch (Exception exception) {
            logger.trace((Object)("Failed to initialize connection with device " + this.deviceId + "!"), (Throwable)exception);
            throw new DeviceNotAvailableException("Failed to initialize connection with device " + this.deviceId + "! (possible runtime incompatibility)");
        }
    }

    private ConnectionManager getDeviceConnectionManager() throws Exception {
        ObjectServerConnection objectServerConnection = this.deviceConnectionManager.openDeviceConnection(this.deviceId);
        ConnectionManager connectionManager = (ConnectionManager)objectServerConnection.findObject(ConnectionManager.class, ConnectionManager.class.getSimpleName());
        return connectionManager;
    }

    private InetAddress getHostAddress() {
        DeviceIpAddress deviceIpAddress = (DeviceIpAddress)this.productAddress.getDeviceAddress();
        String string = deviceIpAddress.getHostAddress();
        if (string != null) {
            try {
                return InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.javameRemotingService.getHostAddress();
    }

    private static final int getPortNumber(PortForwarder portForwarder) {
        return portForwarder != null ? portForwarder.getLocalPort() : -1;
    }

    private static PortForwarder createAndStartPortForwarder(InetAddress inetAddress, int n) {
        PortForwarderImpl portForwarderImpl = new PortForwarderImpl(0, inetAddress, n);
        try {
            portForwarderImpl.start();
            return portForwarderImpl;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void cleanup() {
        if (this.javameServicesBridge != null) {
            this.javameServicesBridge.stop();
        }
        this.stopObjectServer();
        if (this.stdoutPortForwarder != null) {
            this.stdoutPortForwarder.stop();
        }
        if (this.stderrPortForwarder != null) {
            this.stderrPortForwarder.stop();
        }
        if (this.jdwpPortForwarder != null) {
            this.jdwpPortForwarder.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serviceStopped(JavameRemotingService javameRemotingService) {
        Object object = this.startStopLock;
        synchronized (object) {
            this.cleanup();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection to device " + this.deviceId + " stopped."));
        }
        if (this.listener != null && this.started) {
            this.listener.connectionStopped(this);
        }
    }
}

