/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceadapter.genericdevice;

import com.sun.jme.services.productdesc.ProductDescriptor;
import com.sun.jme.services.productdesc.ProductInstanceId;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceState;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateManager;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.deviceadapter.api.DeviceNotAvailableException;
import com.sun.jme.toolkit.deviceadapter.api.DeviceProperties;
import com.sun.jme.toolkit.deviceadapter.genericdevice.DeviceConnection;
import com.sun.jme.toolkit.deviceadapter.genericdevice.DeviceConnectionListener;
import com.sun.jme.toolkit.deviceadapter.genericdevice.GenericOdtDeviceAdapterMBean;
import com.sun.jme.toolkit.deviceadapter.genericdevice.ProductParams;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import com.sun.jme.toolkit.devicedetection.odt.OdtDetectionResult;
import com.sun.jme.toolkit.devicedetection.odt.OdtDetectorClient;
import com.sun.jme.toolkit.devicedetection.odt.OdtDeviceDetector;
import com.sun.jme.toolkit.devicedetection.odt.OdtProductAddress;
import com.sun.jme.toolkit.remoting.bridge.JavameServicesBridgeFactory;
import com.sun.jme.toolkit.remoting.bridge.SocketConfiguration;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenericOdtDeviceAdapter
implements GenericOdtDeviceAdapterMBean,
DeviceConnectionListener,
OdtDetectorClient {
    private static final Logger logger = Logger.getLogger(GenericOdtDeviceAdapter.class);
    private final Map<Integer, DeviceConnection> connectedDevices = new HashMap<Integer, DeviceConnection>();
    private final Map<ProductDescriptor, ProductParams> productsParams = new HashMap<ProductDescriptor, ProductParams>();
    private final Map<ProductInstanceId, Integer> productIdToDeviceId = new HashMap<ProductInstanceId, Integer>();
    private final Object deviceDetectionLock = new Object();
    private DeviceManager deviceManager;
    private DeviceStateManager deviceStateManager;
    private DeviceConnectionManager deviceConnectionManager;
    private OdtDeviceDetector odtDeviceDetector;
    private String adapterName;
    private boolean stopped;
    private JavameServicesBridgeFactory jmeServicesBridgeFactory;
    private String rmiRegistryHost;
    private int rmiRegistryPort;
    private int remotingPortNumber;
    private boolean disableVerification;
    private int verificationConnectTimeout;
    private SocketConfiguration socketConfiguration;

    public final void setRmiRegistryHost(String string) {
        this.rmiRegistryHost = string;
    }

    public final void setRmiRegistryPort(int n) {
        this.rmiRegistryPort = n;
    }

    public final void setRemotingPortNumber(int n) {
        this.remotingPortNumber = n;
    }

    public final void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public final void setDeviceStateManager(DeviceStateManager deviceStateManager) {
        this.deviceStateManager = deviceStateManager;
    }

    public void setDeviceConnectionManager(DeviceConnectionManager deviceConnectionManager) {
        this.deviceConnectionManager = deviceConnectionManager;
    }

    public void setOdtDeviceDetector(OdtDeviceDetector odtDeviceDetector) {
        this.odtDeviceDetector = odtDeviceDetector;
    }

    public final void setJmeServicesBridgeFactory(JavameServicesBridgeFactory javameServicesBridgeFactory) {
        this.jmeServicesBridgeFactory = javameServicesBridgeFactory;
    }

    public final void addProductParams(ProductParams productParams) {
        this.productsParams.put(productParams.getProductDescriptor(), productParams);
    }

    public final String getName() {
        return this.adapterName;
    }

    public final void setName(String string) {
        this.adapterName = string;
    }

    public final void setDisableVerification(boolean bl) {
        this.disableVerification = bl;
    }

    public final void setVerificationConnectTimeout(int n) {
        this.verificationConnectTimeout = n;
    }

    public final void setSocketConfiguration(SocketConfiguration socketConfiguration) {
        this.socketConfiguration = socketConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProductInstanceId productInstanceId;
        int[] nArray = this.deviceManager.getDeviceIds(this.adapterName);
        for (int n : nArray) {
            productInstanceId = this.getProductInstanceId(n);
            if (productInstanceId != null) {
                this.productIdToDeviceId.put(productInstanceId, n);
            }
            this.deviceStateManager.setDeviceState(n, DeviceState.UNAVAILABLE);
        }
        Object object = this.productsParams.values().iterator();
        while (object.hasNext()) {
            ProductParams productParams = (ProductParams)object.next();
            DeviceProperties deviceProperties = productParams.getDeviceProperties();
            deviceProperties.setBootClassPathAsArray(this.createBootClassPath(deviceProperties.getBootClassPath()));
        }
        object = this.deviceDetectionLock;
        synchronized (object) {
            this.odtDeviceDetector.addOdtDetectorClient((OdtDetectorClient)this);
            Collection collection = this.odtDeviceDetector.getDetectedProducts();
            for (ProductInstanceId productInstanceId2 : collection) {
                productInstanceId = this.odtDeviceDetector.getDetectionResult(productInstanceId2);
                if (productInstanceId == null) continue;
                this.productDetectedImpl(productInstanceId.getProductInstanceId(), productInstanceId.getProductDescriptor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.odtDeviceDetector.removeOdtDetectorClient((OdtDetectorClient)this);
        DeviceConnection[] deviceConnectionArray = this;
        synchronized (this) {
            this.stopped = true;
            // ** MonitorExit[deviceConnectionArray] (shouldn't be in output)
            Map<Integer, DeviceConnection> object = this.connectedDevices;
            synchronized (object) {
                deviceConnectionArray = this.getCurrentConnections();
            }
            for (DeviceConnection deviceConnection : deviceConnectionArray) {
                deviceConnection.stop();
            }
            if (logger.isDebugEnabled()) {
                Map<Integer, DeviceConnection> map = this.connectedDevices;
                synchronized (map) {
                    logger.debug((Object)(this.connectedDevices.size() + " device connections" + " remained open."));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void connect(int n, String[] stringArray) throws DeviceNotAvailableException {
        DeviceConnection deviceConnection;
        OdtProductAddress odtProductAddress;
        DeviceConnection deviceConnection2;
        if (this.stopped) {
            throw new DeviceNotAvailableException("Device adapter has been stopped!");
        }
        RegistrationData registrationData = this.connectedDevices;
        synchronized (registrationData) {
            deviceConnection2 = this.connectedDevices.get(n);
            if (deviceConnection2 != null && deviceConnection2.checkConnection()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Device " + n + " is alive and" + " the connection to it is up."));
                }
                return;
            }
        }
        if (deviceConnection2 != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connection to device " + n + " has" + " been lost."));
            }
            deviceConnection2.stop();
        }
        if ((registrationData = this.deviceManager.getDeviceRegistration(n)) == null) {
            throw new DeviceNotAvailableException("Device " + n + " not registered!");
        }
        ProductInstanceId productInstanceId = GenericOdtDeviceAdapter.getProductInstanceId(registrationData);
        ProductDescriptor productDescriptor = GenericOdtDeviceAdapter.getProductDescriptor(registrationData);
        ProductParams productParams = this.productsParams.get(productDescriptor);
        if (productParams == null) {
            throw new DeviceNotAvailableException("Registration for device " + n + " is invalid!");
        }
        OdtProductAddress odtProductAddress2 = GenericOdtDeviceAdapter.getProductAddress(registrationData);
        OdtDetectionResult odtDetectionResult = productInstanceId != null ? this.odtDeviceDetector.getDetectionResult(productInstanceId) : null;
        OdtProductAddress odtProductAddress3 = odtProductAddress = odtDetectionResult != null ? odtDetectionResult.getProductAddress() : odtProductAddress2;
        if (odtProductAddress == null) {
            throw new DeviceNotAvailableException("Device " + n + " was not detected as connected and" + " no address has been stored for it previously!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using " + (odtDetectionResult != null ? "detected" : "stored") + " address for device " + n + ": address = " + odtProductAddress.getDeviceAddress() + ", port = " + odtProductAddress.getPort()));
        }
        try {
            if (!this.disableVerification) {
                this.verifyConnectedDevice(odtProductAddress, productInstanceId, productDescriptor);
            }
            deviceConnection = this.createDeviceConnection(n, productInstanceId, odtProductAddress, productParams);
            this.configureDeviceConnection(deviceConnection);
            Map<Integer, DeviceConnection> map = this.connectedDevices;
            synchronized (map) {
                deviceConnection.start();
                this.connectedDevices.put(n, deviceConnection);
                this.deviceStateManager.setDeviceState(n, DeviceState.CONNECTED);
            }
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            this.odtDeviceDetector.invalidate(odtProductAddress);
            throw deviceNotAvailableException;
        }
        if (!odtProductAddress.equals((Object)odtProductAddress2)) {
            logger.debug((Object)("Updating stored address for device " + n + ": address = " + odtProductAddress.getDeviceAddress() + ", port = " + odtProductAddress.getPort()));
            GenericOdtDeviceAdapter.setProductAddress(registrationData, odtProductAddress);
            this.deviceManager.updateDeviceRegistration(n, registrationData);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection to device " + n + " established:" + " stdout port = " + deviceConnection.getStdoutPortNumber() + ", stderr port = " + deviceConnection.getStderrPortNumber() + ", jdwp port = " + deviceConnection.getJdwpPortNumber() + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionStopped(DeviceConnection deviceConnection) {
        int n = deviceConnection.getDeviceId();
        Map<Integer, DeviceConnection> map = this.connectedDevices;
        synchronized (map) {
            DeviceConnection deviceConnection2 = this.connectedDevices.get(n);
            if (deviceConnection2 != deviceConnection) {
                return;
            }
            this.connectedDevices.remove(n);
            OdtDetectionResult odtDetectionResult = this.odtDeviceDetector.getDetectionResult(deviceConnection.getProductId());
            this.deviceStateManager.setDeviceState(n, odtDetectionResult != null ? DeviceState.AVAILABLE : DeviceState.UNAVAILABLE);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection to device " + n + " removed" + " from the adapter."));
        }
    }

    public DeviceProperties getDeviceProperties(int n) {
        ProductDescriptor productDescriptor = this.getProductDescriptor(n);
        if (productDescriptor == null) {
            throw new IllegalArgumentException("Unknown device " + n + "!");
        }
        ProductParams productParams = this.productsParams.get(productDescriptor);
        if (productParams == null) {
            throw new IllegalStateException("Missing configuration for " + productDescriptor + "!");
        }
        return productParams.getDeviceProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void productDetected(ProductInstanceId productInstanceId, ProductDescriptor productDescriptor) {
        Object object = this.deviceDetectionLock;
        synchronized (object) {
            this.productDetectedImpl(productInstanceId, productDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void productRemoved(ProductInstanceId productInstanceId) {
        Object object = this.deviceDetectionLock;
        synchronized (object) {
            this.productRemovedImpl(productInstanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssignedDeviceId(ProductInstanceId productInstanceId) {
        Object object = this.deviceDetectionLock;
        synchronized (object) {
            Integer n = this.productIdToDeviceId.get(productInstanceId);
            if (n == null) {
                return -1;
            }
            return n;
        }
    }

    protected DeviceConnection createDeviceConnection(int n, ProductInstanceId productInstanceId, OdtProductAddress odtProductAddress, ProductParams productParams) {
        return new DeviceConnection(n, productInstanceId, odtProductAddress, productParams);
    }

    private DeviceConnection[] getCurrentConnections() {
        Collection<DeviceConnection> collection = this.connectedDevices.values();
        DeviceConnection[] deviceConnectionArray = new DeviceConnection[collection.size()];
        collection.toArray(deviceConnectionArray);
        return deviceConnectionArray;
    }

    private String[] createBootClassPath(String[] stringArray) {
        File[] fileArray = FileUtils.getAPIFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            for (String string : stringArray) {
                if (!file.getName().equals(string)) continue;
                arrayList.add(file.getAbsolutePath().replace(File.separatorChar, '/'));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void productDetectedImpl(ProductInstanceId productInstanceId, ProductDescriptor productDescriptor) {
        ProductParams productParams = this.productsParams.get(productDescriptor);
        if (productParams == null) {
            return;
        }
        Integer n = this.productIdToDeviceId.get(productInstanceId);
        if (n != null) {
            this.setUnconnectedDeviceState(n, DeviceState.AVAILABLE);
        } else {
            String string = this.constructDeviceName(productParams.getProductName());
            RegistrationData registrationData = new RegistrationData(string, this.adapterName);
            registrationData.setProperty("PRODUCT_UUID", (Object)productInstanceId.toString());
            registrationData.setProperty("PRODUCT_DESCR", (Object)productDescriptor.toString());
            int n2 = this.deviceManager.allocateDeviceId(registrationData);
            this.productIdToDeviceId.put(productInstanceId, n2);
            this.deviceStateManager.setDeviceState(n2, DeviceState.AVAILABLE);
        }
    }

    private void productRemovedImpl(ProductInstanceId productInstanceId) {
        Integer n = this.productIdToDeviceId.get(productInstanceId);
        if (n != null) {
            this.setUnconnectedDeviceState(n, DeviceState.UNAVAILABLE);
        }
    }

    private String constructDeviceName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 1;
        do {
            stringBuilder.setLength(string.length());
            stringBuilder.append(n++);
        } while (this.deviceManager.lookupDeviceId(stringBuilder.toString()) != -1);
        return stringBuilder.toString();
    }

    private ProductInstanceId getProductInstanceId(int n) {
        RegistrationData registrationData = this.deviceManager.getDeviceRegistration(n);
        if (registrationData == null) {
            return null;
        }
        return GenericOdtDeviceAdapter.getProductInstanceId(registrationData);
    }

    private ProductDescriptor getProductDescriptor(int n) {
        RegistrationData registrationData = this.deviceManager.getDeviceRegistration(n);
        if (registrationData == null) {
            return null;
        }
        return GenericOdtDeviceAdapter.getProductDescriptor(registrationData);
    }

    private void configureDeviceConnection(DeviceConnection deviceConnection) {
        deviceConnection.setJavameServicesBridgeFactory(this.jmeServicesBridgeFactory);
        deviceConnection.setDeviceConnectionManager(this.deviceConnectionManager);
        deviceConnection.setRmiRegistryHost(this.rmiRegistryHost);
        deviceConnection.setRmiRegistryPort(this.rmiRegistryPort);
        deviceConnection.setSocketConfiguration(this.socketConfiguration);
        deviceConnection.setListener(this);
    }

    private void verifyConnectedDevice(OdtProductAddress odtProductAddress, ProductInstanceId productInstanceId, ProductDescriptor productDescriptor) throws DeviceNotAvailableException {
        OdtDetectionResult odtDetectionResult;
        long l = System.currentTimeMillis();
        try {
            odtDetectionResult = this.odtDeviceDetector.executeOdtDetection(odtProductAddress, this.verificationConnectTimeout, null);
        }
        catch (Exception exception) {
            logger.trace((Object)("Failed to execute ODT detection for " + odtProductAddress.getDeviceAddress() + ":" + odtProductAddress.getPort() + "!"), (Throwable)exception);
            throw new DeviceNotAvailableException(exception.getMessage());
        }
        finally {
            l = System.currentTimeMillis() - l;
            logger.debug((Object)("It took " + l + "ms to check " + odtProductAddress.getDeviceAddress()));
        }
        ProductInstanceId productInstanceId2 = odtDetectionResult.getProductInstanceId();
        ProductDescriptor productDescriptor2 = odtDetectionResult.getProductDescriptor();
        if (productInstanceId != null && !productInstanceId.equals((Object)productInstanceId2) || productDescriptor != null && !productDescriptor.equals((Object)productDescriptor2)) {
            throw new DeviceNotAvailableException("Different device connected to " + odtProductAddress.getDeviceAddress() + ":" + odtProductAddress.getPort());
        }
    }

    private static ProductInstanceId getProductInstanceId(RegistrationData registrationData) {
        String string = (String)registrationData.getProperty("PRODUCT_UUID");
        if (string == null) {
            return null;
        }
        return new ProductInstanceId(string);
    }

    private static ProductDescriptor getProductDescriptor(RegistrationData registrationData) {
        String string = (String)registrationData.getProperty("PRODUCT_DESCR");
        if (string == null) {
            return null;
        }
        return new ProductDescriptor(string);
    }

    private static OdtProductAddress getProductAddress(RegistrationData registrationData) {
        int n;
        String string = (String)registrationData.getProperty("DEVICE_ADDR");
        String string2 = (String)registrationData.getProperty("PRODUCT_PORT");
        if (string == null || string2 == null) {
            return null;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new OdtProductAddress((DeviceAddress)new DeviceIpAddress(string), n);
    }

    private static void setProductAddress(RegistrationData registrationData, OdtProductAddress odtProductAddress) {
        DeviceIpAddress deviceIpAddress = (DeviceIpAddress)odtProductAddress.getDeviceAddress();
        registrationData.setProperty("DEVICE_ADDR", (Object)deviceIpAddress.getDeviceAddress());
        registrationData.setProperty("PRODUCT_PORT", (Object)Integer.toString(odtProductAddress.getPort()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnconnectedDeviceState(int n, DeviceState deviceState) {
        Map<Integer, DeviceConnection> map = this.connectedDevices;
        synchronized (map) {
            if (!this.connectedDevices.containsKey(n)) {
                this.deviceStateManager.setDeviceState(n, deviceState);
            }
        }
    }
}

