/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.jsr120.server;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistration;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationManager;
import com.sun.jme.toolkit.jsr120.server.WmaServerMBean;
import com.sun.jme.toolkit.jsr120.shared.WmaClientInterface;
import com.sun.jme.toolkit.jsr120.shared.WmaServerListener;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.common.DatagramRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WmaServer
implements Runnable,
DeviceRegistration,
WmaServerMBean {
    protected static transient DeviceRegistrationManager deviceRegistrationManager;
    protected static transient DeviceConnectionManager deviceConnectionManager;
    private HashSet<String> usedNums;
    private Set<WmaServerListener> listeners = new HashSet<WmaServerListener>();
    public static final int MAX_GUARANTEED_RECEIVABLE_SEGMENTS = 3;
    public static final int WAIT_FOR_SWITCH_TO_LAUNCH_DELAY_MS = 5000;
    private static final int INITIAL_INCOMING_QUEUE_SIZE = 256;
    public static final int POLL_FOR_DEATH_TIMEOUT_MS = 6000;
    private static final Logger LOGGER;
    private static final Debug debug;
    private static final Random cookieGenerator;
    static final Hashtable cookieToMonitorMap;
    private static String cbsTunnelPort;
    private static HashMap clientPorts;
    private static HashMap clientTypes;
    private static boolean checkSegments;
    private static final int BUFFER_SIZE = 1500;
    private static DatagramSocket ackSocket;
    private static int ackPort;
    private static byte[] receiveBuffer;
    private static Vector queue;
    private static Vector timeStampQueue;
    private static Thread controller;
    private static Thread receiver;
    private static Thread router;
    private static HashMap multipartCache;
    public static final String GATEWAY_PHONE_NUMBER = ".Default Gateway.";
    private static int receivePort;
    private int bufferSize;
    private static long packetDelayInMilliseconds;
    private static double randomPacketLoss;
    private static long nextPhoneNumber;
    private static transient DatagramSocket receiveSocket;
    private transient Thread thread;
    private Thread routerThread;
    private int phoneNumber = 123456789;

    public static void setDeviceRegistrationManager(DeviceRegistrationManager deviceRegistrationManager) {
        WmaServer.deviceRegistrationManager = deviceRegistrationManager;
    }

    public static void setDeviceConnectionManager(DeviceConnectionManager deviceConnectionManager) {
        WmaServer.deviceConnectionManager = deviceConnectionManager;
    }

    public void setPort(int n) {
        receivePort = n;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public static void setPacketDelayInMilliseconds(long l) {
        packetDelayInMilliseconds = l;
    }

    public static void setRandomPacketLoss(double d) {
        randomPacketLoss = d;
    }

    public static void setNextPhoneNumber(long l) {
        nextPhoneNumber = l;
    }

    public void start() throws Exception {
        queue = new Vector(256);
        timeStampQueue = new Vector(256);
        this.usedNums = new HashSet();
        receiveSocket = new DatagramSocket(receivePort);
        receiveSocket.setReceiveBufferSize(128 * this.bufferSize);
        this.thread = new Thread((Runnable)this, "WMA datagram receiver");
        this.thread.start();
        this.routerThread = new Thread((Runnable)new DatagramRouter(), "WMA datagram router");
        this.routerThread.start();
    }

    public void stop() throws Exception {
        this.routerThread.interrupt();
        this.routerThread = null;
        this.thread.interrupt();
        this.thread = null;
        receiveSocket.close();
        receiveSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                byte[] byArray = new byte[this.bufferSize];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                receiveSocket.receive(datagramPacket);
                LOGGER.info((Object)("RECEIVED! " + datagramPacket));
                Vector vector = queue;
                synchronized (vector) {
                    queue.addElement(datagramPacket);
                    timeStampQueue.addElement(new Long(System.currentTimeMillis()));
                    queue.notify();
                }
            }
            return;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Wma Server error:", (Throwable)exception);
        }
    }

    static void routeMessage(DatagramPacket datagramPacket) throws Exception {
        LOGGER.debug((Object)("Routing message: " + datagramPacket));
        DatagramRecord datagramRecord = new DatagramRecord();
        datagramRecord.parseData(datagramPacket.getData(), datagramPacket.getLength());
        LOGGER.debug((Object)("received packet length: " + datagramPacket.getLength()));
        LOGGER.debug((Object)("parsed datagram: " + datagramRecord));
        LOGGER.debug((Object)("data length:" + datagramRecord.getData().length));
        String string = datagramRecord.getHeader("Content-Type");
        LOGGER.debug((Object)("Message type: " + string));
        if (string.equals("multipart")) {
            LOGGER.debug((Object)"Processing multipart message");
            WmaServer.routeMultipartSegment(datagramRecord, datagramPacket);
            return;
        }
        if (Math.random() >= randomPacketLoss) {
            LOGGER.debug((Object)"Processing packet");
            String string2 = WmaServer.getDestinationPhoneNumber(datagramRecord);
            LOGGER.debug((Object)("destination: " + string2));
            if (string2 == null) {
                WmaServer.broadcastCBS(datagramRecord);
                return;
            }
            int n = datagramPacket.getPort();
            LOGGER.debug((Object)("Port: " + n));
            String string3 = WmaServer.getClientNumberForPort(n);
            LOGGER.debug((Object)("Origin: " + string3));
            if (string3 != null) {
                int n2 = WmaServer.getClientType(string3);
                LOGGER.debug((Object)"Origin OK");
                if (n2 == 2) {
                    LOGGER.debug((Object)("Got a message from client " + string3 + " who does not have permission to send messages."));
                    debug.println(2, "Got a message from client " + string3 + " who does not have permission to send messages.");
                    throw new Exception("Client " + string3 + " should not be sending messages. Dropping message.");
                }
            }
            LOGGER.debug((Object)"Origin OK");
            WmaServer.checkSegmentation(datagramRecord);
            LOGGER.debug((Object)("sending Message record: " + datagramRecord.toString()));
            WmaServer.routeMessageTo(datagramPacket, string2);
        } else {
            LOGGER.debug((Object)"Simulated dropped packet");
            debug.println(2, "Dropped a packet randomly.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void routeMultipartSegment(DatagramRecord datagramRecord, DatagramPacket datagramPacket) throws Exception {
        int n;
        Object object;
        Object object2;
        String string = datagramRecord.getHeader("Date");
        Object[] objectArray = (Object[])multipartCache.get(string);
        if (objectArray == null) {
            LOGGER.debug((Object)"No previous packets with this timestamp.");
            objectArray = new Object[]{null, new ArrayList()};
            multipartCache.put(string, objectArray);
        }
        DatagramRecord datagramRecord2 = (DatagramRecord)objectArray[0];
        LOGGER.debug((Object)("Previous DGRec has size of: " + (datagramRecord2 != null ? datagramRecord2.getHeader("Total-Size") : " nothing")));
        ArrayList arrayList = (ArrayList)objectArray[1];
        LOGGER.debug((Object)("There are " + arrayList.size() + " packets already waiting."));
        arrayList.add(datagramPacket);
        boolean bl = datagramRecord.addData(datagramRecord2);
        if (!bl) {
            objectArray[0] = datagramRecord;
            LOGGER.debug((Object)"Still expecting more packets.");
            return;
        }
        LOGGER.debug((Object)"That's the whole thing. Parsing...");
        multipartCache.remove(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramRecord.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        String string2 = null;
        try {
            dataInputStream.readUTF();
            String string3 = dataInputStream.readUTF();
            object2 = dataInputStream.readUTF();
            while (string3 != null && !string3.equals("nEntries")) {
                if (string3.equals("To") || string3.equals("Cc") || string3.equals("Bcc")) {
                    int n2 = -2;
                    while (n2 != -1) {
                        int n3 = ((String)object2).indexOf("; ", n2 + 2);
                        object = null;
                        object = n3 == -1 ? ((String)object2).substring(n2 + 2) : ((String)object2).substring(n2 + 2, n3);
                        n2 = n3;
                        try {
                            if (WmaServer.getClientType((String)object) == 1) {
                                LOGGER.warn((Object)("Client " + (String)object + " is send-only. Dropping MMS to him."));
                                continue;
                            }
                            int n4 = WmaServer.getClientPort((String)object);
                            if (!hashSet.add((String)object)) continue;
                            arrayList2.add(n4);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            debug.println(2, "only sending MMS to GATEWAY once, for address: " + (String)object);
                            string2 = object;
                        }
                    }
                }
                string3 = dataInputStream.readUTF();
                object2 = dataInputStream.readUTF();
            }
            dataInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                int n5 = WmaServer.getClientPort(GATEWAY_PHONE_NUMBER);
                if (hashSet.add(string2)) {
                    arrayList2.add(n5);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn((Object)("No gateway. Not sending MMS to " + string2 + "or any other non-local addresses"));
            }
        }
        if ((n = hashSet.size()) == 0) {
            LOGGER.warn((Object)"No destinations to send MMS to.");
            return;
        }
        if (arrayList.size() == 1) {
            LOGGER.info((Object)"Sending MMS without acks: 1 packet");
            for (int i = 0; i < n; ++i) {
                try {
                    WmaServer.sendPacket((DatagramPacket)arrayList.get(0), (Integer)arrayList2.get(i));
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Problem while sending only packet of MMS", (Throwable)exception);
                }
            }
            return;
        }
        object2 = AckNotifier.class;
        synchronized (AckNotifier.class) {
            if (ackSocket == null) {
                try {
                    ackSocket = new DatagramSocket();
                    ackPort = ackSocket.getLocalPort();
                    Thread thread = new Thread(new AckNotifier());
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (SocketException socketException) {
                    LOGGER.warn((Object)"No ACK of MMS packets", (Throwable)socketException);
                }
            }
            // ** MonitorExit[var13_17] (shouldn't be in output)
            object2 = String.valueOf(cookieGenerator.nextInt());
            int[] nArray = new int[]{0};
            cookieToMonitorMap.put(object2, nArray);
            Thread thread = new Thread(new AcknowledgingSender(arrayList2, arrayList, nArray, (String)object2));
            thread.setDaemon(true);
            thread.start();
            object = new Thread(new ZerothPacketSender(arrayList2, (DatagramPacket)arrayList.get(0), (String)object2));
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            return;
        }
    }

    private static String getDestinationPhoneNumber(DatagramRecord datagramRecord) {
        int n;
        String string = datagramRecord.getHeader("Address");
        if (string == null) {
            return null;
        }
        String string2 = string.substring(6);
        if (string2.charAt(0) != '+') {
            string2 = "+" + string2;
        }
        if ((n = string2.indexOf(58)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static void broadcastCBS(DatagramRecord datagramRecord) throws Exception {
        debug.println(3, "It's a CBS message.");
        datagramRecord.setHeader("Address", cbsTunnelPort);
        byte[] byArray = datagramRecord.getFormattedData();
        debug.println(3, "Sending this CBS message: " + datagramRecord.toString());
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), receivePort);
        for (String string : clientTypes.keySet()) {
            if ((Integer)clientTypes.get(string) == 1) continue;
            int n = WmaServer.getClientPort(string);
            datagramPacket.setPort(n);
            receiveSocket.send(datagramPacket);
            debug.println(3, "Sent CBS to " + string);
        }
    }

    private static synchronized String getClientNumberForPort(int n) {
        System.out.println("1");
        System.out.println("clientPorts = " + clientPorts);
        Iterator iterator = clientPorts.keySet().iterator();
        System.out.println("1");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((Integer)clientPorts.get(string) != n) continue;
            return string;
        }
        return null;
    }

    public static synchronized int getClientType(String string) {
        Integer n = (Integer)clientTypes.get(string);
        if (n == null && (n = string.charAt(0) == '+' ? (Integer)clientTypes.get(string.substring(1)) : (Integer)clientTypes.get("+" + string)) == null) {
            throw new IllegalArgumentException("No registered client " + string);
        }
        return n;
    }

    static void checkSegmentation(DatagramRecord datagramRecord) {
        String string;
        if (checkSegments && (string = datagramRecord.getHeader("Content-Type")) != null && (string.equals("text") || string.equals("binary"))) {
            int n = 0;
            String string2 = datagramRecord.getHeader("Segments");
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                    if (n > 3) {
                        LOGGER.warn((Object)("Message has " + n + " segments. " + "Some devices can receive only messages up to " + 3 + " segments."));
                        checkSegments = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    debug.exception(1, (Throwable)numberFormatException);
                }
            }
        }
    }

    private static void routeMessageTo(DatagramPacket datagramPacket, String string) throws Exception {
        LOGGER.debug((Object)("Routing message: " + datagramPacket + " to " + string));
        try {
            WmaServer.sendMessage(datagramPacket, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.println(3, "No client with phone number " + string + " can receive messages, trying gateway...");
            try {
                WmaServer.sendMessage(datagramPacket, GATEWAY_PHONE_NUMBER);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                debug.println(3, "No gateway through which undeliverable messages can be routed. Dropping message.");
            }
        }
    }

    public static synchronized int getClientPort(String string) {
        Integer n = (Integer)clientPorts.get(string);
        if (n == null && (n = string.charAt(0) == '+' ? (Integer)clientPorts.get(string.substring(1)) : (Integer)clientPorts.get("+" + string)) == null) {
            throw new IllegalArgumentException("No registered client " + string);
        }
        return n;
    }

    private static synchronized void sendMessage(DatagramPacket datagramPacket, String string) throws Exception {
        debug.println(2, "Sending message to \"" + string + "\"");
        int n = WmaServer.getClientPort(string);
        int n2 = WmaServer.getClientType(string);
        if (n2 == 1) {
            throw new NullPointerException("Client " + string + " cannot receive messages.");
        }
        WmaServer.sendPacket(datagramPacket, n);
    }

    private static void sendPacket(DatagramPacket datagramPacket, int n) throws Exception {
        LOGGER.debug((Object)("Sending packet, port=" + n));
        datagramPacket.setPort(n);
        receiveSocket.send(datagramPacket);
        LOGGER.debug((Object)"Packet sent.");
    }

    static synchronized boolean isTimeToDie() {
        return Thread.currentThread().isInterrupted();
    }

    public static synchronized boolean registerClient(String string) {
        LOGGER.info((Object)"Attempting to register client and generate a phone number.");
        String string2 = string.charAt(0) == '+' ? string.substring(1) : "+" + string;
        if (clientPorts.containsKey(string) || clientPorts.containsKey(string2)) {
            LOGGER.warn((Object)("Failed to register client " + string));
            return false;
        }
        clientPorts.put(string, null);
        LOGGER.info((Object)("Successfully registered client " + string));
        return true;
    }

    public void addWmaServerListener(WmaServerListener wmaServerListener) {
        this.listeners.add(wmaServerListener);
    }

    public void removeWmaServerListener(WmaServerListener wmaServerListener) {
        this.listeners.remove(wmaServerListener);
    }

    public void registeredDevice(int n) {
        LOGGER.info((Object)("Allocating phone number for device with ID " + n));
        String string = this.toPhoneNumber(n);
        LOGGER.info((Object)("Allocated phone number " + string));
        try {
            ObjectServerConnection objectServerConnection = deviceConnectionManager.openDeviceConnection(n);
            WmaClientInterface wmaClientInterface = (WmaClientInterface)objectServerConnection.findObject(WmaClientInterface.class, "WmaClientBridge");
            wmaClientInterface.setPhoneNumber(string);
            int n2 = wmaClientInterface.getPort();
            LOGGER.info((Object)("Client port: " + n2));
            WmaServer.registerClient(string);
            this.setClientPort(string, n2);
            this.setClientType(string, 3);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception, (Throwable)exception);
        }
    }

    public void unregisteredDevice(int n) {
        LOGGER.info((Object)("Deallocating phone number for device with ID " + n));
        String string = this.toPhoneNumber(n);
        LOGGER.info((Object)("Deallocated phone number " + string));
    }

    public synchronized void setClientPort(String string, int n) {
        debug.println(4, "Setting client " + string + " port to " + n);
        clientPorts.put(string, new Integer(n));
    }

    public synchronized void setClientType(String string, int n) {
        debug.println(4, "Setting client " + string + " type to " + n);
        clientTypes.put(string, new Integer(n));
    }

    private void fireNumberUnregistered(String string) {
        for (WmaServerListener wmaServerListener : this.listeners) {
            wmaServerListener.phoneNumberUnregistered(string);
        }
    }

    private void fireNumberRegistered(String string) {
        for (WmaServerListener wmaServerListener : this.listeners) {
            wmaServerListener.phoneNumberRegistered(string);
        }
    }

    private String getNewPhoneNumber() {
        while (this.usedNums.contains(String.valueOf(this.phoneNumber))) {
            ++this.phoneNumber;
        }
        String string = String.valueOf(this.phoneNumber++);
        this.usedNums.add(string);
        return string;
    }

    public String allocatePhoneNumber() {
        String string = this.getNewPhoneNumber();
        this.fireNumberRegistered(string);
        return string;
    }

    public String allocatePhoneNumber(String string) {
        if (this.usedNums.contains(string)) {
            return this.allocatePhoneNumber();
        }
        this.usedNums.add(string);
        this.fireNumberRegistered(string);
        return string;
    }

    public Set<String> getPhoneNumbers() {
        return (Set)this.usedNums.clone();
    }

    public void freePhoneNumber(String string) {
        this.usedNums.remove(string);
        this.fireNumberUnregistered(string);
    }

    private String toPhoneNumber(int n) {
        return "+" + (123456789 + n);
    }

    static {
        LOGGER = Logger.getLogger(WmaServer.class);
        debug = Debug.create(DatagramRecord.class);
        cookieGenerator = new Random();
        cookieToMonitorMap = new Hashtable();
        cbsTunnelPort = "24680";
        clientPorts = new HashMap();
        clientTypes = new HashMap();
        checkSegments = true;
        ackSocket = null;
        ackPort = 0;
        queue = null;
        timeStampQueue = null;
        controller = null;
        receiver = null;
        router = null;
        multipartCache = new HashMap();
        nextPhoneNumber = 5550000L;
    }

    static class DatagramRouter
    implements Runnable {
        DatagramRouter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!WmaServer.isTimeToDie()) {
                DatagramPacket datagramPacket = null;
                long l = 0L;
                Vector vector = queue;
                synchronized (vector) {
                    while (queue.size() == 0) {
                        try {
                            queue.wait();
                            if (!WmaServer.isTimeToDie()) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    datagramPacket = (DatagramPacket)queue.elementAt(0);
                    queue.removeElementAt(0);
                    l = (Long)timeStampQueue.elementAt(0);
                    timeStampQueue.removeElementAt(0);
                    LOGGER.debug((Object)("Got message to route: " + datagramPacket));
                }
                long l2 = l + packetDelayInMilliseconds;
                long l3 = l2 - System.currentTimeMillis();
                if (l3 > 1L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    WmaServer.routeMessage(datagramPacket);
                }
                catch (Exception exception) {
                    debug.exception(2, (Throwable)exception);
                }
            }
            debug.println(2, "WMA server is no longer routing datagrams now.");
        }
    }

    static class ZerothPacketSender
    implements Runnable {
        private ArrayList ports;
        private DatagramPacket packet;
        private String cookie;

        ZerothPacketSender(ArrayList arrayList, DatagramPacket datagramPacket, String string) {
            this.ports = arrayList;
            this.packet = datagramPacket;
            this.cookie = string;
        }

        @Override
        public void run() {
            debug.println(3, "ZerothPacketSender starting...");
            try {
                Thread.sleep(200L);
                int n = this.ports.size();
                for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)this.ports.get(i);
                    AcknowledgingSender.sendPacketPlusAck(this.packet, n2, this.cookie);
                }
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
            }
            debug.println(3, "ZerothPacketSender done.");
        }
    }

    static class AcknowledgingSender
    implements Runnable {
        private ArrayList ports;
        private ArrayList packets;
        private int[] monitor;
        private String cookie;
        private Map portToPacketNumMap;

        AcknowledgingSender(ArrayList arrayList, ArrayList arrayList2, int[] nArray, String string) {
            this.ports = arrayList;
            this.packets = arrayList2;
            this.monitor = nArray;
            this.cookie = string;
            this.portToPacketNumMap = new HashMap();
            Integer n = new Integer(1);
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Integer n3 = (Integer)arrayList.get(i);
                this.portToPacketNumMap.put(n3, n);
            }
            debug.println(2, "AcknowledgingSender to {0} recipients with {1} packets", n2, arrayList2.size());
            debug.println(2, "Cookie is {0}", (Object)string);
        }

        static void sendPacketPlusAck(DatagramPacket datagramPacket, int n, String string) {
            boolean bl = false;
            DatagramRecord datagramRecord = new DatagramRecord();
            try {
                datagramRecord.parseData(datagramPacket.getData(), datagramPacket.getLength());
                datagramRecord.setHeader("Ack-Port", String.valueOf(ackPort));
                datagramRecord.setHeader("Ack-Cookie", string);
                byte[] byArray = datagramRecord.getFormattedData();
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), receivePort);
                debug.println(3, "Sending packet to port {0}", n);
                WmaServer.sendPacket(datagramPacket2, n);
            }
            catch (Exception exception) {
                debug.exception(3, (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = this.packets.size();
            int[] nArray = this.monitor;
            synchronized (this.monitor) {
                while (this.portToPacketNumMap.size() > 0) {
                    while (this.monitor[0] == 0) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            debug.exception(1, (Throwable)interruptedException);
                        }
                    }
                    Integer n2 = new Integer(this.monitor[0]);
                    int n3 = (Integer)this.portToPacketNumMap.get(n2);
                    debug.println(3, "Notified for port {0} up to packet {1}", (Object)n2, n3);
                    if (n3 < n - 1) {
                        debug.println(3, "Sending next packet with ack.");
                        AcknowledgingSender.sendPacketPlusAck((DatagramPacket)this.packets.get(n3), n2, this.cookie);
                        this.portToPacketNumMap.put(n2, new Integer(n3 + 1));
                    } else {
                        debug.println(3, "Last packet. No ack.");
                        try {
                            WmaServer.sendPacket((DatagramPacket)this.packets.get(n3), n2);
                        }
                        catch (Exception exception) {
                            debug.println(3, "Sending last packet caught: " + exception);
                        }
                        this.portToPacketNumMap.remove(n2);
                    }
                    this.monitor[0] = 0;
                    this.monitor.notify();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                debug.println(2, "Completed AcknowledgingSender with cookie {0}", (Object)this.cookie);
                return;
            }
        }
    }

    static class AckNotifier
    implements Runnable {
        AckNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int[] nArray;
                        byte[] byArray = new byte[40];
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                        ackSocket.receive(datagramPacket);
                        byte[] byArray2 = datagramPacket.getData();
                        String string = new String(byArray2);
                        int n = string.indexOf("\n");
                        String string2 = string.substring(4, n);
                        debug.println(3, "Received ACK for cookie " + string2);
                        int[] nArray2 = nArray = (int[])cookieToMonitorMap.get(string2);
                        // MONITORENTER : nArray
                        while (nArray[0] != 0) {
                            try {
                                nArray.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                debug.exception(1, (Throwable)interruptedException);
                            }
                        }
                        nArray[0] = datagramPacket.getPort();
                        nArray.notify();
                        // MONITOREXIT : nArray2
                    }
                }
                catch (Exception exception) {
                    debug.exception(1, (Throwable)exception);
                    continue;
                }
                break;
            }
        }
    }
}

