/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.mekeytool;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class MeKeyToolWrapper {
    private static final Logger LOGGER = Logger.getLogger(MeKeyToolWrapper.class);
    private CountDownLatch shutdownLatch;
    private ArrayList args;
    private Object meKeytoolImpl;
    private String defaultMeKeystore;
    private String defaultKeystore;
    private AtomicInteger returnCode;

    public void setShutdownLatch(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    public void setArguments(ArrayList arrayList) {
        this.args = arrayList;
    }

    public void setMeKeytoolImpl(Object object) {
        this.meKeytoolImpl = object;
    }

    public void setDefaultMeKeystore(String string) {
        this.defaultMeKeystore = string;
    }

    public String getDefaultMeKeystore() {
        return this.defaultMeKeystore;
    }

    public void setDefaultKeystore(String string) {
        this.defaultKeystore = string;
    }

    public String getDefaultKeystore() {
        return this.defaultKeystore;
    }

    public void setReturnCode(AtomicInteger atomicInteger) {
        this.returnCode = atomicInteger;
    }

    public void start() throws Exception {
        if (this.meKeytoolImpl == null) {
            LOGGER.fatal((Object)"ME keytool implementation wasn't set!");
            return;
        }
        if (this.getDefaultMeKeystore() != null && this.getDefaultMeKeystore().length() > 0) {
            System.setProperty("default.mekeystore", this.getDefaultMeKeystore());
            LOGGER.info((Object)("Set default ME keystore to " + this.getDefaultMeKeystore()));
        }
        if (this.getDefaultKeystore() != null && this.getDefaultKeystore().length() > 0) {
            System.setProperty("default.keystore", this.getDefaultKeystore());
            LOGGER.info((Object)("Set default keystore to " + this.getDefaultKeystore()));
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Method method = MeKeyToolWrapper.this.meKeytoolImpl.getClass().getMethod("main", String[].class);
                    method.invoke(null, new Object[]{MeKeyToolWrapper.this.args.toArray(new String[MeKeyToolWrapper.this.args.size()])});
                    Method method2 = MeKeyToolWrapper.this.meKeytoolImpl.getClass().getMethod("getExitStatus", null);
                    if (method2 != null) {
                        MeKeyToolWrapper.this.returnCode.set((Integer)method2.invoke(MeKeyToolWrapper.this.meKeytoolImpl, null));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Failed to call main MEKeyTool implementation!", (Throwable)exception);
                }
            }
        });
        thread.start();
        thread.join();
        this.shutdownLatch.countDown();
    }
}

